/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class DataSourceBeanCreationFailureAnalyzer
extends AbstractFailureAnalyzer<DataSourceProperties.DataSourceBeanCreationException> {
    private final Environment environment;

    DataSourceBeanCreationFailureAnalyzer(Environment environment2) {
        this.environment = environment2;
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, DataSourceProperties.DataSourceBeanCreationException cause2) {
        return this.getFailureAnalysis(cause2);
    }

    private FailureAnalysis getFailureAnalysis(DataSourceProperties.DataSourceBeanCreationException cause2) {
        String description = this.getDescription(cause2);
        String action = this.getAction(cause2);
        return new FailureAnalysis(description, action, cause2);
    }

    private String getDescription(DataSourceProperties.DataSourceBeanCreationException cause2) {
        StringBuilder description = new StringBuilder();
        description.append("Failed to configure a DataSource: ");
        if (!StringUtils.hasText(cause2.getProperties().getUrl())) {
            description.append("'url' attribute is not specified and ");
        }
        description.append(String.format("no embedded datasource could be configured.%n", new Object[0]));
        description.append(String.format("%nReason: %s%n", cause2.getMessage()));
        return description.toString();
    }

    private String getAction(DataSourceProperties.DataSourceBeanCreationException cause2) {
        StringBuilder action = new StringBuilder();
        action.append(String.format("Consider the following:%n", new Object[0]));
        if (EmbeddedDatabaseConnection.NONE == cause2.getConnection()) {
            action.append(String.format("\tIf you want an embedded database (H2, HSQL or Derby), please put it on the classpath.%n", new Object[0]));
        } else {
            action.append(String.format("\tReview the configuration of %s%n.", new Object[]{cause2.getConnection()}));
        }
        action.append("\tIf you have database settings to be loaded from a particular profile you may need to activate it").append(this.getActiveProfiles());
        return action.toString();
    }

    private String getActiveProfiles() {
        StringBuilder message2 = new StringBuilder();
        Object[] profiles = this.environment.getActiveProfiles();
        if (ObjectUtils.isEmpty(profiles)) {
            message2.append(" (no profiles are currently active).");
        } else {
            message2.append(" (the profiles ");
            message2.append(StringUtils.arrayToCommaDelimitedString(profiles));
            message2.append(" are currently active).");
        }
        return message2.toString();
    }
}

