/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.gson.GsonBuilderCustomizer;
import org.springframework.boot.autoconfigure.gson.GsonProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;

@AutoConfiguration
@ConditionalOnClass(value={Gson.class})
@EnableConfigurationProperties(value={GsonProperties.class})
public class GsonAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GsonBuilder gsonBuilder(List<GsonBuilderCustomizer> customizers) {
        GsonBuilder builder = new GsonBuilder();
        customizers.forEach(c -> c.customize(builder));
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    public Gson gson(GsonBuilder gsonBuilder) {
        return gsonBuilder.create();
    }

    @Bean
    public StandardGsonBuilderCustomizer standardGsonBuilderCustomizer(GsonProperties gsonProperties) {
        return new StandardGsonBuilderCustomizer(gsonProperties);
    }

    static final class StandardGsonBuilderCustomizer
    implements GsonBuilderCustomizer,
    Ordered {
        private final GsonProperties properties;

        StandardGsonBuilderCustomizer(GsonProperties properties) {
            this.properties = properties;
        }

        @Override
        public int getOrder() {
            return 0;
        }

        @Override
        public void customize(GsonBuilder builder) {
            GsonProperties properties = this.properties;
            PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map2.from(properties::getGenerateNonExecutableJson).whenTrue().toCall(builder::generateNonExecutableJson);
            map2.from(properties::getExcludeFieldsWithoutExposeAnnotation).whenTrue().toCall(builder::excludeFieldsWithoutExposeAnnotation);
            map2.from(properties::getSerializeNulls).whenTrue().toCall(builder::serializeNulls);
            map2.from(properties::getEnableComplexMapKeySerialization).whenTrue().toCall(builder::enableComplexMapKeySerialization);
            map2.from(properties::getDisableInnerClassSerialization).whenTrue().toCall(builder::disableInnerClassSerialization);
            map2.from(properties::getLongSerializationPolicy).to(builder::setLongSerializationPolicy);
            map2.from(properties::getFieldNamingPolicy).to(builder::setFieldNamingPolicy);
            map2.from(properties::getPrettyPrinting).whenTrue().toCall(builder::setPrettyPrinting);
            map2.from(properties::getLenient).whenTrue().toCall(builder::setLenient);
            map2.from(properties::getDisableHtmlEscaping).whenTrue().toCall(builder::disableHtmlEscaping);
            map2.from(properties::getDateFormat).to(builder::setDateFormat);
        }
    }
}

