/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.diagnostics.analyzer;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.analyzer.AbstractInjectionFailureAnalyzer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class NoSuchBeanDefinitionFailureAnalyzer
extends AbstractInjectionFailureAnalyzer<NoSuchBeanDefinitionException> {
    private final ConfigurableListableBeanFactory beanFactory;
    private final MetadataReaderFactory metadataReaderFactory;
    private final ConditionEvaluationReport report;

    NoSuchBeanDefinitionFailureAnalyzer(BeanFactory beanFactory) {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.metadataReaderFactory = new CachingMetadataReaderFactory(this.beanFactory.getBeanClassLoader());
        this.report = ConditionEvaluationReport.get(this.beanFactory);
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, NoSuchBeanDefinitionException cause2, String description) {
        Object injectionAnnotations;
        if (cause2.getNumberOfBeansFound() != 0) {
            return null;
        }
        List<AutoConfigurationResult> autoConfigurationResults = this.getAutoConfigurationResults(cause2);
        List<UserConfigurationResult> userConfigurationResults = this.getUserConfigurationResults(cause2);
        StringBuilder message2 = new StringBuilder();
        message2.append(String.format("%s required %s that could not be found.%n", description != null ? description : "A component", this.getBeanDescription(cause2)));
        InjectionPoint injectionPoint = this.findInjectionPoint(rootFailure);
        if (injectionPoint != null && ((Annotation[])(injectionAnnotations = injectionPoint.getAnnotations())).length > 0) {
            message2.append(String.format("%nThe injection point has the following annotations:%n", new Object[0]));
            for (Object injectionAnnotation : injectionAnnotations) {
                message2.append(String.format("\t- %s%n", injectionAnnotation));
            }
        }
        if (!autoConfigurationResults.isEmpty() || !userConfigurationResults.isEmpty()) {
            message2.append(String.format("%nThe following candidates were found but could not be injected:%n", new Object[0]));
            for (AutoConfigurationResult autoConfigurationResult : autoConfigurationResults) {
                message2.append(String.format("\t- %s%n", autoConfigurationResult));
            }
            for (UserConfigurationResult userConfigurationResult : userConfigurationResults) {
                message2.append(String.format("\t- %s%n", userConfigurationResult));
            }
        }
        String action = String.format("Consider %s %s in your configuration.", !autoConfigurationResults.isEmpty() || !userConfigurationResults.isEmpty() ? "revisiting the entries above or defining" : "defining", this.getBeanDescription(cause2));
        return new FailureAnalysis(message2.toString(), action, cause2);
    }

    private String getBeanDescription(NoSuchBeanDefinitionException cause2) {
        if (cause2.getResolvableType() != null) {
            Class<?> type2 = this.extractBeanType(cause2.getResolvableType());
            return "a bean of type '" + type2.getName() + "'";
        }
        return "a bean named '" + cause2.getBeanName() + "'";
    }

    private Class<?> extractBeanType(ResolvableType resolvableType) {
        return resolvableType.getRawClass();
    }

    private List<AutoConfigurationResult> getAutoConfigurationResults(NoSuchBeanDefinitionException cause2) {
        ArrayList<AutoConfigurationResult> results = new ArrayList<AutoConfigurationResult>();
        this.collectReportedConditionOutcomes(cause2, results);
        this.collectExcludedAutoConfiguration(cause2, results);
        return results;
    }

    private List<UserConfigurationResult> getUserConfigurationResults(NoSuchBeanDefinitionException cause2) {
        ResolvableType type2 = cause2.getResolvableType();
        if (type2 == null) {
            return Collections.emptyList();
        }
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, type2);
        return Arrays.stream(beanNames).map(beanName -> new UserConfigurationResult(this.getFactoryMethodMetadata((String)beanName), this.beanFactory.getBean((String)beanName).equals(null))).toList();
    }

    private MethodMetadata getFactoryMethodMetadata(String beanName) {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
            return annotatedBeanDefinition.getFactoryMethodMetadata();
        }
        return null;
    }

    private void collectReportedConditionOutcomes(NoSuchBeanDefinitionException cause2, List<AutoConfigurationResult> results) {
        this.report.getConditionAndOutcomesBySource().forEach((source2, sourceOutcomes) -> this.collectReportedConditionOutcomes(cause2, new Source((String)source2), (ConditionEvaluationReport.ConditionAndOutcomes)sourceOutcomes, results));
    }

    private void collectReportedConditionOutcomes(NoSuchBeanDefinitionException cause2, Source source2, ConditionEvaluationReport.ConditionAndOutcomes sourceOutcomes, List<AutoConfigurationResult> results) {
        if (sourceOutcomes.isFullMatch()) {
            return;
        }
        BeanMethods methods2 = new BeanMethods(source2, cause2);
        for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : sourceOutcomes) {
            if (conditionAndOutcome.getOutcome().isMatch()) continue;
            for (MethodMetadata method2 : methods2) {
                results.add(new AutoConfigurationResult(method2, conditionAndOutcome.getOutcome()));
            }
        }
    }

    private void collectExcludedAutoConfiguration(NoSuchBeanDefinitionException cause2, List<AutoConfigurationResult> results) {
        for (String excludedClass : this.report.getExclusions()) {
            Source source2 = new Source(excludedClass);
            BeanMethods methods2 = new BeanMethods(source2, cause2);
            for (MethodMetadata method2 : methods2) {
                String message2 = String.format("auto-configuration '%s' was excluded", ClassUtils.getShortName(excludedClass));
                results.add(new AutoConfigurationResult(method2, new ConditionOutcome(false, message2)));
            }
        }
    }

    private InjectionPoint findInjectionPoint(Throwable failure) {
        UnsatisfiedDependencyException unsatisfiedDependencyException = this.findCause(failure, UnsatisfiedDependencyException.class);
        if (unsatisfiedDependencyException == null) {
            return null;
        }
        return unsatisfiedDependencyException.getInjectionPoint();
    }

    private static class AutoConfigurationResult {
        private final MethodMetadata methodMetadata;
        private final ConditionOutcome conditionOutcome;

        AutoConfigurationResult(MethodMetadata methodMetadata, ConditionOutcome conditionOutcome) {
            this.methodMetadata = methodMetadata;
            this.conditionOutcome = conditionOutcome;
        }

        public String toString() {
            return String.format("Bean method '%s' in '%s' not loaded because %s", this.methodMetadata.getMethodName(), ClassUtils.getShortName(this.methodMetadata.getDeclaringClassName()), this.conditionOutcome.getMessage());
        }
    }

    private static class UserConfigurationResult {
        private final MethodMetadata methodMetadata;
        private final boolean nullBean;

        UserConfigurationResult(MethodMetadata methodMetadata, boolean nullBean) {
            this.methodMetadata = methodMetadata;
            this.nullBean = nullBean;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("User-defined bean");
            if (this.methodMetadata != null) {
                sb.append(String.format(" method '%s' in '%s'", this.methodMetadata.getMethodName(), ClassUtils.getShortName(this.methodMetadata.getDeclaringClassName())));
            }
            if (this.nullBean) {
                sb.append(" ignored as the bean value is null");
            }
            return sb.toString();
        }
    }

    private class BeanMethods
    implements Iterable<MethodMetadata> {
        private final List<MethodMetadata> methods;

        BeanMethods(Source source2, NoSuchBeanDefinitionException cause2) {
            this.methods = this.findBeanMethods(source2, cause2);
        }

        private List<MethodMetadata> findBeanMethods(Source source2, NoSuchBeanDefinitionException cause2) {
            try {
                MetadataReader classMetadata = NoSuchBeanDefinitionFailureAnalyzer.this.metadataReaderFactory.getMetadataReader(source2.getClassName());
                Set<MethodMetadata> candidates = classMetadata.getAnnotationMetadata().getAnnotatedMethods(Bean.class.getName());
                ArrayList<MethodMetadata> result2 = new ArrayList<MethodMetadata>();
                for (MethodMetadata candidate : candidates) {
                    if (!this.isMatch(candidate, source2, cause2)) continue;
                    result2.add(candidate);
                }
                return Collections.unmodifiableList(result2);
            }
            catch (Exception ex) {
                return Collections.emptyList();
            }
        }

        private boolean isMatch(MethodMetadata candidate, Source source2, NoSuchBeanDefinitionException cause2) {
            if (source2.getMethodName() != null && !source2.getMethodName().equals(candidate.getMethodName())) {
                return false;
            }
            String name2 = cause2.getBeanName();
            ResolvableType resolvableType = cause2.getResolvableType();
            return name2 != null && this.hasName(candidate, name2) || resolvableType != null && this.hasType(candidate, NoSuchBeanDefinitionFailureAnalyzer.this.extractBeanType(resolvableType));
        }

        private boolean hasName(MethodMetadata methodMetadata, String name2) {
            String[] candidates;
            Map<String, Object> attributes = methodMetadata.getAnnotationAttributes(Bean.class.getName());
            String[] stringArray = candidates = attributes != null ? (String[])attributes.get("name") : null;
            if (candidates != null) {
                for (String candidate : candidates) {
                    if (!candidate.equals(name2)) continue;
                    return true;
                }
                return false;
            }
            return methodMetadata.getMethodName().equals(name2);
        }

        private boolean hasType(MethodMetadata candidate, Class<?> type2) {
            String returnTypeName = candidate.getReturnTypeName();
            if (type2.getName().equals(returnTypeName)) {
                return true;
            }
            try {
                Class<?> returnType = ClassUtils.forName(returnTypeName, NoSuchBeanDefinitionFailureAnalyzer.this.beanFactory.getBeanClassLoader());
                return type2.isAssignableFrom(returnType);
            }
            catch (Throwable ex) {
                return false;
            }
        }

        @Override
        public Iterator<MethodMetadata> iterator() {
            return this.methods.iterator();
        }
    }

    private static class Source {
        private final String className;
        private final String methodName;

        Source(String source2) {
            String[] tokens = source2.split("#");
            this.className = tokens.length > 1 ? tokens[0] : source2;
            this.methodName = tokens.length != 2 ? null : tokens[1];
        }

        String getClassName() {
            return this.className;
        }

        String getMethodName() {
            return this.methodName;
        }
    }
}

