/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.codec.JacksonJsonSerializer;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonValueModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.couchbase.ClusterEnvironmentBuilderCustomizer;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseConnectionDetails;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseProperties;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={JacksonAutoConfiguration.class})
@ConditionalOnClass(value={Cluster.class})
@Conditional(value={CouchbaseCondition.class})
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class CouchbaseAutoConfiguration {
    private final CouchbaseProperties properties;

    CouchbaseAutoConfiguration(CouchbaseProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={CouchbaseConnectionDetails.class})
    PropertiesCouchbaseConnectionDetails couchbaseConnectionDetails() {
        return new PropertiesCouchbaseConnectionDetails(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ClusterEnvironment couchbaseClusterEnvironment(CouchbaseConnectionDetails connectionDetails, ObjectProvider<ClusterEnvironmentBuilderCustomizer> customizers, ObjectProvider<SslBundles> sslBundles) {
        ClusterEnvironment.Builder builder = this.initializeEnvironmentBuilder(connectionDetails, sslBundles.getIfAvailable());
        customizers.orderedStream().forEach(customizer2 -> customizer2.customize(builder));
        return builder.build();
    }

    @Bean(destroyMethod="disconnect")
    @ConditionalOnMissingBean
    public Cluster couchbaseCluster(ClusterEnvironment couchbaseClusterEnvironment, CouchbaseConnectionDetails connectionDetails) {
        ClusterOptions options2 = ClusterOptions.clusterOptions((String)connectionDetails.getUsername(), (String)connectionDetails.getPassword()).environment(couchbaseClusterEnvironment);
        return Cluster.connect((String)connectionDetails.getConnectionString(), (ClusterOptions)options2);
    }

    private ClusterEnvironment.Builder initializeEnvironmentBuilder(CouchbaseConnectionDetails connectionDetails, SslBundles sslBundles) {
        ClusterEnvironment.Builder builder = ClusterEnvironment.builder();
        CouchbaseProperties.Timeouts timeouts = this.properties.getEnv().getTimeouts();
        builder.timeoutConfig(config -> config.kvTimeout(timeouts.getKeyValue()).analyticsTimeout(timeouts.getAnalytics()).kvDurableTimeout(timeouts.getKeyValueDurable()).queryTimeout(timeouts.getQuery()).viewTimeout(timeouts.getView()).searchTimeout(timeouts.getSearch()).managementTimeout(timeouts.getManagement()).connectTimeout(timeouts.getConnect()).disconnectTimeout(timeouts.getDisconnect()));
        CouchbaseProperties.Io io2 = this.properties.getEnv().getIo();
        builder.ioConfig(config -> config.maxHttpConnections(io2.getMaxEndpoints()).numKvConnections(io2.getMinEndpoints()).idleHttpConnectionTimeout(io2.getIdleHttpConnectionTimeout()));
        if (this.properties.getEnv().getSsl().getEnabled().booleanValue()) {
            this.configureSsl(builder, sslBundles);
        }
        return builder;
    }

    private void configureSsl(ClusterEnvironment.Builder builder, SslBundles sslBundles) {
        CouchbaseProperties.Ssl sslProperties = this.properties.getEnv().getSsl();
        SslBundle sslBundle = StringUtils.hasText(sslProperties.getBundle()) ? sslBundles.getBundle(sslProperties.getBundle()) : null;
        Assert.state(sslBundle == null || !sslBundle.getOptions().isSpecified(), "SSL Options cannot be specified with Couchbase");
        builder.securityConfig(config -> {
            config.enableTls(true);
            TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(sslBundle);
            if (trustManagerFactory != null) {
                config.trustManagerFactory(trustManagerFactory);
            }
        });
    }

    private TrustManagerFactory getTrustManagerFactory(SslBundle sslBundle) {
        return sslBundle != null ? sslBundle.getManagers().getTrustManagerFactory() : null;
    }

    static final class PropertiesCouchbaseConnectionDetails
    implements CouchbaseConnectionDetails {
        private final CouchbaseProperties properties;

        PropertiesCouchbaseConnectionDetails(CouchbaseProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getConnectionString() {
            return this.properties.getConnectionString();
        }

        @Override
        public String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }
    }

    static final class CouchbaseCondition
    extends AnyNestedCondition {
        CouchbaseCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CouchbaseConnectionDetails.class})
        private static final class CouchbaseConnectionDetailsCondition {
            private CouchbaseConnectionDetailsCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.couchbase", name={"connection-string"})
        private static final class CouchbaseUrlCondition {
            private CouchbaseUrlCondition() {
            }
        }
    }

    private static final class JacksonClusterEnvironmentBuilderCustomizer
    implements ClusterEnvironmentBuilderCustomizer,
    Ordered {
        private final ObjectMapper objectMapper;

        private JacksonClusterEnvironmentBuilderCustomizer(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public void customize(ClusterEnvironment.Builder builder) {
            builder.jsonSerializer((JsonSerializer)JacksonJsonSerializer.create((ObjectMapper)this.objectMapper));
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonConfiguration {
        JacksonConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate(value=ObjectMapper.class)
        ClusterEnvironmentBuilderCustomizer jacksonClusterEnvironmentBuilderCustomizer(ObjectMapper objectMapper) {
            return new JacksonClusterEnvironmentBuilderCustomizer(objectMapper.copy().registerModule((Module)new JsonValueModule()));
        }
    }
}

