/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.FilteringSpringBootCondition;
import org.springframework.boot.web.reactive.context.ConfigurableReactiveWebEnvironment;
import org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.ConfigurableWebEnvironment;
import org.springframework.web.context.WebApplicationContext;

@Order(value=-2147483628)
class OnWebApplicationCondition
extends FilteringSpringBootCondition {
    private static final String SERVLET_WEB_APPLICATION_CLASS = "org.springframework.web.context.support.GenericWebApplicationContext";
    private static final String REACTIVE_WEB_APPLICATION_CLASS = "org.springframework.web.reactive.HandlerResult";

    OnWebApplicationCondition() {
    }

    @Override
    protected ConditionOutcome[] getOutcomes(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionOutcome[] outcomes = new ConditionOutcome[autoConfigurationClasses.length];
        for (int i2 = 0; i2 < outcomes.length; ++i2) {
            String autoConfigurationClass = autoConfigurationClasses[i2];
            if (autoConfigurationClass == null) continue;
            outcomes[i2] = this.getOutcome(autoConfigurationMetadata.get(autoConfigurationClass, "ConditionalOnWebApplication"));
        }
        return outcomes;
    }

    private ConditionOutcome getOutcome(String type2) {
        if (type2 == null) {
            return null;
        }
        ConditionMessage.Builder message2 = ConditionMessage.forCondition(ConditionalOnWebApplication.class, new Object[0]);
        if (ConditionalOnWebApplication.Type.SERVLET.name().equals(type2) && !FilteringSpringBootCondition.ClassNameFilter.isPresent(SERVLET_WEB_APPLICATION_CLASS, this.getBeanClassLoader())) {
            return ConditionOutcome.noMatch(message2.didNotFind("servlet web application classes").atAll());
        }
        if (ConditionalOnWebApplication.Type.REACTIVE.name().equals(type2) && !FilteringSpringBootCondition.ClassNameFilter.isPresent(REACTIVE_WEB_APPLICATION_CLASS, this.getBeanClassLoader())) {
            return ConditionOutcome.noMatch(message2.didNotFind("reactive web application classes").atAll());
        }
        if (!FilteringSpringBootCondition.ClassNameFilter.isPresent(SERVLET_WEB_APPLICATION_CLASS, this.getBeanClassLoader()) && !ClassUtils.isPresent(REACTIVE_WEB_APPLICATION_CLASS, this.getBeanClassLoader())) {
            return ConditionOutcome.noMatch(message2.didNotFind("reactive or servlet web application classes").atAll());
        }
        return null;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean required = metadata.isAnnotated(ConditionalOnWebApplication.class.getName());
        ConditionOutcome outcome = this.isWebApplication(context, metadata, required);
        if (required && !outcome.isMatch()) {
            return ConditionOutcome.noMatch(outcome.getConditionMessage());
        }
        if (!required && outcome.isMatch()) {
            return ConditionOutcome.noMatch(outcome.getConditionMessage());
        }
        return ConditionOutcome.match(outcome.getConditionMessage());
    }

    private ConditionOutcome isWebApplication(ConditionContext context, AnnotatedTypeMetadata metadata, boolean required) {
        return switch (this.deduceType(metadata)) {
            case ConditionalOnWebApplication.Type.SERVLET -> this.isServletWebApplication(context);
            case ConditionalOnWebApplication.Type.REACTIVE -> this.isReactiveWebApplication(context);
            default -> this.isAnyWebApplication(context, required);
        };
    }

    private ConditionOutcome isAnyWebApplication(ConditionContext context, boolean required) {
        ConditionMessage.Builder message2 = ConditionMessage.forCondition(ConditionalOnWebApplication.class, required ? "(required)" : "");
        ConditionOutcome servletOutcome = this.isServletWebApplication(context);
        if (servletOutcome.isMatch() && required) {
            return new ConditionOutcome(servletOutcome.isMatch(), message2.because(servletOutcome.getMessage()));
        }
        ConditionOutcome reactiveOutcome = this.isReactiveWebApplication(context);
        if (reactiveOutcome.isMatch() && required) {
            return new ConditionOutcome(reactiveOutcome.isMatch(), message2.because(reactiveOutcome.getMessage()));
        }
        return new ConditionOutcome(servletOutcome.isMatch() || reactiveOutcome.isMatch(), message2.because(servletOutcome.getMessage()).append("and").append(reactiveOutcome.getMessage()));
    }

    private ConditionOutcome isServletWebApplication(ConditionContext context) {
        Object[] scopes;
        ConditionMessage.Builder message2 = ConditionMessage.forCondition("", new Object[0]);
        if (!FilteringSpringBootCondition.ClassNameFilter.isPresent(SERVLET_WEB_APPLICATION_CLASS, context.getClassLoader())) {
            return ConditionOutcome.noMatch(message2.didNotFind("servlet web application classes").atAll());
        }
        if (context.getBeanFactory() != null && ObjectUtils.containsElement(scopes = context.getBeanFactory().getRegisteredScopeNames(), "session")) {
            return ConditionOutcome.match(message2.foundExactly("'session' scope"));
        }
        if (context.getEnvironment() instanceof ConfigurableWebEnvironment) {
            return ConditionOutcome.match(message2.foundExactly("ConfigurableWebEnvironment"));
        }
        if (context.getResourceLoader() instanceof WebApplicationContext) {
            return ConditionOutcome.match(message2.foundExactly("WebApplicationContext"));
        }
        return ConditionOutcome.noMatch(message2.because("not a servlet web application"));
    }

    private ConditionOutcome isReactiveWebApplication(ConditionContext context) {
        ConditionMessage.Builder message2 = ConditionMessage.forCondition("", new Object[0]);
        if (!FilteringSpringBootCondition.ClassNameFilter.isPresent(REACTIVE_WEB_APPLICATION_CLASS, context.getClassLoader())) {
            return ConditionOutcome.noMatch(message2.didNotFind("reactive web application classes").atAll());
        }
        if (context.getEnvironment() instanceof ConfigurableReactiveWebEnvironment) {
            return ConditionOutcome.match(message2.foundExactly("ConfigurableReactiveWebEnvironment"));
        }
        if (context.getResourceLoader() instanceof ReactiveWebApplicationContext) {
            return ConditionOutcome.match(message2.foundExactly("ReactiveWebApplicationContext"));
        }
        return ConditionOutcome.noMatch(message2.because("not a reactive web application"));
    }

    private ConditionalOnWebApplication.Type deduceType(AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnWebApplication.class.getName());
        if (attributes != null) {
            return (ConditionalOnWebApplication.Type)((Object)attributes.get("type"));
        }
        return ConditionalOnWebApplication.Type.ANY;
    }
}

