/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Order(value=-2147483608)
class OnPropertyCondition
extends SpringBootCondition {
    OnPropertyCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<AnnotationAttributes> allAnnotationAttributes = metadata.getAnnotations().stream(ConditionalOnProperty.class.getName()).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).map(rec$ -> ((MergedAnnotation)rec$).asAnnotationAttributes(new MergedAnnotation.Adapt[0])).toList();
        ArrayList noMatch = new ArrayList();
        ArrayList<ConditionMessage> match2 = new ArrayList<ConditionMessage>();
        for (AnnotationAttributes annotationAttributes : allAnnotationAttributes) {
            ConditionOutcome outcome = this.determineOutcome(annotationAttributes, context.getEnvironment());
            (outcome.isMatch() ? match2 : noMatch).add(outcome.getConditionMessage());
        }
        if (!noMatch.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.of(noMatch));
        }
        return ConditionOutcome.match(ConditionMessage.of(match2));
    }

    private ConditionOutcome determineOutcome(AnnotationAttributes annotationAttributes, PropertyResolver resolver) {
        Spec spec = new Spec(annotationAttributes);
        ArrayList<String> missingProperties = new ArrayList<String>();
        ArrayList<String> nonMatchingProperties = new ArrayList<String>();
        spec.collectProperties(resolver, missingProperties, nonMatchingProperties);
        if (!missingProperties.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnProperty.class, spec).didNotFind("property", "properties").items(ConditionMessage.Style.QUOTE, missingProperties));
        }
        if (!nonMatchingProperties.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnProperty.class, spec).found("different value in property", "different value in properties").items(ConditionMessage.Style.QUOTE, nonMatchingProperties));
        }
        return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnProperty.class, spec).because("matched"));
    }

    private static class Spec {
        private final String prefix;
        private final String havingValue;
        private final String[] names;
        private final boolean matchIfMissing;

        Spec(AnnotationAttributes annotationAttributes) {
            Object prefix = annotationAttributes.getString("prefix").trim();
            if (StringUtils.hasText((String)prefix) && !((String)prefix).endsWith(".")) {
                prefix = (String)prefix + ".";
            }
            this.prefix = prefix;
            this.havingValue = annotationAttributes.getString("havingValue");
            this.names = this.getNames(annotationAttributes);
            this.matchIfMissing = annotationAttributes.getBoolean("matchIfMissing");
        }

        private String[] getNames(Map<String, Object> annotationAttributes) {
            String[] value2 = (String[])annotationAttributes.get("value");
            String[] name2 = (String[])annotationAttributes.get("name");
            Assert.state(value2.length > 0 || name2.length > 0, "The name or value attribute of @ConditionalOnProperty must be specified");
            Assert.state(value2.length == 0 || name2.length == 0, "The name and value attributes of @ConditionalOnProperty are exclusive");
            return value2.length > 0 ? value2 : name2;
        }

        private void collectProperties(PropertyResolver resolver, List<String> missing, List<String> nonMatching) {
            for (String name2 : this.names) {
                String key2 = this.prefix + name2;
                if (resolver.containsProperty(key2)) {
                    if (this.isMatch(resolver.getProperty(key2), this.havingValue)) continue;
                    nonMatching.add(name2);
                    continue;
                }
                if (this.matchIfMissing) continue;
                missing.add(name2);
            }
        }

        private boolean isMatch(String value2, String requiredValue) {
            if (StringUtils.hasLength(requiredValue)) {
                return requiredValue.equalsIgnoreCase(value2);
            }
            return !"false".equalsIgnoreCase(value2);
        }

        public String toString() {
            StringBuilder result2 = new StringBuilder();
            result2.append("(");
            result2.append(this.prefix);
            if (this.names.length == 1) {
                result2.append(this.names[0]);
            } else {
                result2.append("[");
                result2.append(StringUtils.arrayToCommaDelimitedString(this.names));
                result2.append("]");
            }
            if (StringUtils.hasLength(this.havingValue)) {
                result2.append("=").append(this.havingValue);
            }
            result2.append(")");
            return result2.toString();
        }
    }
}

