/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.FilteringSpringBootCondition;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFF)
class OnBeanCondition
extends FilteringSpringBootCondition
implements ConfigurationCondition {
    OnBeanCondition() {
    }

    @Override
    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    @Override
    protected final ConditionOutcome[] getOutcomes(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionOutcome[] outcomes = new ConditionOutcome[autoConfigurationClasses.length];
        for (int i2 = 0; i2 < outcomes.length; ++i2) {
            String autoConfigurationClass = autoConfigurationClasses[i2];
            if (autoConfigurationClass == null) continue;
            Set<String> onBeanTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnBean");
            outcomes[i2] = this.getOutcome(onBeanTypes, ConditionalOnBean.class);
            if (outcomes[i2] != null) continue;
            Set<String> onSingleCandidateTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnSingleCandidate");
            outcomes[i2] = this.getOutcome(onSingleCandidateTypes, ConditionalOnSingleCandidate.class);
        }
        return outcomes;
    }

    private ConditionOutcome getOutcome(Set<String> requiredBeanTypes, Class<? extends Annotation> annotation) {
        List<String> missing = this.filter(requiredBeanTypes, FilteringSpringBootCondition.ClassNameFilter.MISSING, this.getBeanClassLoader());
        if (!missing.isEmpty()) {
            ConditionMessage message2 = ConditionMessage.forCondition(annotation, new Object[0]).didNotFind("required type", "required types").items(ConditionMessage.Style.QUOTE, missing);
            return ConditionOutcome.noMatch(message2);
        }
        return null;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MatchResult matchResult;
        Spec spec;
        ConditionMessage matchMessage = ConditionMessage.empty();
        MergedAnnotations annotations = metadata.getAnnotations();
        if (annotations.isPresent(ConditionalOnBean.class)) {
            spec = new Spec(context, metadata, annotations, ConditionalOnBean.class);
            matchResult = this.getMatchingBeans(context, spec);
            if (!matchResult.isAllMatched()) {
                String reason2 = this.createOnBeanNoMatchReason(matchResult);
                return ConditionOutcome.noMatch(spec.message().because(reason2));
            }
            matchMessage = spec.message(matchMessage).found("bean", "beans").items(ConditionMessage.Style.QUOTE, matchResult.getNamesOfAllMatches());
        }
        if (metadata.isAnnotated(ConditionalOnSingleCandidate.class.getName())) {
            spec = new SingleCandidateSpec(context, metadata, annotations);
            matchResult = this.getMatchingBeans(context, spec);
            if (!matchResult.isAllMatched()) {
                return ConditionOutcome.noMatch(spec.message().didNotFind("any beans").atAll());
            }
            Set<String> allBeans = matchResult.getNamesOfAllMatches();
            if (allBeans.size() == 1) {
                matchMessage = spec.message(matchMessage).found("a single bean").items(ConditionMessage.Style.QUOTE, allBeans);
            } else {
                List<String> primaryBeans = this.getPrimaryBeans(context.getBeanFactory(), allBeans, spec.getStrategy() == SearchStrategy.ALL);
                if (primaryBeans.isEmpty()) {
                    return ConditionOutcome.noMatch(spec.message().didNotFind("a primary bean from beans").items(ConditionMessage.Style.QUOTE, allBeans));
                }
                if (primaryBeans.size() > 1) {
                    return ConditionOutcome.noMatch(spec.message().found("multiple primary beans").items(ConditionMessage.Style.QUOTE, primaryBeans));
                }
                matchMessage = spec.message(matchMessage).found("a single primary bean '" + primaryBeans.get(0) + "' from beans").items(ConditionMessage.Style.QUOTE, allBeans);
            }
        }
        if (metadata.isAnnotated(ConditionalOnMissingBean.class.getName())) {
            spec = new Spec<ConditionalOnMissingBean>(context, metadata, annotations, ConditionalOnMissingBean.class);
            matchResult = this.getMatchingBeans(context, spec);
            if (matchResult.isAnyMatched()) {
                String reason3 = this.createOnMissingBeanNoMatchReason(matchResult);
                return ConditionOutcome.noMatch(spec.message().because(reason3));
            }
            matchMessage = spec.message(matchMessage).didNotFind("any beans").atAll();
        }
        return ConditionOutcome.match(matchMessage);
    }

    protected final MatchResult getMatchingBeans(ConditionContext context, Spec<?> spec) {
        ClassLoader classLoader = context.getClassLoader();
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        boolean considerHierarchy = spec.getStrategy() != SearchStrategy.CURRENT;
        Set<Class<?>> parameterizedContainers = spec.getParameterizedContainers();
        if (spec.getStrategy() == SearchStrategy.ANCESTORS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, "Unable to use SearchStrategy.ANCESTORS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        MatchResult result2 = new MatchResult();
        Set<String> beansIgnoredByType = this.getNamesOfBeansIgnoredByType(classLoader, beanFactory, considerHierarchy, spec.getIgnoredTypes(), parameterizedContainers);
        for (String type2 : spec.getTypes()) {
            Set<String> typeMatches = this.getBeanNamesForType(classLoader, considerHierarchy, beanFactory, type2, parameterizedContainers);
            typeMatches.removeIf(match2 -> beansIgnoredByType.contains(match2) || ScopedProxyUtils.isScopedTarget(match2));
            if (typeMatches.isEmpty()) {
                result2.recordUnmatchedType(type2);
                continue;
            }
            result2.recordMatchedType(type2, typeMatches);
        }
        for (String annotation : spec.getAnnotations()) {
            Set<String> annotationMatches = this.getBeanNamesForAnnotation(classLoader, beanFactory, annotation, considerHierarchy);
            annotationMatches.removeAll(beansIgnoredByType);
            if (annotationMatches.isEmpty()) {
                result2.recordUnmatchedAnnotation(annotation);
                continue;
            }
            result2.recordMatchedAnnotation(annotation, annotationMatches);
        }
        for (String beanName : spec.getNames()) {
            if (!beansIgnoredByType.contains(beanName) && this.containsBean(beanFactory, beanName, considerHierarchy)) {
                result2.recordMatchedName(beanName);
                continue;
            }
            result2.recordUnmatchedName(beanName);
        }
        return result2;
    }

    private Set<String> getNamesOfBeansIgnoredByType(ClassLoader classLoader, ListableBeanFactory beanFactory, boolean considerHierarchy, Set<String> ignoredTypes, Set<Class<?>> parameterizedContainers) {
        Set<String> result2 = null;
        for (String ignoredType : ignoredTypes) {
            Set<String> ignoredNames = this.getBeanNamesForType(classLoader, considerHierarchy, beanFactory, ignoredType, parameterizedContainers);
            result2 = OnBeanCondition.addAll(result2, ignoredNames);
        }
        return result2 != null ? result2 : Collections.emptySet();
    }

    private Set<String> getBeanNamesForType(ClassLoader classLoader, boolean considerHierarchy, ListableBeanFactory beanFactory, String type2, Set<Class<?>> parameterizedContainers) throws LinkageError {
        try {
            return this.getBeanNamesForType(beanFactory, considerHierarchy, OnBeanCondition.resolve(type2, classLoader), parameterizedContainers);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            return Collections.emptySet();
        }
    }

    private Set<String> getBeanNamesForType(ListableBeanFactory beanFactory, boolean considerHierarchy, Class<?> type2, Set<Class<?>> parameterizedContainers) {
        Set<String> result2 = this.collectBeanNamesForType(beanFactory, considerHierarchy, type2, parameterizedContainers, null);
        return result2 != null ? result2 : Collections.emptySet();
    }

    private Set<String> collectBeanNamesForType(ListableBeanFactory beanFactory, boolean considerHierarchy, Class<?> type2, Set<Class<?>> parameterizedContainers, Set<String> result2) {
        HierarchicalBeanFactory hierarchicalBeanFactory;
        BeanFactory parent;
        result2 = OnBeanCondition.addAll(result2, beanFactory.getBeanNamesForType(type2, true, false));
        for (Class<?> container : parameterizedContainers) {
            ResolvableType generic = ResolvableType.forClassWithGenerics(container, type2);
            result2 = OnBeanCondition.addAll(result2, beanFactory.getBeanNamesForType(generic, true, false));
        }
        if (considerHierarchy && beanFactory instanceof HierarchicalBeanFactory && (parent = (hierarchicalBeanFactory = (HierarchicalBeanFactory)((Object)beanFactory)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)parent;
            result2 = this.collectBeanNamesForType(listableBeanFactory, considerHierarchy, type2, parameterizedContainers, result2);
        }
        return result2;
    }

    private Set<String> getBeanNamesForAnnotation(ClassLoader classLoader, ConfigurableListableBeanFactory beanFactory, String type2, boolean considerHierarchy) throws LinkageError {
        Set<String> result2 = null;
        try {
            result2 = this.collectBeanNamesForAnnotation(beanFactory, this.resolveAnnotationType(classLoader, type2), considerHierarchy, result2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result2 != null ? result2 : Collections.emptySet();
    }

    private Class<? extends Annotation> resolveAnnotationType(ClassLoader classLoader, String type2) throws ClassNotFoundException {
        return OnBeanCondition.resolve(type2, classLoader);
    }

    private Set<String> collectBeanNamesForAnnotation(ListableBeanFactory beanFactory, Class<? extends Annotation> annotationType, boolean considerHierarchy, Set<String> result2) {
        BeanFactory parent;
        result2 = OnBeanCondition.addAll(result2, this.getBeanNamesForAnnotation(beanFactory, annotationType));
        if (considerHierarchy && (parent = ((HierarchicalBeanFactory)((Object)beanFactory)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)parent;
            result2 = this.collectBeanNamesForAnnotation(listableBeanFactory, annotationType, considerHierarchy, result2);
        }
        return result2;
    }

    private String[] getBeanNamesForAnnotation(ListableBeanFactory beanFactory, Class<? extends Annotation> annotationType) {
        LinkedHashSet<String> foundBeanNames = new LinkedHashSet<String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            ConfigurableListableBeanFactory configurableListableBeanFactory;
            BeanDefinition beanDefinition;
            if (beanFactory instanceof ConfigurableListableBeanFactory && (beanDefinition = (configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName)) != null && beanDefinition.isAbstract() || beanFactory.findAnnotationOnBean(beanName, annotationType, false) == null) continue;
            foundBeanNames.add(beanName);
        }
        if (beanFactory instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)((Object)beanFactory);
            for (String beanName : singletonBeanRegistry.getSingletonNames()) {
                if (beanFactory.findAnnotationOnBean(beanName, annotationType) == null) continue;
                foundBeanNames.add(beanName);
            }
        }
        return (String[])foundBeanNames.toArray(String[]::new);
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private String createOnBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason2 = new StringBuilder();
        this.appendMessageForNoMatches(reason2, matchResult.getUnmatchedAnnotations(), "annotated with");
        this.appendMessageForNoMatches(reason2, matchResult.getUnmatchedTypes(), "of type");
        this.appendMessageForNoMatches(reason2, matchResult.getUnmatchedNames(), "named");
        return reason2.toString();
    }

    private void appendMessageForNoMatches(StringBuilder reason2, Collection<String> unmatched, String description) {
        if (!unmatched.isEmpty()) {
            if (!reason2.isEmpty()) {
                reason2.append(" and ");
            }
            reason2.append("did not find any beans ");
            reason2.append(description);
            reason2.append(" ");
            reason2.append(StringUtils.collectionToDelimitedString(unmatched, ", "));
        }
    }

    private String createOnMissingBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason2 = new StringBuilder();
        this.appendMessageForMatches(reason2, matchResult.getMatchedAnnotations(), "annotated with");
        this.appendMessageForMatches(reason2, matchResult.getMatchedTypes(), "of type");
        if (!matchResult.getMatchedNames().isEmpty()) {
            if (!reason2.isEmpty()) {
                reason2.append(" and ");
            }
            reason2.append("found beans named ");
            reason2.append(StringUtils.collectionToDelimitedString(matchResult.getMatchedNames(), ", "));
        }
        return reason2.toString();
    }

    private void appendMessageForMatches(StringBuilder reason2, Map<String, Collection<String>> matches, String description) {
        if (!matches.isEmpty()) {
            matches.forEach((key2, value2) -> {
                if (!reason2.isEmpty()) {
                    reason2.append(" and ");
                }
                reason2.append("found beans ");
                reason2.append(description);
                reason2.append(" '");
                reason2.append((String)key2);
                reason2.append("' ");
                reason2.append(StringUtils.collectionToDelimitedString(value2, ", "));
            });
        }
    }

    private List<String> getPrimaryBeans(ConfigurableListableBeanFactory beanFactory, Set<String> beanNames, boolean considerHierarchy) {
        ArrayList<String> primaryBeans = new ArrayList<String>();
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = this.findBeanDefinition(beanFactory, beanName, considerHierarchy);
            if (beanDefinition == null || !beanDefinition.isPrimary()) continue;
            primaryBeans.add(beanName);
        }
        return primaryBeans;
    }

    private BeanDefinition findBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        BeanFactory beanFactory2;
        if (beanFactory.containsBeanDefinition(beanName)) {
            return beanFactory.getBeanDefinition(beanName);
        }
        if (considerHierarchy && (beanFactory2 = beanFactory.getParentBeanFactory()) instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory listableBeanFactory = (ConfigurableListableBeanFactory)beanFactory2;
            return this.findBeanDefinition(listableBeanFactory, beanName, considerHierarchy);
        }
        return null;
    }

    private static Set<String> addAll(Set<String> result2, Collection<String> additional) {
        if (CollectionUtils.isEmpty(additional)) {
            return result2;
        }
        result2 = result2 != null ? result2 : new LinkedHashSet<String>();
        result2.addAll(additional);
        return result2;
    }

    private static Set<String> addAll(Set<String> result2, String[] additional) {
        if (ObjectUtils.isEmpty(additional)) {
            return result2;
        }
        result2 = result2 != null ? result2 : new LinkedHashSet<String>();
        Collections.addAll(result2, additional);
        return result2;
    }

    private static class Spec<A extends Annotation> {
        private final ClassLoader classLoader;
        private final Class<? extends Annotation> annotationType;
        private final Set<String> names;
        private final Set<String> types;
        private final Set<String> annotations;
        private final Set<String> ignoredTypes;
        private final Set<Class<?>> parameterizedContainers;
        private final SearchStrategy strategy;

        Spec(ConditionContext context, AnnotatedTypeMetadata metadata, MergedAnnotations annotations, Class<A> annotationType) {
            MultiValueMap<String, Object> attributes = annotations.stream(annotationType).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).collect(MergedAnnotationCollectors.toMultiValueMap(MergedAnnotation.Adapt.CLASS_TO_STRING));
            MergedAnnotation<A> annotation = annotations.get(annotationType);
            this.classLoader = context.getClassLoader();
            this.annotationType = annotationType;
            this.names = this.extract(attributes, "name");
            this.annotations = this.extract(attributes, "annotation");
            this.ignoredTypes = this.extract(attributes, "ignored", "ignoredType");
            this.parameterizedContainers = this.resolveWhenPossible(this.extract(attributes, "parameterizedContainer"));
            this.strategy = annotation.getValue("search", SearchStrategy.class).orElse(null);
            Set<String> types = this.extractTypes(attributes);
            BeanTypeDeductionException deductionException = null;
            if (types.isEmpty() && this.names.isEmpty()) {
                try {
                    types = this.deducedBeanType(context, metadata);
                }
                catch (BeanTypeDeductionException ex) {
                    deductionException = ex;
                }
            }
            this.types = types;
            this.validate(deductionException);
        }

        protected Set<String> extractTypes(MultiValueMap<String, Object> attributes) {
            return this.extract(attributes, "value", "type");
        }

        private Set<String> extract(MultiValueMap<String, Object> attributes, String ... attributeNames) {
            if (attributes.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> result2 = new LinkedHashSet<String>();
            for (String attributeName : attributeNames) {
                List values2 = attributes.getOrDefault(attributeName, Collections.emptyList());
                for (Object value2 : values2) {
                    if (value2 instanceof String[]) {
                        String[] stringArray = (String[])value2;
                        this.merge(result2, stringArray);
                        continue;
                    }
                    if (!(value2 instanceof String)) continue;
                    String string2 = (String)value2;
                    this.merge(result2, string2);
                }
            }
            return result2.isEmpty() ? Collections.emptySet() : result2;
        }

        private void merge(Set<String> result2, String ... additional) {
            Collections.addAll(result2, additional);
        }

        private Set<Class<?>> resolveWhenPossible(Set<String> classNames) {
            if (classNames.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet resolved = new LinkedHashSet(classNames.size());
            for (String className : classNames) {
                try {
                    resolved.add(FilteringSpringBootCondition.resolve(className, this.classLoader));
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
            }
            return resolved;
        }

        protected void validate(BeanTypeDeductionException ex) {
            if (!this.hasAtLeastOneElement(this.types, this.names, this.annotations)) {
                String message2 = this.getAnnotationName() + " did not specify a bean using type, name or annotation";
                if (ex == null) {
                    throw new IllegalStateException(message2);
                }
                throw new IllegalStateException(message2 + " and the attempt to deduce the bean's type failed", ex);
            }
        }

        private boolean hasAtLeastOneElement(Set<?> ... sets) {
            for (Set<?> set2 : sets) {
                if (set2.isEmpty()) continue;
                return true;
            }
            return false;
        }

        protected final String getAnnotationName() {
            return "@" + ClassUtils.getShortName(this.annotationType);
        }

        private Set<String> deducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                return this.deducedBeanTypeForBeanMethod(context, (MethodMetadata)metadata);
            }
            return Collections.emptySet();
        }

        private Set<String> deducedBeanTypeForBeanMethod(ConditionContext context, MethodMetadata metadata) {
            try {
                Class<?> returnType = this.getReturnType(context, metadata);
                return Collections.singleton(returnType.getName());
            }
            catch (Throwable ex) {
                throw new BeanTypeDeductionException(metadata.getDeclaringClassName(), metadata.getMethodName(), ex);
            }
        }

        private Class<?> getReturnType(ConditionContext context, MethodMetadata metadata) throws ClassNotFoundException, LinkageError {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> returnType = FilteringSpringBootCondition.resolve(metadata.getReturnTypeName(), classLoader);
            if (this.isParameterizedContainer(returnType)) {
                returnType = this.getReturnTypeGeneric(metadata, classLoader);
            }
            return returnType;
        }

        private boolean isParameterizedContainer(Class<?> type2) {
            for (Class<?> parameterizedContainer : this.parameterizedContainers) {
                if (!parameterizedContainer.isAssignableFrom(type2)) continue;
                return true;
            }
            return false;
        }

        private Class<?> getReturnTypeGeneric(MethodMetadata metadata, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
            Class<?> declaringClass = FilteringSpringBootCondition.resolve(metadata.getDeclaringClassName(), classLoader);
            Method beanMethod = this.findBeanMethod(declaringClass, metadata.getMethodName());
            return ResolvableType.forMethodReturnType(beanMethod).resolveGeneric(new int[0]);
        }

        private Method findBeanMethod(Class<?> declaringClass, String methodName) {
            Method[] candidates;
            Method method2 = ReflectionUtils.findMethod(declaringClass, methodName);
            if (this.isBeanMethod(method2)) {
                return method2;
            }
            for (Method candidate : candidates = ReflectionUtils.getAllDeclaredMethods(declaringClass)) {
                if (!candidate.getName().equals(methodName) || !this.isBeanMethod(candidate)) continue;
                return candidate;
            }
            throw new IllegalStateException("Unable to find bean method " + methodName);
        }

        private boolean isBeanMethod(Method method2) {
            return method2 != null && MergedAnnotations.from(method2, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Bean.class);
        }

        private SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        Set<String> getNames() {
            return this.names;
        }

        Set<String> getTypes() {
            return this.types;
        }

        Set<String> getAnnotations() {
            return this.annotations;
        }

        Set<String> getIgnoredTypes() {
            return this.ignoredTypes;
        }

        Set<Class<?>> getParameterizedContainers() {
            return this.parameterizedContainers;
        }

        ConditionMessage.Builder message() {
            return ConditionMessage.forCondition(this.annotationType, this);
        }

        ConditionMessage.Builder message(ConditionMessage message2) {
            return message2.andCondition(this.annotationType, this);
        }

        public String toString() {
            boolean hasNames = !this.names.isEmpty();
            boolean hasTypes = !this.types.isEmpty();
            boolean hasIgnoredTypes = !this.ignoredTypes.isEmpty();
            StringBuilder string2 = new StringBuilder();
            string2.append("(");
            if (hasNames) {
                string2.append("names: ");
                string2.append(StringUtils.collectionToCommaDelimitedString(this.names));
                string2.append(hasTypes ? " " : "; ");
            }
            if (hasTypes) {
                string2.append("types: ");
                string2.append(StringUtils.collectionToCommaDelimitedString(this.types));
                string2.append(hasIgnoredTypes ? " " : "; ");
            }
            if (hasIgnoredTypes) {
                string2.append("ignored: ");
                string2.append(StringUtils.collectionToCommaDelimitedString(this.ignoredTypes));
                string2.append("; ");
            }
            string2.append("SearchStrategy: ");
            string2.append(this.strategy.toString().toLowerCase(Locale.ENGLISH));
            string2.append(")");
            return string2.toString();
        }
    }

    private static final class MatchResult {
        private final Map<String, Collection<String>> matchedAnnotations = new HashMap<String, Collection<String>>();
        private final List<String> matchedNames = new ArrayList<String>();
        private final Map<String, Collection<String>> matchedTypes = new HashMap<String, Collection<String>>();
        private final List<String> unmatchedAnnotations = new ArrayList<String>();
        private final List<String> unmatchedNames = new ArrayList<String>();
        private final List<String> unmatchedTypes = new ArrayList<String>();
        private final Set<String> namesOfAllMatches = new HashSet<String>();

        private MatchResult() {
        }

        private void recordMatchedName(String name2) {
            this.matchedNames.add(name2);
            this.namesOfAllMatches.add(name2);
        }

        private void recordUnmatchedName(String name2) {
            this.unmatchedNames.add(name2);
        }

        private void recordMatchedAnnotation(String annotation, Collection<String> matchingNames) {
            this.matchedAnnotations.put(annotation, matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedAnnotation(String annotation) {
            this.unmatchedAnnotations.add(annotation);
        }

        private void recordMatchedType(String type2, Collection<String> matchingNames) {
            this.matchedTypes.put(type2, matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedType(String type2) {
            this.unmatchedTypes.add(type2);
        }

        boolean isAllMatched() {
            return this.unmatchedAnnotations.isEmpty() && this.unmatchedNames.isEmpty() && this.unmatchedTypes.isEmpty();
        }

        boolean isAnyMatched() {
            return !this.matchedAnnotations.isEmpty() || !this.matchedNames.isEmpty() || !this.matchedTypes.isEmpty();
        }

        Map<String, Collection<String>> getMatchedAnnotations() {
            return this.matchedAnnotations;
        }

        List<String> getMatchedNames() {
            return this.matchedNames;
        }

        Map<String, Collection<String>> getMatchedTypes() {
            return this.matchedTypes;
        }

        List<String> getUnmatchedAnnotations() {
            return this.unmatchedAnnotations;
        }

        List<String> getUnmatchedNames() {
            return this.unmatchedNames;
        }

        List<String> getUnmatchedTypes() {
            return this.unmatchedTypes;
        }

        Set<String> getNamesOfAllMatches() {
            return this.namesOfAllMatches;
        }
    }

    private static class SingleCandidateSpec
    extends Spec<ConditionalOnSingleCandidate> {
        private static final Collection<String> FILTERED_TYPES = Arrays.asList("", Object.class.getName());

        SingleCandidateSpec(ConditionContext context, AnnotatedTypeMetadata metadata, MergedAnnotations annotations) {
            super(context, metadata, annotations, ConditionalOnSingleCandidate.class);
        }

        @Override
        protected Set<String> extractTypes(MultiValueMap<String, Object> attributes) {
            Set<String> types = super.extractTypes(attributes);
            types.removeAll(FILTERED_TYPES);
            return types;
        }

        @Override
        protected void validate(BeanTypeDeductionException ex) {
            Assert.isTrue(this.getTypes().size() == 1, () -> this.getAnnotationName() + " annotations must specify only one type (got " + StringUtils.collectionToCommaDelimitedString(this.getTypes()) + ")");
        }
    }

    static final class BeanTypeDeductionException
    extends RuntimeException {
        private BeanTypeDeductionException(String className, String beanMethodName, Throwable cause2) {
            super("Failed to deduce bean type for " + className + "." + beanMethodName, cause2);
        }
    }
}

