/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ConditionOutcome {
    private final boolean match;
    private final ConditionMessage message;

    public ConditionOutcome(boolean match2, String message2) {
        this(match2, ConditionMessage.of(message2, new Object[0]));
    }

    public ConditionOutcome(boolean match2, ConditionMessage message2) {
        Assert.notNull((Object)message2, "ConditionMessage must not be null");
        this.match = match2;
        this.message = message2;
    }

    public static ConditionOutcome match() {
        return ConditionOutcome.match(ConditionMessage.empty());
    }

    public static ConditionOutcome match(String message2) {
        return new ConditionOutcome(true, message2);
    }

    public static ConditionOutcome match(ConditionMessage message2) {
        return new ConditionOutcome(true, message2);
    }

    public static ConditionOutcome noMatch(String message2) {
        return new ConditionOutcome(false, message2);
    }

    public static ConditionOutcome noMatch(ConditionMessage message2) {
        return new ConditionOutcome(false, message2);
    }

    public boolean isMatch() {
        return this.match;
    }

    public String getMessage() {
        return this.message.isEmpty() ? null : this.message.toString();
    }

    public ConditionMessage getConditionMessage() {
        return this.message;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            ConditionOutcome other = (ConditionOutcome)obj;
            return this.match == other.match && ObjectUtils.nullSafeEquals(this.message, other.message);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Boolean.hashCode(this.match) * 31 + ObjectUtils.nullSafeHashCode(this.message);
    }

    public String toString() {
        return this.message != null ? this.message.toString() : "";
    }

    public static ConditionOutcome inverse(ConditionOutcome outcome) {
        return new ConditionOutcome(!outcome.isMatch(), outcome.getConditionMessage());
    }
}

