/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class ConditionMessage {
    private final String message;

    private ConditionMessage() {
        this(null);
    }

    private ConditionMessage(String message2) {
        this.message = message2;
    }

    private ConditionMessage(ConditionMessage prior, String message2) {
        this.message = prior.isEmpty() ? message2 : prior + "; " + message2;
    }

    public boolean isEmpty() {
        return !StringUtils.hasLength(this.message);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ConditionMessage) {
            ConditionMessage other = (ConditionMessage)obj;
            return ObjectUtils.nullSafeEquals(other.message, this.message);
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.message);
    }

    public String toString() {
        return this.message != null ? this.message : "";
    }

    public ConditionMessage append(String message2) {
        if (!StringUtils.hasLength(message2)) {
            return this;
        }
        if (!StringUtils.hasLength(this.message)) {
            return new ConditionMessage(message2);
        }
        return new ConditionMessage(this.message + " " + message2);
    }

    public Builder andCondition(Class<? extends Annotation> condition, Object ... details) {
        Assert.notNull(condition, "Condition must not be null");
        return this.andCondition("@" + ClassUtils.getShortName(condition), details);
    }

    public Builder andCondition(String condition, Object ... details) {
        Assert.notNull((Object)condition, "Condition must not be null");
        String detail = StringUtils.arrayToDelimitedString(details, " ");
        if (StringUtils.hasLength(detail)) {
            return new Builder(condition + " " + detail);
        }
        return new Builder(condition);
    }

    public static ConditionMessage empty() {
        return new ConditionMessage();
    }

    public static ConditionMessage of(String message2, Object ... args2) {
        if (ObjectUtils.isEmpty(args2)) {
            return new ConditionMessage(message2);
        }
        return new ConditionMessage(String.format(message2, args2));
    }

    public static ConditionMessage of(Collection<? extends ConditionMessage> messages) {
        ConditionMessage result2 = new ConditionMessage();
        if (messages != null) {
            for (ConditionMessage conditionMessage : messages) {
                result2 = new ConditionMessage(result2, conditionMessage.toString());
            }
        }
        return result2;
    }

    public static Builder forCondition(Class<? extends Annotation> condition, Object ... details) {
        return new ConditionMessage().andCondition(condition, details);
    }

    public static Builder forCondition(String condition, Object ... details) {
        return new ConditionMessage().andCondition(condition, details);
    }

    public final class Builder {
        private final String condition;

        private Builder(String condition) {
            this.condition = condition;
        }

        public ConditionMessage foundExactly(Object result2) {
            return this.found("").items(result2);
        }

        public ItemsBuilder found(String article) {
            return this.found(article, article);
        }

        public ItemsBuilder found(String singular, String plural) {
            return new ItemsBuilder(this, "found", singular, plural);
        }

        public ItemsBuilder didNotFind(String article) {
            return this.didNotFind(article, article);
        }

        public ItemsBuilder didNotFind(String singular, String plural) {
            return new ItemsBuilder(this, "did not find", singular, plural);
        }

        public ConditionMessage resultedIn(Object result2) {
            return this.because("resulted in " + result2);
        }

        public ConditionMessage available(String item) {
            return this.because(item + " is available");
        }

        public ConditionMessage notAvailable(String item) {
            return this.because(item + " is not available");
        }

        public ConditionMessage because(String reason2) {
            if (StringUtils.hasLength(reason2)) {
                return new ConditionMessage(ConditionMessage.this, (String)(StringUtils.hasLength(this.condition) ? this.condition + " " + reason2 : reason2));
            }
            return new ConditionMessage(ConditionMessage.this, this.condition);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Style {
        NORMAL{

            @Override
            protected Object applyToItem(Object item) {
                return item;
            }
        }
        ,
        QUOTE{

            @Override
            protected String applyToItem(Object item) {
                return item != null ? "'" + item + "'" : null;
            }
        };


        public Collection<?> applyTo(Collection<?> items) {
            if (items == null) {
                return null;
            }
            ArrayList<Object> result2 = new ArrayList<Object>(items.size());
            for (Object item : items) {
                result2.add(this.applyToItem(item));
            }
            return result2;
        }

        protected abstract Object applyToItem(Object var1);
    }

    public final class ItemsBuilder {
        private final Builder condition;
        private final String reason;
        private final String singular;
        private final String plural;

        private ItemsBuilder(Builder condition, String reason2, String singular, String plural) {
            this.condition = condition;
            this.reason = reason2;
            this.singular = singular;
            this.plural = plural;
        }

        public ConditionMessage atAll() {
            return this.items(Collections.emptyList());
        }

        public ConditionMessage items(Object ... items) {
            return this.items(Style.NORMAL, items);
        }

        public ConditionMessage items(Style style, Object ... items) {
            return this.items(style, items != null ? Arrays.asList(items) : null);
        }

        public ConditionMessage items(Collection<?> items) {
            return this.items(Style.NORMAL, items);
        }

        public ConditionMessage items(Style style, Collection<?> items) {
            Assert.notNull((Object)style, "Style must not be null");
            StringBuilder message2 = new StringBuilder(this.reason);
            items = style.applyTo(items);
            if ((this.condition == null || items == null || items.size() <= 1) && StringUtils.hasLength(this.singular)) {
                message2.append(" ").append(this.singular);
            } else if (StringUtils.hasLength(this.plural)) {
                message2.append(" ").append(this.plural);
            }
            if (!CollectionUtils.isEmpty(items)) {
                message2.append(" ").append(StringUtils.collectionToDelimitedString(items, ", "));
            }
            return this.condition.because(message2.toString());
        }
    }
}

