/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.ssl.ProgrammaticSslEngineFactory;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.cassandra.CassandraConnectionDetails;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.cassandra.CqlSessionBuilderCustomizer;
import org.springframework.boot.autoconfigure.cassandra.DriverConfigLoaderBuilderCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={CqlSession.class})
@EnableConfigurationProperties(value={CassandraProperties.class})
public class CassandraAutoConfiguration {
    private static final Config SPRING_BOOT_DEFAULTS;
    private final CassandraProperties properties;

    CassandraAutoConfiguration(CassandraProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={CassandraConnectionDetails.class})
    PropertiesCassandraConnectionDetails cassandraConnectionDetails() {
        return new PropertiesCassandraConnectionDetails(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy
    public CqlSession cassandraSession(CqlSessionBuilder cqlSessionBuilder) {
        return (CqlSession)cqlSessionBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public CqlSessionBuilder cassandraSessionBuilder(DriverConfigLoader driverConfigLoader, CassandraConnectionDetails connectionDetails, ObjectProvider<CqlSessionBuilderCustomizer> builderCustomizers, ObjectProvider<SslBundles> sslBundles) {
        CqlSessionBuilder builder = (CqlSessionBuilder)CqlSession.builder().withConfigLoader(driverConfigLoader);
        this.configureAuthentication(builder, connectionDetails);
        this.configureSsl(builder, sslBundles.getIfAvailable());
        builder.withKeyspace(this.properties.getKeyspaceName());
        builderCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(builder));
        return builder;
    }

    private void configureAuthentication(CqlSessionBuilder builder, CassandraConnectionDetails connectionDetails) {
        String username = connectionDetails.getUsername();
        if (username != null) {
            builder.withAuthCredentials(username, connectionDetails.getPassword());
        }
    }

    private void configureSsl(CqlSessionBuilder builder, SslBundles sslBundles) {
        CassandraProperties.Ssl properties = this.properties.getSsl();
        if (properties == null || !properties.isEnabled()) {
            return;
        }
        String bundleName = properties.getBundle();
        if (!StringUtils.hasLength(bundleName)) {
            this.configureDefaultSslContext(builder);
        } else {
            this.configureSsl(builder, sslBundles.getBundle(bundleName));
        }
    }

    private void configureDefaultSslContext(CqlSessionBuilder builder) {
        try {
            builder.withSslContext(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not setup SSL default context for Cassandra", ex);
        }
    }

    private void configureSsl(CqlSessionBuilder builder, SslBundle sslBundle) {
        SslOptions options2 = sslBundle.getOptions();
        Assert.state(options2.getEnabledProtocols() == null, "SSL protocol options cannot be specified with Cassandra");
        builder.withSslEngineFactory((SslEngineFactory)new ProgrammaticSslEngineFactory(sslBundle.createSslContext(), options2.getCiphers()));
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean
    public DriverConfigLoader cassandraDriverConfigLoader(CassandraConnectionDetails connectionDetails, ObjectProvider<DriverConfigLoaderBuilderCustomizer> builderCustomizers) {
        DefaultProgrammaticDriverConfigLoaderBuilder builder = new DefaultProgrammaticDriverConfigLoaderBuilder(() -> this.cassandraConfiguration(connectionDetails), "datastax-java-driver");
        builderCustomizers.orderedStream().forEach(arg_0 -> CassandraAutoConfiguration.lambda$cassandraDriverConfigLoader$2((ProgrammaticDriverConfigLoaderBuilder)builder, arg_0));
        return builder.build();
    }

    private Config cassandraConfiguration(CassandraConnectionDetails connectionDetails) {
        ConfigFactory.invalidateCaches();
        Config config = ConfigFactory.defaultOverrides();
        config = config.withFallback((ConfigMergeable)this.mapConfig(connectionDetails));
        if (this.properties.getConfig() != null) {
            config = config.withFallback((ConfigMergeable)this.loadConfig(this.properties.getConfig()));
        }
        config = config.withFallback((ConfigMergeable)SPRING_BOOT_DEFAULTS);
        config = config.withFallback((ConfigMergeable)ConfigFactory.defaultReferenceUnresolved());
        return config.resolve();
    }

    private Config loadConfig(Resource resource) {
        try {
            return ConfigFactory.parseURL((URL)resource.getURL());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load cassandra configuration from " + resource, ex);
        }
    }

    private Config mapConfig(CassandraConnectionDetails connectionDetails) {
        CassandraDriverOptions options2 = new CassandraDriverOptions();
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map2.from(this.properties.getSessionName()).whenHasText().to(sessionName -> options2.add((DriverOption)DefaultDriverOption.SESSION_NAME, (String)sessionName));
        map2.from(connectionDetails.getUsername()).to(value2 -> options2.add((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, (String)value2).add((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, connectionDetails.getPassword()));
        map2.from(this.properties::getCompression).to(compression -> options2.add((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, (Enum<?>)compression));
        this.mapConnectionOptions(options2);
        this.mapPoolingOptions(options2);
        this.mapRequestOptions(options2);
        this.mapControlConnectionOptions(options2);
        map2.from(this.mapContactPoints(connectionDetails)).to(contactPoints -> options2.add((DriverOption)DefaultDriverOption.CONTACT_POINTS, (List<String>)contactPoints));
        map2.from(connectionDetails.getLocalDatacenter()).whenHasText().to(localDatacenter -> options2.add((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, (String)localDatacenter));
        return options2.build();
    }

    private void mapConnectionOptions(CassandraDriverOptions options2) {
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraProperties.Connection connectionProperties = this.properties.getConnection();
        map2.from(connectionProperties::getConnectTimeout).asInt(Duration::toMillis).to(connectTimeout -> options2.add((DriverOption)DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT, (int)connectTimeout));
        map2.from(connectionProperties::getInitQueryTimeout).asInt(Duration::toMillis).to(initQueryTimeout -> options2.add((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, (int)initQueryTimeout));
    }

    private void mapPoolingOptions(CassandraDriverOptions options2) {
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraProperties.Pool poolProperties = this.properties.getPool();
        map2.from(poolProperties::getIdleTimeout).asInt(Duration::toMillis).to(idleTimeout -> options2.add((DriverOption)DefaultDriverOption.HEARTBEAT_TIMEOUT, (int)idleTimeout));
        map2.from(poolProperties::getHeartbeatInterval).asInt(Duration::toMillis).to(heartBeatInterval -> options2.add((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL, (int)heartBeatInterval));
    }

    private void mapRequestOptions(CassandraDriverOptions options2) {
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraProperties.Request requestProperties = this.properties.getRequest();
        map2.from(requestProperties::getTimeout).asInt(Duration::toMillis).to(timeout2 -> options2.add((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, (int)timeout2));
        map2.from(requestProperties::getConsistency).to(consistency -> options2.add((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, (Enum<?>)consistency));
        map2.from(requestProperties::getSerialConsistency).to(serialConsistency -> options2.add((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, (Enum<?>)serialConsistency));
        map2.from(requestProperties::getPageSize).to(pageSize -> options2.add((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, (int)pageSize));
        CassandraProperties.Throttler throttlerProperties = requestProperties.getThrottler();
        map2.from(throttlerProperties::getType).as(CassandraProperties.ThrottlerType::type).to(type2 -> options2.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_CLASS, (String)type2));
        map2.from(throttlerProperties::getMaxQueueSize).to(maxQueueSize -> options2.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_QUEUE_SIZE, (int)maxQueueSize));
        map2.from(throttlerProperties::getMaxConcurrentRequests).to(maxConcurrentRequests -> options2.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_CONCURRENT_REQUESTS, (int)maxConcurrentRequests));
        map2.from(throttlerProperties::getMaxRequestsPerSecond).to(maxRequestsPerSecond -> options2.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_REQUESTS_PER_SECOND, (int)maxRequestsPerSecond));
        map2.from(throttlerProperties::getDrainInterval).asInt(Duration::toMillis).to(drainInterval -> options2.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_DRAIN_INTERVAL, (int)drainInterval));
    }

    private void mapControlConnectionOptions(CassandraDriverOptions options2) {
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraProperties.Controlconnection controlProperties = this.properties.getControlconnection();
        map2.from(controlProperties::getTimeout).asInt(Duration::toMillis).to(timeout2 -> options2.add((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT, (int)timeout2));
    }

    private List<String> mapContactPoints(CassandraConnectionDetails connectionDetails) {
        return connectionDetails.getContactPoints().stream().map(node -> node.host() + ":" + node.port()).toList();
    }

    private static /* synthetic */ void lambda$cassandraDriverConfigLoader$2(ProgrammaticDriverConfigLoaderBuilder builder, DriverConfigLoaderBuilderCustomizer customizer2) {
        customizer2.customize(builder);
    }

    static {
        CassandraDriverOptions options2 = new CassandraDriverOptions();
        options2.add((DriverOption)DefaultDriverOption.CONTACT_POINTS, Collections.singletonList("127.0.0.1:9042"));
        options2.add((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none");
        options2.add((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT, (int)Duration.ofSeconds(5L).toMillis());
        SPRING_BOOT_DEFAULTS = options2.build();
    }

    static final class PropertiesCassandraConnectionDetails
    implements CassandraConnectionDetails {
        private final CassandraProperties properties;

        private PropertiesCassandraConnectionDetails(CassandraProperties properties) {
            this.properties = properties;
        }

        @Override
        public List<CassandraConnectionDetails.Node> getContactPoints() {
            List<String> contactPoints = this.properties.getContactPoints();
            return contactPoints != null ? contactPoints.stream().map(this::asNode).toList() : Collections.emptyList();
        }

        @Override
        public String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public String getLocalDatacenter() {
            return this.properties.getLocalDatacenter();
        }

        private CassandraConnectionDetails.Node asNode(String contactPoint) {
            String portCandidate;
            Integer port;
            int i2 = contactPoint.lastIndexOf(58);
            if (i2 >= 0 && (port = this.asPort(portCandidate = contactPoint.substring(i2 + 1))) != null) {
                return new CassandraConnectionDetails.Node(contactPoint.substring(0, i2), port);
            }
            return new CassandraConnectionDetails.Node(contactPoint, this.properties.getPort());
        }

        private Integer asPort(String value2) {
            try {
                int i2 = Integer.parseInt(value2);
                return i2 > 0 && i2 < 65535 ? Integer.valueOf(i2) : null;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private static final class CassandraDriverOptions {
        private final Map<String, String> options = new LinkedHashMap<String, String>();

        private CassandraDriverOptions() {
        }

        private CassandraDriverOptions add(DriverOption option, String value2) {
            String key2 = CassandraDriverOptions.createKeyFor(option);
            this.options.put(key2, value2);
            return this;
        }

        private CassandraDriverOptions add(DriverOption option, int value2) {
            return this.add(option, String.valueOf(value2));
        }

        private CassandraDriverOptions add(DriverOption option, Enum<?> value2) {
            return this.add(option, value2.name());
        }

        private CassandraDriverOptions add(DriverOption option, List<String> values2) {
            for (int i2 = 0; i2 < values2.size(); ++i2) {
                this.options.put(String.format("%s.%s", CassandraDriverOptions.createKeyFor(option), i2), values2.get(i2));
            }
            return this;
        }

        private Config build() {
            return ConfigFactory.parseMap(this.options, (String)"Environment");
        }

        private static String createKeyFor(DriverOption option) {
            return String.format("%s.%s", "datastax-java-driver", option.getPath());
        }
    }
}

