/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.time.Duration;
import java.util.List;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.AllowedListDeserializingMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RetryTemplateFactory;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RabbitTemplateConfigurer {
    private MessageConverter messageConverter;
    private List<RabbitRetryTemplateCustomizer> retryTemplateCustomizers;
    private final RabbitProperties rabbitProperties;

    public RabbitTemplateConfigurer(RabbitProperties rabbitProperties) {
        Assert.notNull((Object)rabbitProperties, "RabbitProperties must not be null");
        this.rabbitProperties = rabbitProperties;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setRetryTemplateCustomizers(List<RabbitRetryTemplateCustomizer> retryTemplateCustomizers) {
        this.retryTemplateCustomizers = retryTemplateCustomizers;
    }

    protected final RabbitProperties getRabbitProperties() {
        return this.rabbitProperties;
    }

    public void configure(RabbitTemplate template, ConnectionFactory connectionFactory) {
        PropertyMapper map2 = PropertyMapper.get();
        template.setConnectionFactory(connectionFactory);
        if (this.messageConverter != null) {
            template.setMessageConverter(this.messageConverter);
        }
        template.setMandatory(this.determineMandatoryFlag());
        RabbitProperties.Template templateProperties = this.rabbitProperties.getTemplate();
        if (templateProperties.getRetry().isEnabled()) {
            template.setRetryTemplate(new RetryTemplateFactory(this.retryTemplateCustomizers).createRetryTemplate(templateProperties.getRetry(), RabbitRetryTemplateCustomizer.Target.SENDER));
        }
        map2.from(templateProperties::getReceiveTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((RabbitTemplate)template).setReceiveTimeout(arg_0));
        map2.from(templateProperties::getReplyTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((RabbitTemplate)template).setReplyTimeout(arg_0));
        map2.from(templateProperties::getExchange).to(arg_0 -> ((RabbitTemplate)template).setExchange(arg_0));
        map2.from(templateProperties::getRoutingKey).to(arg_0 -> ((RabbitTemplate)template).setRoutingKey(arg_0));
        map2.from(templateProperties::getDefaultReceiveQueue).whenNonNull().to(arg_0 -> ((RabbitTemplate)template).setDefaultReceiveQueue(arg_0));
        map2.from(templateProperties::isObservationEnabled).to(arg_0 -> ((RabbitTemplate)template).setObservationEnabled(arg_0));
        map2.from(templateProperties::getAllowedListPatterns).whenNot(CollectionUtils::isEmpty).to(allowedListPatterns -> this.setAllowedListPatterns(template.getMessageConverter(), (List<String>)allowedListPatterns));
    }

    private void setAllowedListPatterns(MessageConverter messageConverter, List<String> allowedListPatterns) {
        if (messageConverter instanceof AllowedListDeserializingMessageConverter) {
            AllowedListDeserializingMessageConverter allowedListDeserializingMessageConverter = (AllowedListDeserializingMessageConverter)messageConverter;
            allowedListDeserializingMessageConverter.setAllowedListPatterns(allowedListPatterns);
            return;
        }
        throw new InvalidConfigurationPropertyValueException("spring.rabbitmq.template.allowed-list-patterns", allowedListPatterns, "Allowed list patterns can only be applied to an AllowedListDeserializingMessageConverter");
    }

    private boolean determineMandatoryFlag() {
        Boolean mandatory = this.rabbitProperties.getTemplate().getMandatory();
        return mandatory != null ? mandatory.booleanValue() : this.rabbitProperties.isPublisherReturns();
    }
}

