/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.time.Duration;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.boot.autoconfigure.amqp.AbstractConnectionFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.PropertiesRabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.PropertyMapper;

public class CachingConnectionFactoryConfigurer
extends AbstractConnectionFactoryConfigurer<CachingConnectionFactory> {
    public CachingConnectionFactoryConfigurer(RabbitProperties properties) {
        this(properties, new PropertiesRabbitConnectionDetails(properties));
    }

    public CachingConnectionFactoryConfigurer(RabbitProperties properties, RabbitConnectionDetails connectionDetails) {
        super(properties, connectionDetails);
    }

    @Override
    public void configure(CachingConnectionFactory connectionFactory, RabbitProperties rabbitProperties) {
        PropertyMapper map2 = PropertyMapper.get();
        map2.from(rabbitProperties::isPublisherReturns).to(arg_0 -> ((CachingConnectionFactory)connectionFactory).setPublisherReturns(arg_0));
        map2.from(rabbitProperties::getPublisherConfirmType).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)connectionFactory).setPublisherConfirmType(arg_0));
        RabbitProperties.Cache.Channel channel = rabbitProperties.getCache().getChannel();
        map2.from(channel::getSize).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)connectionFactory).setChannelCacheSize(arg_0));
        map2.from(channel::getCheckoutTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((CachingConnectionFactory)connectionFactory).setChannelCheckoutTimeout(arg_0));
        RabbitProperties.Cache.Connection connection = rabbitProperties.getCache().getConnection();
        map2.from(connection::getMode).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)connectionFactory).setCacheMode(arg_0));
        map2.from(connection::getSize).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)connectionFactory).setConnectionCacheSize(arg_0));
    }
}

