/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigurationImportSelector;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.context.annotation.DeterminableImports;
import org.springframework.boot.context.annotation.ImportCandidates;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

class ImportAutoConfigurationImportSelector
extends AutoConfigurationImportSelector
implements DeterminableImports {
    private static final String OPTIONAL_PREFIX = "optional:";
    private static final Set<String> ANNOTATION_NAMES;

    ImportAutoConfigurationImportSelector() {
    }

    @Override
    public Set<Object> determineImports(AnnotationMetadata metadata) {
        List<String> candidateConfigurations = this.getCandidateConfigurations(metadata, null);
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(candidateConfigurations);
        result2.removeAll(this.getExclusions(metadata, null));
        return Collections.unmodifiableSet(result2);
    }

    @Override
    protected AnnotationAttributes getAttributes(AnnotationMetadata metadata) {
        return null;
    }

    @Override
    protected List<String> getCandidateConfigurations(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        ArrayList<String> candidates = new ArrayList<String>();
        Map<Class<?>, List<Annotation>> annotations = this.getAnnotations(metadata);
        annotations.forEach((source2, sourceAnnotations) -> this.collectCandidateConfigurations((Class<?>)source2, (List<Annotation>)sourceAnnotations, (List<String>)candidates));
        return candidates;
    }

    private void collectCandidateConfigurations(Class<?> source2, List<Annotation> annotations, List<String> candidates) {
        for (Annotation annotation : annotations) {
            candidates.addAll(this.getConfigurationsForAnnotation(source2, annotation));
        }
    }

    private Collection<String> getConfigurationsForAnnotation(Class<?> source2, Annotation annotation) {
        String[] classes = (String[])AnnotationUtils.getAnnotationAttributes(annotation, true).get("classes");
        if (classes.length > 0) {
            return Arrays.asList(classes);
        }
        return this.loadFactoryNames(source2).stream().map(this::mapFactoryName).filter(Objects::nonNull).toList();
    }

    private String mapFactoryName(String name2) {
        if (!name2.startsWith(OPTIONAL_PREFIX)) {
            return name2;
        }
        return !this.present(name2 = name2.substring(OPTIONAL_PREFIX.length())) ? null : name2;
    }

    private boolean present(String className) {
        String resourcePath = ClassUtils.convertClassNameToResourcePath(className) + ".class";
        return new ClassPathResource(resourcePath).exists();
    }

    protected Collection<String> loadFactoryNames(Class<?> source2) {
        return ImportCandidates.load(source2, this.getBeanClassLoader()).getCandidates();
    }

    @Override
    protected Set<String> getExclusions(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        LinkedHashSet<String> exclusions = new LinkedHashSet<String>();
        Class<?> source2 = ClassUtils.resolveClassName(metadata.getClassName(), this.getBeanClassLoader());
        for (String string2 : ANNOTATION_NAMES) {
            AnnotationAttributes merged = AnnotatedElementUtils.getMergedAnnotationAttributes(source2, string2);
            Class<?>[] exclude = merged != null ? merged.getClassArray("exclude") : null;
            if (exclude == null) continue;
            for (Class<?> excludeClass : exclude) {
                exclusions.add(excludeClass.getName());
            }
        }
        for (List list2 : this.getAnnotations(metadata).values()) {
            for (Annotation annotation : list2) {
                Object[] exclude = (String[])AnnotationUtils.getAnnotationAttributes(annotation, true).get("exclude");
                if (ObjectUtils.isEmpty(exclude)) continue;
                exclusions.addAll(Arrays.asList(exclude));
            }
        }
        exclusions.addAll(this.getExcludeAutoConfigurationsProperty());
        return exclusions;
    }

    protected final Map<Class<?>, List<Annotation>> getAnnotations(AnnotationMetadata metadata) {
        LinkedMultiValueMap annotations = new LinkedMultiValueMap();
        Class<?> source2 = ClassUtils.resolveClassName(metadata.getClassName(), this.getBeanClassLoader());
        this.collectAnnotations(source2, annotations, new HashSet());
        return Collections.unmodifiableMap(annotations);
    }

    private void collectAnnotations(Class<?> source2, MultiValueMap<Class<?>, Annotation> annotations, HashSet<Class<?>> seen) {
        if (source2 != null && seen.add(source2)) {
            for (Annotation annotation : source2.getDeclaredAnnotations()) {
                if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation)) continue;
                if (ANNOTATION_NAMES.contains(annotation.annotationType().getName())) {
                    annotations.add(source2, annotation);
                }
                this.collectAnnotations(annotation.annotationType(), annotations, seen);
            }
            this.collectAnnotations(source2.getSuperclass(), annotations, seen);
        }
    }

    @Override
    public int getOrder() {
        return super.getOrder() - 1;
    }

    @Override
    protected void handleInvalidExcludes(List<String> invalidExcludes) {
    }

    static {
        LinkedHashSet<String> names2 = new LinkedHashSet<String>();
        names2.add(ImportAutoConfiguration.class.getName());
        names2.add("org.springframework.boot.autoconfigure.test.ImportAutoConfiguration");
        ANNOTATION_NAMES = Collections.unmodifiableSet(names2);
    }
}

