/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

final class AutoConfigurationMetadataLoader {
    protected static final String PATH = "META-INF/spring-autoconfigure-metadata.properties";

    private AutoConfigurationMetadataLoader() {
    }

    static AutoConfigurationMetadata loadMetadata(ClassLoader classLoader) {
        return AutoConfigurationMetadataLoader.loadMetadata(classLoader, PATH);
    }

    static AutoConfigurationMetadata loadMetadata(ClassLoader classLoader, String path2) {
        try {
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(path2) : ClassLoader.getSystemResources(path2);
            Properties properties = new Properties();
            while (urls.hasMoreElements()) {
                properties.putAll((Map<?, ?>)PropertiesLoaderUtils.loadProperties(new UrlResource(urls.nextElement())));
            }
            return AutoConfigurationMetadataLoader.loadMetadata(properties);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to load @ConditionalOnClass location [" + path2 + "]", ex);
        }
    }

    static AutoConfigurationMetadata loadMetadata(Properties properties) {
        return new PropertiesAutoConfigurationMetadata(properties);
    }

    private static class PropertiesAutoConfigurationMetadata
    implements AutoConfigurationMetadata {
        private final Properties properties;

        PropertiesAutoConfigurationMetadata(Properties properties) {
            this.properties = properties;
        }

        @Override
        public boolean wasProcessed(String className) {
            return this.properties.containsKey(className);
        }

        @Override
        public Integer getInteger(String className, String key2) {
            return this.getInteger(className, key2, null);
        }

        @Override
        public Integer getInteger(String className, String key2, Integer defaultValue) {
            String value2 = this.get(className, key2);
            return value2 != null ? Integer.valueOf(value2) : defaultValue;
        }

        @Override
        public Set<String> getSet(String className, String key2) {
            return this.getSet(className, key2, null);
        }

        @Override
        public Set<String> getSet(String className, String key2, Set<String> defaultValue) {
            String value2 = this.get(className, key2);
            return value2 != null ? StringUtils.commaDelimitedListToSet(value2) : defaultValue;
        }

        @Override
        public String get(String className, String key2) {
            return this.get(className, key2, null);
        }

        @Override
        public String get(String className, String key2, String defaultValue) {
            String value2 = this.properties.getProperty(className + "." + key2);
            return value2 != null ? value2 : defaultValue;
        }
    }
}

