/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.admin;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.admin.SpringApplicationAdminMXBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;

public class SpringApplicationAdminMXBeanRegistrar
implements ApplicationContextAware,
GenericApplicationListener,
EnvironmentAware,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog(SpringApplicationAdmin.class);
    private ConfigurableApplicationContext applicationContext;
    private Environment environment = new StandardEnvironment();
    private final ObjectName objectName;
    private boolean ready = false;
    private boolean embeddedWebApplication = false;

    public SpringApplicationAdminMXBeanRegistrar(String name2) throws MalformedObjectNameException {
        this.objectName = new ObjectName(name2);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.state(applicationContext instanceof ConfigurableApplicationContext, "ApplicationContext does not implement ConfigurableApplicationContext");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = environment2;
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        Class<?> type2 = eventType.getRawClass();
        if (type2 == null) {
            return false;
        }
        return ApplicationReadyEvent.class.isAssignableFrom(type2) || WebServerInitializedEvent.class.isAssignableFrom(type2);
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event2) {
        if (event2 instanceof ApplicationReadyEvent) {
            ApplicationReadyEvent readyEvent = (ApplicationReadyEvent)event2;
            this.onApplicationReadyEvent(readyEvent);
        }
        if (event2 instanceof WebServerInitializedEvent) {
            WebServerInitializedEvent initializedEvent = (WebServerInitializedEvent)event2;
            this.onWebServerInitializedEvent(initializedEvent);
        }
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    void onApplicationReadyEvent(ApplicationReadyEvent event2) {
        if (this.applicationContext.equals(event2.getApplicationContext())) {
            this.ready = true;
        }
    }

    void onWebServerInitializedEvent(WebServerInitializedEvent event2) {
        if (this.applicationContext.equals(event2.getApplicationContext())) {
            this.embeddedWebApplication = true;
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(new SpringApplicationAdmin(), this.objectName);
        if (logger.isDebugEnabled()) {
            logger.debug("Application Admin MBean registered with name '" + this.objectName + "'");
        }
    }

    @Override
    public void destroy() throws Exception {
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.objectName);
    }

    private final class SpringApplicationAdmin
    implements SpringApplicationAdminMXBean {
        private SpringApplicationAdmin() {
        }

        @Override
        public boolean isReady() {
            return SpringApplicationAdminMXBeanRegistrar.this.ready;
        }

        @Override
        public boolean isEmbeddedWebApplication() {
            return SpringApplicationAdminMXBeanRegistrar.this.embeddedWebApplication;
        }

        @Override
        public String getProperty(String key2) {
            return SpringApplicationAdminMXBeanRegistrar.this.environment.getProperty(key2);
        }

        @Override
        public void shutdown() {
            logger.info("Application shutdown requested.");
            SpringApplicationAdminMXBeanRegistrar.this.applicationContext.close();
        }
    }
}

