/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.springframework.aot.AotDetector;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.context.ApplicationContext;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class StartupInfoLogger {
    private final Class<?> sourceClass;

    StartupInfoLogger(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    void logStarting(Log applicationLog) {
        Assert.notNull((Object)applicationLog, "Log must not be null");
        applicationLog.info(LogMessage.of(this::getStartingMessage));
        applicationLog.debug(LogMessage.of(this::getRunningMessage));
    }

    void logStarted(Log applicationLog, SpringApplication.Startup startup) {
        if (applicationLog.isInfoEnabled()) {
            applicationLog.info(this.getStartedMessage(startup));
        }
    }

    private CharSequence getStartingMessage() {
        StringBuilder message2 = new StringBuilder();
        message2.append("Starting");
        this.appendAotMode(message2);
        this.appendApplicationName(message2);
        this.appendVersion(message2, this.sourceClass);
        this.appendJavaVersion(message2);
        this.appendPid(message2);
        this.appendContext(message2);
        return message2;
    }

    private CharSequence getRunningMessage() {
        StringBuilder message2 = new StringBuilder();
        message2.append("Running with Spring Boot");
        this.appendVersion(message2, this.getClass());
        message2.append(", Spring");
        this.appendVersion(message2, ApplicationContext.class);
        return message2;
    }

    private CharSequence getStartedMessage(SpringApplication.Startup startup) {
        StringBuilder message2 = new StringBuilder();
        message2.append(startup.action());
        this.appendApplicationName(message2);
        message2.append(" in ");
        message2.append((double)startup.timeTakenToStarted().toMillis() / 1000.0);
        message2.append(" seconds");
        Long uptimeMs = startup.processUptime();
        if (uptimeMs != null) {
            double uptime = (double)uptimeMs.longValue() / 1000.0;
            message2.append(" (process running for ").append(uptime).append(")");
        }
        return message2;
    }

    private void appendAotMode(StringBuilder message2) {
        this.append(message2, "", () -> AotDetector.useGeneratedArtifacts() ? "AOT-processed" : null);
    }

    private void appendApplicationName(StringBuilder message2) {
        this.append(message2, "", () -> this.sourceClass != null ? ClassUtils.getShortName(this.sourceClass) : "application");
    }

    private void appendVersion(StringBuilder message2, Class<?> source2) {
        this.append(message2, "v", () -> source2.getPackage().getImplementationVersion());
    }

    private void appendPid(StringBuilder message2) {
        this.append(message2, "with PID ", ApplicationPid::new);
    }

    private void appendContext(StringBuilder message2) {
        StringBuilder context = new StringBuilder();
        ApplicationHome home2 = new ApplicationHome(this.sourceClass);
        if (home2.getSource() != null) {
            context.append(home2.getSource().getAbsolutePath());
        }
        this.append(context, "started by ", () -> System.getProperty("user.name"));
        this.append(context, "in ", () -> System.getProperty("user.dir"));
        if (!context.isEmpty()) {
            message2.append(" (");
            message2.append((CharSequence)context);
            message2.append(")");
        }
    }

    private void appendJavaVersion(StringBuilder message2) {
        this.append(message2, "using Java ", () -> System.getProperty("java.version"));
    }

    private void append(StringBuilder message2, String prefix, Callable<Object> call2) {
        this.append(message2, prefix, call2, "");
    }

    private void append(StringBuilder message2, String prefix, Callable<Object> call2, String defaultValue) {
        String value2;
        Object result2 = this.callIfPossible(call2);
        String string2 = value2 = result2 != null ? result2.toString() : null;
        if (!StringUtils.hasLength(value2)) {
            value2 = defaultValue;
        }
        if (StringUtils.hasLength(value2)) {
            message2.append(!message2.isEmpty() ? " " : "");
            message2.append(prefix);
            message2.append(value2);
        }
    }

    private Object callIfPossible(Callable<Object> call2) {
        try {
            return call2.call();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

