/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;
import org.springframework.util.ReflectionUtils;

class SpringApplicationRunListeners {
    private final Log log;
    private final List<SpringApplicationRunListener> listeners;
    private final ApplicationStartup applicationStartup;

    SpringApplicationRunListeners(Log log3, List<SpringApplicationRunListener> listeners, ApplicationStartup applicationStartup) {
        this.log = log3;
        this.listeners = List.copyOf(listeners);
        this.applicationStartup = applicationStartup;
    }

    void starting(ConfigurableBootstrapContext bootstrapContext, Class<?> mainApplicationClass) {
        this.doWithListeners("spring.boot.application.starting", listener -> listener.starting(bootstrapContext), step2 -> {
            if (mainApplicationClass != null) {
                step2.tag("mainApplicationClass", mainApplicationClass.getName());
            }
        });
    }

    void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment2) {
        this.doWithListeners("spring.boot.application.environment-prepared", listener -> listener.environmentPrepared(bootstrapContext, environment2));
    }

    void contextPrepared(ConfigurableApplicationContext context) {
        this.doWithListeners("spring.boot.application.context-prepared", listener -> listener.contextPrepared(context));
    }

    void contextLoaded(ConfigurableApplicationContext context) {
        this.doWithListeners("spring.boot.application.context-loaded", listener -> listener.contextLoaded(context));
    }

    void started(ConfigurableApplicationContext context, Duration timeTaken) {
        this.doWithListeners("spring.boot.application.started", listener -> listener.started(context, timeTaken));
    }

    void ready(ConfigurableApplicationContext context, Duration timeTaken) {
        this.doWithListeners("spring.boot.application.ready", listener -> listener.ready(context, timeTaken));
    }

    void failed(ConfigurableApplicationContext context, Throwable exception2) {
        this.doWithListeners("spring.boot.application.failed", listener -> this.callFailedListener((SpringApplicationRunListener)listener, context, exception2), step2 -> {
            step2.tag("exception", exception2.getClass().toString());
            step2.tag("message", exception2.getMessage());
        });
    }

    private void callFailedListener(SpringApplicationRunListener listener, ConfigurableApplicationContext context, Throwable exception2) {
        try {
            listener.failed(context, exception2);
        }
        catch (Throwable ex) {
            if (exception2 == null) {
                ReflectionUtils.rethrowRuntimeException(ex);
            }
            if (this.log.isDebugEnabled()) {
                this.log.error("Error handling failed", ex);
            }
            String message2 = ex.getMessage();
            message2 = message2 != null ? message2 : "no error message";
            this.log.warn("Error handling failed (" + message2 + ")");
        }
    }

    private void doWithListeners(String stepName, Consumer<SpringApplicationRunListener> listenerAction) {
        this.doWithListeners(stepName, listenerAction, null);
    }

    private void doWithListeners(String stepName, Consumer<SpringApplicationRunListener> listenerAction, Consumer<StartupStep> stepAction) {
        StartupStep step2 = this.applicationStartup.start(stepName);
        this.listeners.forEach(listenerAction);
        if (stepAction != null) {
            stepAction.accept(step2);
        }
        step2.end();
    }
}

