/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.ApplicationEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

final class EnvironmentConverter {
    private static final String CONFIGURABLE_WEB_ENVIRONMENT_CLASS = "org.springframework.web.context.ConfigurableWebEnvironment";
    private static final Set<String> SERVLET_ENVIRONMENT_SOURCE_NAMES;
    private final ClassLoader classLoader;

    EnvironmentConverter(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    ConfigurableEnvironment convertEnvironmentIfNecessary(ConfigurableEnvironment environment2, Class<? extends ConfigurableEnvironment> type2) {
        if (type2.equals(environment2.getClass())) {
            return environment2;
        }
        return this.convertEnvironment(environment2, type2);
    }

    private ConfigurableEnvironment convertEnvironment(ConfigurableEnvironment environment2, Class<? extends ConfigurableEnvironment> type2) {
        ConfigurableEnvironment result2 = this.createEnvironment(type2);
        result2.setActiveProfiles(environment2.getActiveProfiles());
        result2.setConversionService(environment2.getConversionService());
        this.copyPropertySources(environment2, result2);
        return result2;
    }

    private ConfigurableEnvironment createEnvironment(Class<? extends ConfigurableEnvironment> type2) {
        try {
            Constructor<? extends ConfigurableEnvironment> constructor2 = type2.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(constructor2);
            return constructor2.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            return new ApplicationEnvironment();
        }
    }

    private void copyPropertySources(ConfigurableEnvironment source2, ConfigurableEnvironment target2) {
        this.removePropertySources(target2.getPropertySources(), this.isServletEnvironment(target2.getClass(), this.classLoader));
        for (PropertySource<?> propertySource : source2.getPropertySources()) {
            if (SERVLET_ENVIRONMENT_SOURCE_NAMES.contains(propertySource.getName())) continue;
            target2.getPropertySources().addLast(propertySource);
        }
    }

    private boolean isServletEnvironment(Class<?> conversionType, ClassLoader classLoader) {
        try {
            Class<?> webEnvironmentClass = ClassUtils.forName(CONFIGURABLE_WEB_ENVIRONMENT_CLASS, classLoader);
            return webEnvironmentClass.isAssignableFrom(conversionType);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void removePropertySources(MutablePropertySources propertySources, boolean isServletEnvironment) {
        HashSet<String> names2 = new HashSet<String>();
        for (PropertySource<?> propertySource : propertySources) {
            names2.add(propertySource.getName());
        }
        for (String name2 : names2) {
            if (isServletEnvironment && SERVLET_ENVIRONMENT_SOURCE_NAMES.contains(name2)) continue;
            propertySources.remove(name2);
        }
    }

    static {
        HashSet<String> names2 = new HashSet<String>();
        names2.add("servletContextInitParams");
        names2.add("servletConfigInitParams");
        names2.add("jndiProperties");
        SERVLET_ENVIRONMENT_SOURCE_NAMES = Collections.unmodifiableSet(names2);
    }
}

