/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.util.Assert;

public class DefaultBootstrapContext
implements ConfigurableBootstrapContext {
    private final Map<Class<?>, BootstrapRegistry.InstanceSupplier<?>> instanceSuppliers = new HashMap();
    private final Map<Class<?>, Object> instances = new HashMap();
    private final ApplicationEventMulticaster events = new SimpleApplicationEventMulticaster();

    @Override
    public <T> void register(Class<T> type2, BootstrapRegistry.InstanceSupplier<T> instanceSupplier) {
        this.register(type2, instanceSupplier, true);
    }

    @Override
    public <T> void registerIfAbsent(Class<T> type2, BootstrapRegistry.InstanceSupplier<T> instanceSupplier) {
        this.register(type2, instanceSupplier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void register(Class<T> type2, BootstrapRegistry.InstanceSupplier<T> instanceSupplier, boolean replaceExisting) {
        Assert.notNull(type2, "Type must not be null");
        Assert.notNull(instanceSupplier, "InstanceSupplier must not be null");
        Map<Class<?>, BootstrapRegistry.InstanceSupplier<?>> map2 = this.instanceSuppliers;
        synchronized (map2) {
            boolean alreadyRegistered = this.instanceSuppliers.containsKey(type2);
            if (replaceExisting || !alreadyRegistered) {
                Assert.state(!this.instances.containsKey(type2), () -> type2.getName() + " has already been created");
                this.instanceSuppliers.put(type2, instanceSupplier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean isRegistered(Class<T> type2) {
        Map<Class<?>, BootstrapRegistry.InstanceSupplier<?>> map2 = this.instanceSuppliers;
        synchronized (map2) {
            return this.instanceSuppliers.containsKey(type2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> BootstrapRegistry.InstanceSupplier<T> getRegisteredInstanceSupplier(Class<T> type2) {
        Map<Class<?>, BootstrapRegistry.InstanceSupplier<?>> map2 = this.instanceSuppliers;
        synchronized (map2) {
            return this.instanceSuppliers.get(type2);
        }
    }

    @Override
    public void addCloseListener(ApplicationListener<BootstrapContextClosedEvent> listener) {
        this.events.addApplicationListener(listener);
    }

    @Override
    public <T> T get(Class<T> type2) throws IllegalStateException {
        return this.getOrElseThrow(type2, () -> new IllegalStateException(type2.getName() + " has not been registered"));
    }

    @Override
    public <T> T getOrElse(Class<T> type2, T other) {
        return (T)this.getOrElseSupply(type2, () -> other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOrElseSupply(Class<T> type2, Supplier<T> other) {
        Map<Class<?>, BootstrapRegistry.InstanceSupplier<?>> map2 = this.instanceSuppliers;
        synchronized (map2) {
            BootstrapRegistry.InstanceSupplier<?> instanceSupplier = this.instanceSuppliers.get(type2);
            return instanceSupplier != null ? this.getInstance(type2, instanceSupplier) : other.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, X extends Throwable> T getOrElseThrow(Class<T> type2, Supplier<? extends X> exceptionSupplier) throws X {
        Map<Class<?>, BootstrapRegistry.InstanceSupplier<?>> map2 = this.instanceSuppliers;
        synchronized (map2) {
            BootstrapRegistry.InstanceSupplier<?> instanceSupplier = this.instanceSuppliers.get(type2);
            if (instanceSupplier == null) {
                throw (Throwable)exceptionSupplier.get();
            }
            return this.getInstance(type2, instanceSupplier);
        }
    }

    private <T> T getInstance(Class<T> type2, BootstrapRegistry.InstanceSupplier<?> instanceSupplier) {
        Object instance = this.instances.get(type2);
        if (instance == null) {
            instance = instanceSupplier.get(this);
            if (instanceSupplier.getScope() == BootstrapRegistry.Scope.SINGLETON) {
                this.instances.put(type2, instance);
            }
        }
        return (T)instance;
    }

    public void close(ConfigurableApplicationContext applicationContext) {
        this.events.multicastEvent(new BootstrapContextClosedEvent(this, applicationContext));
    }
}

