/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.lang.reflect.Method;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.ReflectionUtils;

class ClearCachesApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    ClearCachesApplicationListener() {
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event2) {
        ReflectionUtils.clearCache();
        this.clearClassLoaderCaches(Thread.currentThread().getContextClassLoader());
    }

    private void clearClassLoaderCaches(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        try {
            Method clearCacheMethod = classLoader.getClass().getDeclaredMethod("clearCache", new Class[0]);
            clearCacheMethod.invoke((Object)classLoader, new Object[0]);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        this.clearClassLoaderCaches(classLoader.getParent());
    }
}

