/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class StringTrimmerEditor
extends PropertyEditorSupport {
    @Nullable
    private final String charsToDelete;
    private final boolean emptyAsNull;

    public StringTrimmerEditor(boolean emptyAsNull) {
        this.charsToDelete = null;
        this.emptyAsNull = emptyAsNull;
    }

    public StringTrimmerEditor(String charsToDelete, boolean emptyAsNull) {
        this.charsToDelete = charsToDelete;
        this.emptyAsNull = emptyAsNull;
    }

    @Override
    public void setAsText(@Nullable String text) {
        if (text == null) {
            this.setValue(null);
        } else {
            String value2 = text.trim();
            if (this.charsToDelete != null) {
                value2 = StringUtils.deleteAny(value2, this.charsToDelete);
            }
            if (this.emptyAsNull && value2.isEmpty()) {
                this.setValue(null);
            } else {
                this.setValue(value2);
            }
        }
    }

    @Override
    public String getAsText() {
        Object value2 = this.getValue();
        return value2 != null ? value2.toString() : "";
    }
}

