/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class CustomMapEditor
extends PropertyEditorSupport {
    private final Class<? extends Map> mapType;
    private final boolean nullAsEmptyMap;

    public CustomMapEditor(Class<? extends Map> mapType) {
        this(mapType, false);
    }

    public CustomMapEditor(Class<? extends Map> mapType, boolean nullAsEmptyMap) {
        Assert.notNull(mapType, "Map type is required");
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Map type [" + mapType.getName() + "] does not implement [java.util.Map]");
        }
        this.mapType = mapType;
        this.nullAsEmptyMap = nullAsEmptyMap;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    @Override
    public void setValue(@Nullable Object value2) {
        if (value2 == null && this.nullAsEmptyMap) {
            super.setValue(this.createMap(this.mapType, 0));
        } else if (value2 == null || this.mapType.isInstance(value2) && !this.alwaysCreateNewMap()) {
            super.setValue(value2);
        } else if (value2 instanceof Map) {
            Map source2 = (Map)value2;
            Map<Object, Object> target2 = this.createMap(this.mapType, source2.size());
            source2.forEach((key2, val) -> target2.put(this.convertKey(key2), this.convertValue(val)));
            super.setValue(target2);
        } else {
            throw new IllegalArgumentException("Value cannot be converted to Map: " + value2);
        }
    }

    protected Map<Object, Object> createMap(Class<? extends Map> mapType, int initialCapacity) {
        if (!mapType.isInterface()) {
            try {
                return ReflectionUtils.accessibleConstructor(mapType, new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Could not instantiate map class: " + mapType.getName(), ex);
            }
        }
        if (SortedMap.class == mapType) {
            return new TreeMap<Object, Object>();
        }
        return new LinkedHashMap<Object, Object>(initialCapacity);
    }

    protected boolean alwaysCreateNewMap() {
        return false;
    }

    protected Object convertKey(Object key2) {
        return key2;
    }

    protected Object convertValue(Object value2) {
        return value2;
    }

    @Override
    @Nullable
    public String getAsText() {
        return null;
    }
}

