/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.NullBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SimpleInstantiationStrategy
implements InstantiationStrategy {
    private static final ThreadLocal<Method> currentlyInvokedFactoryMethod = new ThreadLocal();

    @Nullable
    public static Method getCurrentlyInvokedFactoryMethod() {
        return currentlyInvokedFactoryMethod.get();
    }

    public static void setCurrentlyInvokedFactoryMethod(@Nullable Method method2) {
        if (method2 != null) {
            currentlyInvokedFactoryMethod.set(method2);
        } else {
            currentlyInvokedFactoryMethod.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object instantiate(RootBeanDefinition bd, @Nullable String beanName, BeanFactory owner2) {
        if (!bd.hasMethodOverrides()) {
            Constructor<?> constructorToUse;
            Object object = bd.constructorArgumentLock;
            synchronized (object) {
                constructorToUse = (Constructor<?>)bd.resolvedConstructorOrFactoryMethod;
                if (constructorToUse == null) {
                    Class<?> clazz = bd.getBeanClass();
                    if (clazz.isInterface()) {
                        throw new BeanInstantiationException(clazz, "Specified class is an interface");
                    }
                    try {
                        bd.resolvedConstructorOrFactoryMethod = constructorToUse = clazz.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable ex) {
                        throw new BeanInstantiationException(clazz, "No default constructor found", ex);
                    }
                }
            }
            return BeanUtils.instantiateClass(constructorToUse, new Object[0]);
        }
        return this.instantiateWithMethodInjection(bd, beanName, owner2);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition bd, @Nullable String beanName, BeanFactory owner2) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    @Override
    public Object instantiate(RootBeanDefinition bd, @Nullable String beanName, BeanFactory owner2, Constructor<?> ctor, Object ... args2) {
        if (!bd.hasMethodOverrides()) {
            return BeanUtils.instantiateClass(ctor, args2);
        }
        return this.instantiateWithMethodInjection(bd, beanName, owner2, ctor, args2);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition bd, @Nullable String beanName, BeanFactory owner2, @Nullable Constructor<?> ctor, Object ... args2) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object instantiate(RootBeanDefinition bd, @Nullable String beanName, BeanFactory owner2, @Nullable Object factoryBean, Method factoryMethod, Object ... args2) {
        Object object;
        ReflectionUtils.makeAccessible(factoryMethod);
        Method priorInvokedFactoryMethod = SimpleInstantiationStrategy.getCurrentlyInvokedFactoryMethod();
        try {
            SimpleInstantiationStrategy.setCurrentlyInvokedFactoryMethod(factoryMethod);
            Object result2 = factoryMethod.invoke(factoryBean, args2);
            if (result2 == null) {
                result2 = new NullBean();
            }
            object = result2;
        }
        catch (Throwable throwable) {
            try {
                SimpleInstantiationStrategy.setCurrentlyInvokedFactoryMethod(priorInvokedFactoryMethod);
                throw throwable;
            }
            catch (IllegalArgumentException ex) {
                if (factoryBean != null && !factoryMethod.getDeclaringClass().isAssignableFrom(factoryBean.getClass())) {
                    throw new BeanInstantiationException(factoryMethod, "Illegal factory instance for factory method '" + factoryMethod.getName() + "'; instance: " + factoryBean.getClass().getName(), (Throwable)ex);
                }
                throw new BeanInstantiationException(factoryMethod, "Illegal arguments to factory method '" + factoryMethod.getName() + "'; args: " + StringUtils.arrayToCommaDelimitedString(args2), (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new BeanInstantiationException(factoryMethod, "Cannot access factory method '" + factoryMethod.getName() + "'; is it public?", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                ConfigurableBeanFactory cbf;
                String msg = "Factory method '" + factoryMethod.getName() + "' threw exception with message: " + ex.getTargetException().getMessage();
                if (bd.getFactoryBeanName() != null && owner2 instanceof ConfigurableBeanFactory && (cbf = (ConfigurableBeanFactory)owner2).isCurrentlyInCreation(bd.getFactoryBeanName())) {
                    msg = "Circular reference involving containing bean '" + bd.getFactoryBeanName() + "' - consider declaring the factory method as static for independence from its containing instance. " + msg;
                }
                throw new BeanInstantiationException(factoryMethod, msg, ex.getTargetException());
            }
        }
        SimpleInstantiationStrategy.setCurrentlyInvokedFactoryMethod(priorInvokedFactoryMethod);
        return object;
    }
}

