/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class MethodOverride
implements BeanMetadataElement {
    private final String methodName;
    private boolean overloaded = true;
    @Nullable
    private Object source;

    protected MethodOverride(String methodName) {
        Assert.notNull((Object)methodName, "Method name must not be null");
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }

    protected boolean isOverloaded() {
        return this.overloaded;
    }

    public void setSource(@Nullable Object source2) {
        this.source = source2;
    }

    @Override
    @Nullable
    public Object getSource() {
        return this.source;
    }

    public abstract boolean matches(Method var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof MethodOverride)) return false;
        MethodOverride that = (MethodOverride)other;
        if (!ObjectUtils.nullSafeEquals(this.methodName, that.methodName)) return false;
        if (!ObjectUtils.nullSafeEquals(this.source, that.source)) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(this.methodName, this.source);
    }
}

