/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

abstract class AutowireUtils {
    public static final Comparator<Executable> EXECUTABLE_COMPARATOR = (e1, e2) -> {
        int result2 = Boolean.compare(Modifier.isPublic(e2.getModifiers()), Modifier.isPublic(e1.getModifiers()));
        return result2 != 0 ? result2 : Integer.compare(e2.getParameterCount(), e1.getParameterCount());
    };

    AutowireUtils() {
    }

    public static void sortConstructors(Constructor<?>[] constructors2) {
        Arrays.sort(constructors2, EXECUTABLE_COMPARATOR);
    }

    public static void sortFactoryMethods(Method[] factoryMethods) {
        Arrays.sort(factoryMethods, EXECUTABLE_COMPARATOR);
    }

    public static boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        Method wm = pd.getWriteMethod();
        if (wm == null) {
            return false;
        }
        if (!wm.getDeclaringClass().getName().contains("$$")) {
            return false;
        }
        Class<?> superclass2 = wm.getDeclaringClass().getSuperclass();
        return !ClassUtils.hasMethod(superclass2, wm);
    }

    public static boolean isSetterDefinedInInterface(PropertyDescriptor pd, Set<Class<?>> interfaces2) {
        Method setter = pd.getWriteMethod();
        if (setter != null) {
            Class<?> targetClass = setter.getDeclaringClass();
            for (Class<?> ifc : interfaces2) {
                if (!ifc.isAssignableFrom(targetClass) || !ClassUtils.hasMethod(ifc, setter)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object resolveAutowiringValue(Object autowiringValue, Class<?> requiredType) {
        if (autowiringValue instanceof ObjectFactory) {
            ObjectFactory factory = (ObjectFactory)autowiringValue;
            if (!requiredType.isInstance(autowiringValue)) {
                if (autowiringValue instanceof Serializable && requiredType.isInterface()) {
                    autowiringValue = Proxy.newProxyInstance(requiredType.getClassLoader(), new Class[]{requiredType}, (InvocationHandler)new ObjectFactoryDelegatingInvocationHandler(factory));
                } else {
                    return factory.getObject();
                }
            }
        }
        return autowiringValue;
    }

    public static Class<?> resolveReturnTypeForFactoryMethod(Method method2, Object[] args2, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)method2, "Method must not be null");
        Assert.notNull((Object)args2, "Argument array must not be null");
        TypeVariable<Method>[] declaredTypeVariables = method2.getTypeParameters();
        Type genericReturnType = method2.getGenericReturnType();
        Type[] methodParameterTypes = method2.getGenericParameterTypes();
        Assert.isTrue(args2.length == methodParameterTypes.length, "Argument array does not match parameter count");
        boolean locallyDeclaredTypeVariableMatchesReturnType = false;
        for (TypeVariable<Method> currentTypeVariable : declaredTypeVariables) {
            if (!currentTypeVariable.equals(genericReturnType)) continue;
            locallyDeclaredTypeVariableMatchesReturnType = true;
            break;
        }
        if (locallyDeclaredTypeVariableMatchesReturnType) {
            for (int i2 = 0; i2 < methodParameterTypes.length; ++i2) {
                Type[] actualTypeArguments;
                Type methodParameterType = methodParameterTypes[i2];
                Object arg2 = args2[i2];
                if (methodParameterType.equals(genericReturnType)) {
                    block18: {
                        if (arg2 instanceof TypedStringValue) {
                            TypedStringValue typedValue = (TypedStringValue)arg2;
                            if (typedValue.hasTargetType()) {
                                return typedValue.getTargetType();
                            }
                            try {
                                Class<?> resolvedType = typedValue.resolveTargetType(classLoader);
                                if (resolvedType != null) {
                                    return resolvedType;
                                }
                                break block18;
                            }
                            catch (ClassNotFoundException ex) {
                                throw new IllegalStateException("Failed to resolve value type [" + typedValue.getTargetTypeName() + "] for factory method argument", ex);
                            }
                        }
                        if (arg2 != null && !(arg2 instanceof BeanMetadataElement)) {
                            return arg2.getClass();
                        }
                    }
                    return method2.getReturnType();
                }
                if (!(methodParameterType instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)methodParameterType;
                for (Type typeArg : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                    TypedStringValue typedValue;
                    String targetTypeName;
                    if (!typeArg.equals(genericReturnType)) continue;
                    if (arg2 instanceof Class) {
                        Class clazz = (Class)arg2;
                        return clazz;
                    }
                    String className = null;
                    if (arg2 instanceof String) {
                        String name2;
                        className = name2 = (String)arg2;
                    } else if (arg2 instanceof TypedStringValue && ((targetTypeName = (typedValue = (TypedStringValue)arg2).getTargetTypeName()) == null || Class.class.getName().equals(targetTypeName))) {
                        className = typedValue.getValue();
                    }
                    if (className != null) {
                        try {
                            return ClassUtils.forName(className, classLoader);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new IllegalStateException("Could not resolve class name [" + arg2 + "] for factory method argument", ex);
                        }
                    }
                    return method2.getReturnType();
                }
            }
        }
        return method2.getReturnType();
    }

    private static class ObjectFactoryDelegatingInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final ObjectFactory<?> objectFactory;

        ObjectFactoryDelegatingInvocationHandler(ObjectFactory<?> objectFactory) {
            this.objectFactory = objectFactory;
        }

        @Override
        public Object invoke(Object proxy2, Method method2, Object[] args2) throws Throwable {
            Object object;
            switch (method2.getName()) {
                case "equals": {
                    Boolean bl = proxy2 == args2[0];
                    object = bl;
                    break;
                }
                case "hashCode": {
                    Integer n = System.identityHashCode(proxy2);
                    object = n;
                    break;
                }
                case "toString": {
                    String string2 = this.objectFactory.toString();
                    object = string2;
                    break;
                }
                default: {
                    try {
                        Object object2;
                        object = object2 = method2.invoke(this.objectFactory.getObject(), args2);
                        break;
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
            }
            return object;
        }
    }
}

