/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.parsing;

import org.springframework.beans.factory.parsing.AliasDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.DefaultsDefinition;
import org.springframework.beans.factory.parsing.ImportDefinition;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.ParseState;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;

public class ReaderContext {
    private final Resource resource;
    private final ProblemReporter problemReporter;
    private final ReaderEventListener eventListener;
    private final SourceExtractor sourceExtractor;

    public ReaderContext(Resource resource, ProblemReporter problemReporter, ReaderEventListener eventListener, SourceExtractor sourceExtractor) {
        this.resource = resource;
        this.problemReporter = problemReporter;
        this.eventListener = eventListener;
        this.sourceExtractor = sourceExtractor;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public void fatal(String message2, @Nullable Object source2) {
        this.fatal(message2, source2, null, null);
    }

    public void fatal(String message2, @Nullable Object source2, @Nullable Throwable cause2) {
        this.fatal(message2, source2, null, cause2);
    }

    public void fatal(String message2, @Nullable Object source2, @Nullable ParseState parseState) {
        this.fatal(message2, source2, parseState, null);
    }

    public void fatal(String message2, @Nullable Object source2, @Nullable ParseState parseState, @Nullable Throwable cause2) {
        Location location = new Location(this.getResource(), source2);
        this.problemReporter.fatal(new Problem(message2, location, parseState, cause2));
    }

    public void error(String message2, @Nullable Object source2) {
        this.error(message2, source2, null, null);
    }

    public void error(String message2, @Nullable Object source2, @Nullable Throwable cause2) {
        this.error(message2, source2, null, cause2);
    }

    public void error(String message2, @Nullable Object source2, @Nullable ParseState parseState) {
        this.error(message2, source2, parseState, null);
    }

    public void error(String message2, @Nullable Object source2, @Nullable ParseState parseState, @Nullable Throwable cause2) {
        Location location = new Location(this.getResource(), source2);
        this.problemReporter.error(new Problem(message2, location, parseState, cause2));
    }

    public void warning(String message2, @Nullable Object source2) {
        this.warning(message2, source2, null, null);
    }

    public void warning(String message2, @Nullable Object source2, @Nullable Throwable cause2) {
        this.warning(message2, source2, null, cause2);
    }

    public void warning(String message2, @Nullable Object source2, @Nullable ParseState parseState) {
        this.warning(message2, source2, parseState, null);
    }

    public void warning(String message2, @Nullable Object source2, @Nullable ParseState parseState, @Nullable Throwable cause2) {
        Location location = new Location(this.getResource(), source2);
        this.problemReporter.warning(new Problem(message2, location, parseState, cause2));
    }

    public void fireDefaultsRegistered(DefaultsDefinition defaultsDefinition) {
        this.eventListener.defaultsRegistered(defaultsDefinition);
    }

    public void fireComponentRegistered(ComponentDefinition componentDefinition) {
        this.eventListener.componentRegistered(componentDefinition);
    }

    public void fireAliasRegistered(String beanName, String alias, @Nullable Object source2) {
        this.eventListener.aliasRegistered(new AliasDefinition(beanName, alias, source2));
    }

    public void fireImportProcessed(String importedResource, @Nullable Object source2) {
        this.eventListener.importProcessed(new ImportDefinition(importedResource, source2));
    }

    public void fireImportProcessed(String importedResource, Resource[] actualResources, @Nullable Object source2) {
        this.eventListener.importProcessed(new ImportDefinition(importedResource, actualResources, source2));
    }

    public SourceExtractor getSourceExtractor() {
        return this.sourceExtractor;
    }

    @Nullable
    public Object extractSource(Object sourceCandidate) {
        return this.sourceExtractor.extractSource(sourceCandidate, this.resource);
    }
}

