/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.groovy;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.groovy.GroovyBeanDefinitionWrapper;
import org.springframework.beans.factory.groovy.GroovyDynamicElementReader;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class GroovyBeanDefinitionReader
extends AbstractBeanDefinitionReader
implements GroovyObject {
    private final XmlBeanDefinitionReader standardXmlBeanDefinitionReader;
    private final XmlBeanDefinitionReader groovyDslXmlBeanDefinitionReader;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Map<String, DeferredProperty> deferredProperties = new HashMap<String, DeferredProperty>();
    private MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.getClass());
    @Nullable
    private Binding binding;
    @Nullable
    private GroovyBeanDefinitionWrapper currentBeanDefinition;

    public GroovyBeanDefinitionReader(BeanDefinitionRegistry registry) {
        super(registry);
        this.standardXmlBeanDefinitionReader = new XmlBeanDefinitionReader(registry);
        this.groovyDslXmlBeanDefinitionReader = new XmlBeanDefinitionReader(registry);
        this.groovyDslXmlBeanDefinitionReader.setValidating(false);
    }

    public GroovyBeanDefinitionReader(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        super(xmlBeanDefinitionReader.getRegistry());
        this.standardXmlBeanDefinitionReader = new XmlBeanDefinitionReader(xmlBeanDefinitionReader.getRegistry());
        this.groovyDslXmlBeanDefinitionReader = xmlBeanDefinitionReader;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setBinding(Binding binding2) {
        this.binding = binding2;
    }

    @Nullable
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public int loadBeanDefinitions(Resource resource) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(new EncodedResource(resource));
    }

    public int loadBeanDefinitions(EncodedResource encodedResource) throws BeanDefinitionStoreException {
        String filename2 = encodedResource.getResource().getFilename();
        if (StringUtils.endsWithIgnoreCase(filename2, ".xml")) {
            return this.standardXmlBeanDefinitionReader.loadBeanDefinitions(encodedResource);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Loading Groovy bean definitions from " + encodedResource);
        }
        Closure<Object> beans2 = new Closure<Object>((Object)this){

            @Nullable
            public Object call(Object ... args2) {
                GroovyBeanDefinitionReader.this.invokeBeanDefiningClosure((Closure)args2[0]);
                return null;
            }
        };
        Binding binding2 = new Binding(){

            public void setVariable(String name2, Object value2) {
                if (GroovyBeanDefinitionReader.this.currentBeanDefinition != null) {
                    GroovyBeanDefinitionReader.this.applyPropertyToBeanDefinition(name2, value2);
                } else {
                    super.setVariable(name2, value2);
                }
            }
        };
        binding2.setVariable("beans", (Object)beans2);
        int countBefore = this.getRegistry().getBeanDefinitionCount();
        try {
            GroovyShell shell = new GroovyShell(this.getBeanClassLoader(), binding2);
            shell.evaluate(encodedResource.getReader(), "beans");
        }
        catch (Throwable ex) {
            throw new BeanDefinitionParsingException(new Problem("Error evaluating Groovy script: " + ex.getMessage(), new Location(encodedResource.getResource()), null, ex));
        }
        int count2 = this.getRegistry().getBeanDefinitionCount() - countBefore;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loaded " + count2 + " bean definitions from " + encodedResource);
        }
        return count2;
    }

    public GroovyBeanDefinitionReader beans(Closure<?> closure) {
        return this.invokeBeanDefiningClosure(closure);
    }

    public GenericBeanDefinition bean(Class<?> type2) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(type2);
        return beanDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBeanDefinition bean(Class<?> type2, Object ... args2) {
        GroovyBeanDefinitionWrapper current2 = this.currentBeanDefinition;
        try {
            Closure callable = null;
            List<Object> constructorArgs = null;
            if (!ObjectUtils.isEmpty(args2)) {
                int index2 = args2.length;
                Object lastArg = args2[index2 - 1];
                if (lastArg instanceof Closure) {
                    Closure closure;
                    callable = closure = (Closure)lastArg;
                    --index2;
                }
                constructorArgs = this.resolveConstructorArguments(args2, 0, index2);
            }
            this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(null, type2, constructorArgs);
            if (callable != null) {
                callable.call((Object)this.currentBeanDefinition);
            }
            AbstractBeanDefinition abstractBeanDefinition = this.currentBeanDefinition.getBeanDefinition();
            return abstractBeanDefinition;
        }
        finally {
            this.currentBeanDefinition = current2;
        }
    }

    public void xmlns(Map<String, String> definition) {
        if (!definition.isEmpty()) {
            for (Map.Entry<String, String> entry : definition.entrySet()) {
                String namespace = entry.getKey();
                String uri = entry.getValue();
                if (uri == null) {
                    throw new IllegalArgumentException("Namespace definition must supply a non-null URI");
                }
                NamespaceHandler namespaceHandler = this.groovyDslXmlBeanDefinitionReader.getNamespaceHandlerResolver().resolve(uri);
                if (namespaceHandler == null) {
                    throw new BeanDefinitionParsingException(new Problem("No namespace handler found for URI: " + uri, new Location(new DescriptiveResource("Groovy"))));
                }
                this.namespaces.put(namespace, uri);
            }
        }
    }

    public void importBeans(String resourcePattern) throws IOException {
        this.loadBeanDefinitions(resourcePattern);
    }

    public Object invokeMethod(String name2, Object arg2) {
        Object object;
        Object[] args2 = (Object[])arg2;
        if ("beans".equals(name2) && args2.length == 1 && (object = args2[0]) instanceof Closure) {
            Closure closure = (Closure)object;
            return this.beans(closure);
        }
        if ("ref".equals(name2)) {
            Object object2;
            String refName;
            if (args2[0] == null) {
                throw new IllegalArgumentException("Argument to ref() is not a valid bean or was not found");
            }
            Object object3 = args2[0];
            if (object3 instanceof RuntimeBeanReference) {
                RuntimeBeanReference runtimeBeanReference = (RuntimeBeanReference)object3;
                refName = runtimeBeanReference.getBeanName();
            } else {
                refName = args2[0].toString();
            }
            boolean parentRef = false;
            if (args2.length > 1 && (object2 = args2[1]) instanceof Boolean) {
                Boolean bool2 = (Boolean)object2;
                parentRef = bool2;
            }
            return new RuntimeBeanReference(refName, parentRef);
        }
        if (this.namespaces.containsKey(name2) && args2.length > 0 && args2[0] instanceof Closure) {
            GroovyDynamicElementReader reader = this.createDynamicElementReader(name2);
            reader.invokeMethod("doCall", args2);
        } else {
            if (args2.length > 0 && args2[0] instanceof Closure) {
                return this.invokeBeanDefiningMethod(name2, args2);
            }
            if (args2.length > 0 && (args2[0] instanceof Class || args2[0] instanceof RuntimeBeanReference || args2[0] instanceof Map)) {
                return this.invokeBeanDefiningMethod(name2, args2);
            }
            if (args2.length > 1 && args2[args2.length - 1] instanceof Closure) {
                return this.invokeBeanDefiningMethod(name2, args2);
            }
        }
        MetaClass mc = DefaultGroovyMethods.getMetaClass((Object)this.getRegistry());
        if (!mc.respondsTo((Object)this.getRegistry(), name2, args2).isEmpty()) {
            return mc.invokeMethod((Object)this.getRegistry(), name2, args2);
        }
        return this;
    }

    private boolean addDeferredProperty(String property, Object newValue) {
        if (newValue instanceof List || newValue instanceof Map) {
            Assert.state(this.currentBeanDefinition != null, "No current bean definition set");
            this.deferredProperties.put(this.currentBeanDefinition.getBeanName() + "." + property, new DeferredProperty(this.currentBeanDefinition, property, newValue));
            return true;
        }
        return false;
    }

    private void finalizeDeferredProperties() {
        for (DeferredProperty dp : this.deferredProperties.values()) {
            Object object = dp.value;
            if (object instanceof List) {
                List list2 = (List)object;
                dp.value = this.manageListIfNecessary(list2);
            } else {
                object = dp.value;
                if (object instanceof Map) {
                    Map map2 = (Map)object;
                    dp.value = this.manageMapIfNecessary(map2);
                }
            }
            dp.apply();
        }
        this.deferredProperties.clear();
    }

    protected GroovyBeanDefinitionReader invokeBeanDefiningClosure(Closure<?> callable) {
        callable.setDelegate((Object)this);
        callable.call();
        this.finalizeDeferredProperties();
        return this;
    }

    private GroovyBeanDefinitionWrapper invokeBeanDefiningMethod(String beanName, Object[] args2) {
        boolean hasClosureArgument = args2[args2.length - 1] instanceof Closure;
        Object object = args2[0];
        if (object instanceof Class) {
            Class beanClass = (Class)object;
            this.currentBeanDefinition = hasClosureArgument ? (args2.length - 1 != 1 ? new GroovyBeanDefinitionWrapper(beanName, beanClass, this.resolveConstructorArguments(args2, 1, args2.length - 1)) : new GroovyBeanDefinitionWrapper(beanName, beanClass)) : new GroovyBeanDefinitionWrapper(beanName, beanClass, this.resolveConstructorArguments(args2, 1, args2.length));
        } else {
            object = args2[0];
            if (object instanceof RuntimeBeanReference) {
                RuntimeBeanReference runtimeBeanReference = (RuntimeBeanReference)object;
                this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(beanName);
                this.currentBeanDefinition.getBeanDefinition().setFactoryBeanName(runtimeBeanReference.getBeanName());
            } else {
                object = args2[0];
                if (object instanceof Map) {
                    Object object2;
                    Map namedArgs = (Map)object;
                    if (args2.length > 1 && (object2 = args2[1]) instanceof Class) {
                        Class clazz = (Class)object2;
                        List<Object> constructorArgs = this.resolveConstructorArguments(args2, 2, hasClosureArgument ? args2.length - 1 : args2.length);
                        this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(beanName, clazz, constructorArgs);
                        for (Map.Entry entity : namedArgs.entrySet()) {
                            String propName = (String)entity.getKey();
                            this.setProperty(propName, entity.getValue());
                        }
                    } else {
                        int constructorArgsTest;
                        this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(beanName);
                        Map.Entry factoryBeanEntry = namedArgs.entrySet().iterator().next();
                        int n = constructorArgsTest = hasClosureArgument ? 2 : 1;
                        if (args2.length > constructorArgsTest) {
                            int endOfConstructArgs = hasClosureArgument ? args2.length - 1 : args2.length;
                            this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(beanName, null, this.resolveConstructorArguments(args2, 1, endOfConstructArgs));
                        } else {
                            this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(beanName);
                        }
                        this.currentBeanDefinition.getBeanDefinition().setFactoryBeanName(factoryBeanEntry.getKey().toString());
                        this.currentBeanDefinition.getBeanDefinition().setFactoryMethodName(factoryBeanEntry.getValue().toString());
                    }
                } else if (args2[0] instanceof Closure) {
                    this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(beanName);
                    this.currentBeanDefinition.getBeanDefinition().setAbstract(true);
                } else {
                    List<Object> constructorArgs = this.resolveConstructorArguments(args2, 0, hasClosureArgument ? args2.length - 1 : args2.length);
                    this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(beanName, null, constructorArgs);
                }
            }
        }
        if (hasClosureArgument) {
            Closure callable = (Closure)args2[args2.length - 1];
            callable.setDelegate((Object)this);
            callable.setResolveStrategy(1);
            callable.call((Object)this.currentBeanDefinition);
        }
        GroovyBeanDefinitionWrapper beanDefinition = this.currentBeanDefinition;
        this.currentBeanDefinition = null;
        beanDefinition.getBeanDefinition().setAttribute(GroovyBeanDefinitionWrapper.class.getName(), (Object)beanDefinition);
        this.getRegistry().registerBeanDefinition(beanName, beanDefinition.getBeanDefinition());
        return beanDefinition;
    }

    protected List<Object> resolveConstructorArguments(Object[] args2, int start2, int end2) {
        Object[] constructorArgs = Arrays.copyOfRange(args2, start2, end2);
        for (int i2 = 0; i2 < constructorArgs.length; ++i2) {
            if (constructorArgs[i2] instanceof GString) {
                constructorArgs[i2] = constructorArgs[i2].toString();
                continue;
            }
            Object object = constructorArgs[i2];
            if (object instanceof List) {
                List list2 = (List)object;
                constructorArgs[i2] = this.manageListIfNecessary(list2);
                continue;
            }
            object = constructorArgs[i2];
            if (!(object instanceof Map)) continue;
            Map map2 = (Map)object;
            constructorArgs[i2] = this.manageMapIfNecessary(map2);
        }
        return List.of(constructorArgs);
    }

    private Object manageMapIfNecessary(Map<?, ?> map2) {
        boolean containsRuntimeRefs = false;
        for (Object element : map2.values()) {
            if (!(element instanceof RuntimeBeanReference)) continue;
            containsRuntimeRefs = true;
            break;
        }
        if (containsRuntimeRefs) {
            ManagedMap managedMap = new ManagedMap();
            managedMap.putAll(map2);
            return managedMap;
        }
        return map2;
    }

    private Object manageListIfNecessary(List<?> list2) {
        boolean containsRuntimeRefs = false;
        for (Object element : list2) {
            if (!(element instanceof RuntimeBeanReference)) continue;
            containsRuntimeRefs = true;
            break;
        }
        if (containsRuntimeRefs) {
            ManagedList managedList = new ManagedList();
            managedList.addAll(list2);
            return managedList;
        }
        return list2;
    }

    public void setProperty(String name2, Object value2) {
        if (this.currentBeanDefinition != null) {
            this.applyPropertyToBeanDefinition(name2, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyPropertyToBeanDefinition(String name2, Object value2) {
        if (value2 instanceof GString) {
            value2 = value2.toString();
        }
        if (this.addDeferredProperty(name2, value2)) {
            return;
        }
        if (value2 instanceof Closure) {
            Closure callable = (Closure)value2;
            GroovyBeanDefinitionWrapper current2 = this.currentBeanDefinition;
            try {
                Class parameterType = callable.getParameterTypes()[0];
                if (Object.class == parameterType) {
                    this.currentBeanDefinition = new GroovyBeanDefinitionWrapper("");
                    callable.call((Object)this.currentBeanDefinition);
                } else {
                    this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(null, parameterType);
                    callable.call(null);
                }
                value2 = this.currentBeanDefinition.getBeanDefinition();
            }
            finally {
                this.currentBeanDefinition = current2;
            }
        }
        Assert.state(this.currentBeanDefinition != null, "No current bean definition set");
        this.currentBeanDefinition.addProperty(name2, value2);
    }

    @Nullable
    public Object getProperty(String name2) {
        Binding binding2 = this.getBinding();
        if (binding2 != null && binding2.hasVariable(name2)) {
            return binding2.getVariable(name2);
        }
        if (this.namespaces.containsKey(name2)) {
            return this.createDynamicElementReader(name2);
        }
        if (this.getRegistry().containsBeanDefinition(name2)) {
            GroovyBeanDefinitionWrapper beanDefinition = (GroovyBeanDefinitionWrapper)((Object)this.getRegistry().getBeanDefinition(name2).getAttribute(GroovyBeanDefinitionWrapper.class.getName()));
            if (beanDefinition != null) {
                return new GroovyRuntimeBeanReference(name2, beanDefinition, false);
            }
            return new RuntimeBeanReference(name2, false);
        }
        if (this.currentBeanDefinition != null) {
            MutablePropertyValues pvs = this.currentBeanDefinition.getBeanDefinition().getPropertyValues();
            if (pvs.contains(name2)) {
                return pvs.get(name2);
            }
            DeferredProperty dp = this.deferredProperties.get(this.currentBeanDefinition.getBeanName() + name2);
            if (dp != null) {
                return dp.value;
            }
            return this.getMetaClass().getProperty((Object)this, name2);
        }
        return this.getMetaClass().getProperty((Object)this, name2);
    }

    private GroovyDynamicElementReader createDynamicElementReader(String namespace) {
        boolean decorating;
        XmlReaderContext readerContext = this.groovyDslXmlBeanDefinitionReader.createReaderContext(new DescriptiveResource("Groovy"));
        BeanDefinitionParserDelegate delegate = new BeanDefinitionParserDelegate(readerContext);
        boolean bl = decorating = this.currentBeanDefinition != null;
        if (!decorating) {
            this.currentBeanDefinition = new GroovyBeanDefinitionWrapper(namespace);
        }
        return new GroovyDynamicElementReader(namespace, this.namespaces, delegate, this.currentBeanDefinition, decorating){

            @Override
            protected void afterInvocation() {
                if (!this.decorating) {
                    GroovyBeanDefinitionReader.this.currentBeanDefinition = null;
                }
            }
        };
    }

    private static class DeferredProperty {
        private final GroovyBeanDefinitionWrapper beanDefinition;
        private final String name;
        @Nullable
        public Object value;

        public DeferredProperty(GroovyBeanDefinitionWrapper beanDefinition, String name2, @Nullable Object value2) {
            this.beanDefinition = beanDefinition;
            this.name = name2;
            this.value = value2;
        }

        public void apply() {
            this.beanDefinition.addProperty(this.name, this.value);
        }
    }

    private class GroovyRuntimeBeanReference
    extends RuntimeBeanReference
    implements GroovyObject {
        private final GroovyBeanDefinitionWrapper beanDefinition;
        private MetaClass metaClass;

        public GroovyRuntimeBeanReference(String beanName, GroovyBeanDefinitionWrapper beanDefinition, boolean toParent) {
            super(beanName, toParent);
            this.beanDefinition = beanDefinition;
            this.metaClass = InvokerHelper.getMetaClass((Object)this);
        }

        public MetaClass getMetaClass() {
            return this.metaClass;
        }

        @Nullable
        public Object getProperty(String property) {
            if (property.equals("beanName")) {
                return this.getBeanName();
            }
            if (property.equals("source")) {
                return this.getSource();
            }
            return new GroovyPropertyValue(property, this.beanDefinition.getBeanDefinition().getPropertyValues().get(property));
        }

        public Object invokeMethod(String name2, Object args2) {
            return this.metaClass.invokeMethod((Object)this, name2, args2);
        }

        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public void setProperty(String property, Object newValue) {
            if (!GroovyBeanDefinitionReader.this.addDeferredProperty(property, newValue)) {
                this.beanDefinition.getBeanDefinition().getPropertyValues().add(property, newValue);
            }
        }

        private class GroovyPropertyValue
        extends GroovyObjectSupport {
            private final String propertyName;
            @Nullable
            private final Object propertyValue;

            public GroovyPropertyValue(@Nullable String propertyName, Object propertyValue) {
                this.propertyName = propertyName;
                this.propertyValue = propertyValue;
            }

            public void leftShift(Object value2) {
                InvokerHelper.invokeMethod((Object)this.propertyValue, (String)"leftShift", (Object)value2);
                this.updateDeferredProperties(value2);
            }

            public boolean add(Object value2) {
                boolean retVal = (Boolean)InvokerHelper.invokeMethod((Object)this.propertyValue, (String)"add", (Object)value2);
                this.updateDeferredProperties(value2);
                return retVal;
            }

            public boolean addAll(Collection<?> values2) {
                boolean retVal = (Boolean)InvokerHelper.invokeMethod((Object)this.propertyValue, (String)"addAll", values2);
                for (Object value2 : values2) {
                    this.updateDeferredProperties(value2);
                }
                return retVal;
            }

            public Object invokeMethod(String name2, Object args2) {
                return InvokerHelper.invokeMethod((Object)this.propertyValue, (String)name2, (Object)args2);
            }

            public Object getProperty(String name2) {
                return InvokerHelper.getProperty((Object)this.propertyValue, (String)name2);
            }

            public void setProperty(String name2, Object value2) {
                InvokerHelper.setProperty((Object)this.propertyValue, (String)name2, (Object)value2);
            }

            private void updateDeferredProperties(Object value2) {
                if (value2 instanceof RuntimeBeanReference) {
                    GroovyBeanDefinitionReader.this.deferredProperties.put(GroovyRuntimeBeanReference.this.beanDefinition.getBeanName(), new DeferredProperty(GroovyRuntimeBeanReference.this.beanDefinition, this.propertyName, this.propertyValue));
                }
            }
        }
    }
}

