/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public abstract class YamlProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ResolutionMethod resolutionMethod = ResolutionMethod.OVERRIDE;
    private Resource[] resources = new Resource[0];
    private List<DocumentMatcher> documentMatchers = Collections.emptyList();
    private boolean matchDefault = true;
    private Set<String> supportedTypes = Collections.emptySet();

    public void setDocumentMatchers(DocumentMatcher ... matchers) {
        this.documentMatchers = List.of(matchers);
    }

    public void setMatchDefault(boolean matchDefault) {
        this.matchDefault = matchDefault;
    }

    public void setResolutionMethod(ResolutionMethod resolutionMethod) {
        Assert.notNull((Object)resolutionMethod, "ResolutionMethod must not be null");
        this.resolutionMethod = resolutionMethod;
    }

    public void setResources(Resource ... resources) {
        this.resources = resources;
    }

    public void setSupportedTypes(Class<?> ... supportedTypes) {
        if (ObjectUtils.isEmpty(supportedTypes)) {
            this.supportedTypes = Collections.emptySet();
        } else {
            Assert.noNullElements((Object[])supportedTypes, "'supportedTypes' must not contain null elements");
            this.supportedTypes = Arrays.stream(supportedTypes).map(Class::getName).collect(Collectors.toUnmodifiableSet());
        }
    }

    protected void process(MatchCallback callback) {
        Yaml yaml = this.createYaml();
        for (Resource resource : this.resources) {
            boolean found = this.process(callback, yaml, resource);
            if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND || !found) continue;
            return;
        }
    }

    protected Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        loaderOptions.setTagInspector(new SupportedTagInspector());
        DumperOptions dumperOptions = new DumperOptions();
        return new Yaml((BaseConstructor)new Constructor(loaderOptions), new Representer(dumperOptions), dumperOptions, loaderOptions);
    }

    private boolean process(MatchCallback callback, Yaml yaml, Resource resource) {
        int count2 = 0;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Loading from YAML: " + resource);
            }
            try (UnicodeReader reader = new UnicodeReader(resource.getInputStream());){
                for (Object object : yaml.loadAll(reader)) {
                    if (object == null || !this.process(this.asMap(object), callback)) continue;
                    ++count2;
                    if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND) continue;
                    break;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loaded " + count2 + " document" + (count2 > 1 ? "s" : "") + " from YAML resource: " + resource);
                }
            }
        }
        catch (IOException ex) {
            this.handleProcessError(resource, ex);
        }
        return count2 > 0;
    }

    private void handleProcessError(Resource resource, IOException ex) {
        if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND && this.resolutionMethod != ResolutionMethod.OVERRIDE_AND_IGNORE) {
            throw new IllegalStateException(ex);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Could not load map from " + resource + ": " + ex.getMessage());
        }
    }

    private Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result2.put("document", object);
            return result2;
        }
        Map map2 = (Map)object;
        map2.forEach((key2, value2) -> {
            if (value2 instanceof Map) {
                value2 = this.asMap(value2);
            }
            if (key2 instanceof CharSequence) {
                result2.put(key2.toString(), value2);
            } else {
                result2.put("[" + key2.toString() + "]", value2);
            }
        });
        return result2;
    }

    private boolean process(Map<String, Object> map2, MatchCallback callback) {
        Properties properties = CollectionFactory.createStringAdaptingProperties();
        properties.putAll(this.getFlattenedMap(map2));
        if (this.documentMatchers.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Merging document (no matchers set): " + map2);
            }
            callback.process(properties, map2);
            return true;
        }
        MatchStatus result2 = MatchStatus.ABSTAIN;
        for (DocumentMatcher matcher : this.documentMatchers) {
            MatchStatus match2 = matcher.matches(properties);
            result2 = MatchStatus.getMostSpecific(match2, result2);
            if (match2 != MatchStatus.FOUND) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Matched document with document matcher: " + properties);
            }
            callback.process(properties, map2);
            return true;
        }
        if (result2 == MatchStatus.ABSTAIN && this.matchDefault) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Matched document with default matcher: " + map2);
            }
            callback.process(properties, map2);
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unmatched document: " + map2);
        }
        return false;
    }

    protected final Map<String, Object> getFlattenedMap(Map<String, Object> source2) {
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result2, source2, null);
        return result2;
    }

    private void buildFlattenedMap(Map<String, Object> result2, Map<String, Object> source2, @Nullable String path2) {
        source2.forEach((key2, value2) -> {
            if (StringUtils.hasText(path2)) {
                key2 = ((String)key2).startsWith("[") ? path2 + (String)key2 : path2 + "." + (String)key2;
            }
            if (value2 instanceof String) {
                result2.put((String)key2, value2);
            } else if (value2 instanceof Map) {
                Map map2 = (Map)value2;
                this.buildFlattenedMap(result2, map2, (String)key2);
            } else if (value2 instanceof Collection) {
                Collection collection = (Collection)value2;
                if (collection.isEmpty()) {
                    result2.put((String)key2, "");
                } else {
                    int count2 = 0;
                    for (Object object : collection) {
                        this.buildFlattenedMap(result2, Collections.singletonMap("[" + count2++ + "]", object), (String)key2);
                    }
                }
            } else {
                result2.put((String)key2, value2 != null ? value2 : "");
            }
        });
    }

    public static enum ResolutionMethod {
        OVERRIDE,
        OVERRIDE_AND_IGNORE,
        FIRST_FOUND;

    }

    @FunctionalInterface
    public static interface MatchCallback {
        public void process(Properties var1, Map<String, Object> var2);
    }

    private class SupportedTagInspector
    implements TagInspector {
        private SupportedTagInspector() {
        }

        @Override
        public boolean isGlobalTagAllowed(Tag tag2) {
            return YamlProcessor.this.supportedTypes.contains(tag2.getClassName());
        }
    }

    public static enum MatchStatus {
        FOUND,
        NOT_FOUND,
        ABSTAIN;


        public static MatchStatus getMostSpecific(MatchStatus a, MatchStatus b2) {
            return a.ordinal() < b2.ordinal() ? a : b2;
        }
    }

    @FunctionalInterface
    public static interface DocumentMatcher {
        public MatchStatus matches(Properties var1);
    }
}

