/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.function.Consumer;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import org.springframework.aot.generate.AccessControl;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.AutowiredArgumentsCodeGenerator;
import org.springframework.beans.factory.aot.BeanInstanceSupplier;
import org.springframework.beans.factory.aot.CodeWarnings;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.ThrowingSupplier;

public class InstanceSupplierCodeGenerator {
    private static final String REGISTERED_BEAN_PARAMETER_NAME = "registeredBean";
    private static final String ARGS_PARAMETER_NAME = "args";
    private static final javax.lang.model.element.Modifier[] PRIVATE_STATIC = new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC};
    private static final CodeBlock NO_ARGS = CodeBlock.of("", new Object[0]);
    private final GenerationContext generationContext;
    private final ClassName className;
    private final GeneratedMethods generatedMethods;
    private final boolean allowDirectSupplierShortcut;

    public InstanceSupplierCodeGenerator(GenerationContext generationContext, ClassName className, GeneratedMethods generatedMethods, boolean allowDirectSupplierShortcut) {
        this.generationContext = generationContext;
        this.className = className;
        this.generatedMethods = generatedMethods;
        this.allowDirectSupplierShortcut = allowDirectSupplierShortcut;
    }

    @Deprecated(since="6.1.7")
    public CodeBlock generateCode(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        return this.generateCode(registeredBean, new RegisteredBean.InstantiationDescriptor(constructorOrFactoryMethod, constructorOrFactoryMethod.getDeclaringClass()));
    }

    public CodeBlock generateCode(RegisteredBean registeredBean, RegisteredBean.InstantiationDescriptor instantiationDescriptor) {
        Executable constructorOrFactoryMethod = instantiationDescriptor.executable();
        this.registerRuntimeHintsIfNecessary(registeredBean, constructorOrFactoryMethod);
        if (constructorOrFactoryMethod instanceof Constructor) {
            Constructor constructor2 = (Constructor)constructorOrFactoryMethod;
            return this.generateCodeForConstructor(registeredBean, constructor2);
        }
        if (constructorOrFactoryMethod instanceof Method) {
            Method method2 = (Method)constructorOrFactoryMethod;
            return this.generateCodeForFactoryMethod(registeredBean, method2, instantiationDescriptor.targetClass());
        }
        throw new IllegalStateException("No suitable executor found for " + registeredBean.getBeanName());
    }

    private void registerRuntimeHintsIfNecessary(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        ConfigurableListableBeanFactory configurableListableBeanFactory = registeredBean.getBeanFactory();
        if (configurableListableBeanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)configurableListableBeanFactory;
            RuntimeHints runtimeHints = this.generationContext.getRuntimeHints();
            ProxyRuntimeHintsRegistrar registrar = new ProxyRuntimeHintsRegistrar(dlbf.getAutowireCandidateResolver());
            if (constructorOrFactoryMethod instanceof Method) {
                Method method2 = (Method)constructorOrFactoryMethod;
                registrar.registerRuntimeHints(runtimeHints, method2);
            } else if (constructorOrFactoryMethod instanceof Constructor) {
                Constructor constructor2 = (Constructor)constructorOrFactoryMethod;
                registrar.registerRuntimeHints(runtimeHints, constructor2);
            }
        }
    }

    private CodeBlock generateCodeForConstructor(RegisteredBean registeredBean, Constructor<?> constructor2) {
        String beanName = registeredBean.getBeanName();
        Class<?> beanClass = registeredBean.getBeanClass();
        Class<?> declaringClass = constructor2.getDeclaringClass();
        boolean dependsOnBean = ClassUtils.isInnerClass(declaringClass);
        AccessControl.Visibility accessVisibility = this.getAccessVisibility(registeredBean, constructor2);
        if (KotlinDetector.isKotlinReflectPresent() && KotlinDelegate.hasConstructorWithOptionalParameter(beanClass)) {
            return this.generateCodeForInaccessibleConstructor(beanName, beanClass, constructor2, dependsOnBean, hints -> hints.registerType(beanClass, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS));
        }
        if (accessVisibility != AccessControl.Visibility.PRIVATE) {
            return this.generateCodeForAccessibleConstructor(beanName, beanClass, constructor2, dependsOnBean, declaringClass);
        }
        return this.generateCodeForInaccessibleConstructor(beanName, beanClass, constructor2, dependsOnBean, hints -> hints.registerConstructor(constructor2, ExecutableMode.INVOKE));
    }

    private CodeBlock generateCodeForAccessibleConstructor(String beanName, Class<?> beanClass, Constructor<?> constructor2, boolean dependsOnBean, Class<?> declaringClass) {
        this.generationContext.getRuntimeHints().reflection().registerConstructor(constructor2, ExecutableMode.INTROSPECT);
        if (!dependsOnBean && constructor2.getParameterCount() == 0) {
            if (!this.allowDirectSupplierShortcut) {
                return CodeBlock.of("$T.using($T::new)", InstanceSupplier.class, declaringClass);
            }
            if (!this.isThrowingCheckedException(constructor2)) {
                return CodeBlock.of("$T::new", declaringClass);
            }
            return CodeBlock.of("$T.of($T::new)", ThrowingSupplier.class, declaringClass);
        }
        GeneratedMethod generatedMethod = this.generateGetInstanceSupplierMethod(method2 -> this.buildGetInstanceMethodForConstructor((MethodSpec.Builder)method2, beanName, beanClass, constructor2, declaringClass, dependsOnBean, PRIVATE_STATIC));
        return this.generateReturnStatement(generatedMethod);
    }

    private CodeBlock generateCodeForInaccessibleConstructor(String beanName, Class<?> beanClass, Constructor<?> constructor2, boolean dependsOnBean, Consumer<ReflectionHints> hints) {
        CodeWarnings codeWarnings = new CodeWarnings();
        codeWarnings.detectDeprecation(beanClass, constructor2).detectDeprecation(Arrays.stream(constructor2.getParameters()).map(Parameter::getType));
        hints.accept(this.generationContext.getRuntimeHints().reflection());
        GeneratedMethod generatedMethod = this.generateGetInstanceSupplierMethod(method2 -> {
            method2.addJavadoc("Get the bean instance supplier for '$L'.", beanName);
            method2.addModifiers(PRIVATE_STATIC);
            codeWarnings.suppress((MethodSpec.Builder)method2);
            method2.returns(ParameterizedTypeName.get(BeanInstanceSupplier.class, beanClass));
            int parameterOffset = !dependsOnBean ? 0 : 1;
            method2.addStatement(this.generateResolverForConstructor(beanClass, constructor2, parameterOffset));
        });
        return this.generateReturnStatement(generatedMethod);
    }

    private void buildGetInstanceMethodForConstructor(MethodSpec.Builder method2, String beanName, Class<?> beanClass, Constructor<?> constructor2, Class<?> declaringClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        CodeWarnings codeWarnings = new CodeWarnings();
        codeWarnings.detectDeprecation(beanClass, constructor2, declaringClass).detectDeprecation(Arrays.stream(constructor2.getParameters()).map(Parameter::getType));
        method2.addJavadoc("Get the bean instance supplier for '$L'.", beanName);
        method2.addModifiers(modifiers);
        codeWarnings.suppress(method2);
        method2.returns(ParameterizedTypeName.get(BeanInstanceSupplier.class, beanClass));
        int parameterOffset = !dependsOnBean ? 0 : 1;
        CodeBlock.Builder code = CodeBlock.builder();
        code.add(this.generateResolverForConstructor(beanClass, constructor2, parameterOffset));
        boolean hasArguments = constructor2.getParameterCount() > 0;
        CodeBlock arguments = hasArguments ? new AutowiredArgumentsCodeGenerator(declaringClass, constructor2).generateCode(constructor2.getParameterTypes(), parameterOffset) : NO_ARGS;
        CodeBlock newInstance2 = this.generateNewInstanceCodeForConstructor(dependsOnBean, declaringClass, arguments);
        code.add(this.generateWithGeneratorCode(hasArguments, newInstance2));
        method2.addStatement(code.build());
    }

    private CodeBlock generateResolverForConstructor(Class<?> beanClass, Constructor<?> constructor2, int parameterOffset) {
        CodeBlock parameterTypes = this.generateParameterTypesCode(constructor2.getParameterTypes(), parameterOffset);
        return CodeBlock.of("return $T.<$T>forConstructor($L)", BeanInstanceSupplier.class, beanClass, parameterTypes);
    }

    private CodeBlock generateNewInstanceCodeForConstructor(boolean dependsOnBean, Class<?> declaringClass, CodeBlock args2) {
        if (!dependsOnBean) {
            return CodeBlock.of("new $T($L)", declaringClass, args2);
        }
        return CodeBlock.of("$L.getBeanFactory().getBean($T.class).new $L($L)", REGISTERED_BEAN_PARAMETER_NAME, declaringClass.getEnclosingClass(), declaringClass.getSimpleName(), args2);
    }

    private CodeBlock generateCodeForFactoryMethod(RegisteredBean registeredBean, Method factoryMethod, Class<?> targetClass) {
        String beanName = registeredBean.getBeanName();
        Class<?> targetClassToUse = ClassUtils.getUserClass(targetClass);
        boolean dependsOnBean = !Modifier.isStatic(factoryMethod.getModifiers());
        AccessControl.Visibility accessVisibility = this.getAccessVisibility(registeredBean, factoryMethod);
        if (accessVisibility != AccessControl.Visibility.PRIVATE) {
            return this.generateCodeForAccessibleFactoryMethod(beanName, factoryMethod, targetClassToUse, dependsOnBean);
        }
        return this.generateCodeForInaccessibleFactoryMethod(beanName, factoryMethod, targetClassToUse);
    }

    private CodeBlock generateCodeForAccessibleFactoryMethod(String beanName, Method factoryMethod, Class<?> targetClass, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, ExecutableMode.INTROSPECT);
        if (!dependsOnBean && factoryMethod.getParameterCount() == 0) {
            Class<?> suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.<$T>forFactoryMethod($T.class, $S)", BeanInstanceSupplier.class, suppliedType, targetClass, factoryMethod.getName());
            code.add(".withGenerator(($L) -> $T.$L())", REGISTERED_BEAN_PARAMETER_NAME, targetClass, factoryMethod.getName());
            return code.build();
        }
        GeneratedMethod getInstanceMethod = this.generateGetInstanceSupplierMethod(method2 -> this.buildGetInstanceMethodForFactoryMethod((MethodSpec.Builder)method2, beanName, factoryMethod, targetClass, dependsOnBean, PRIVATE_STATIC));
        return this.generateReturnStatement(getInstanceMethod);
    }

    private CodeBlock generateCodeForInaccessibleFactoryMethod(String beanName, Method factoryMethod, Class<?> targetClass) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, ExecutableMode.INVOKE);
        GeneratedMethod getInstanceMethod = this.generateGetInstanceSupplierMethod(method2 -> {
            Class<?> suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
            method2.addJavadoc("Get the bean instance supplier for '$L'.", beanName);
            method2.addModifiers(PRIVATE_STATIC);
            method2.returns(ParameterizedTypeName.get(BeanInstanceSupplier.class, suppliedType));
            method2.addStatement(this.generateInstanceSupplierForFactoryMethod(factoryMethod, suppliedType, targetClass, factoryMethod.getName()));
        });
        return this.generateReturnStatement(getInstanceMethod);
    }

    private void buildGetInstanceMethodForFactoryMethod(MethodSpec.Builder method2, String beanName, Method factoryMethod, Class<?> targetClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        String factoryMethodName = factoryMethod.getName();
        Class<?> suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
        CodeWarnings codeWarnings = new CodeWarnings();
        codeWarnings.detectDeprecation(targetClass, factoryMethod, suppliedType).detectDeprecation(Arrays.stream(factoryMethod.getParameters()).map(Parameter::getType));
        method2.addJavadoc("Get the bean instance supplier for '$L'.", beanName);
        method2.addModifiers(modifiers);
        codeWarnings.suppress(method2);
        method2.returns(ParameterizedTypeName.get(BeanInstanceSupplier.class, suppliedType));
        CodeBlock.Builder code = CodeBlock.builder();
        code.add(this.generateInstanceSupplierForFactoryMethod(factoryMethod, suppliedType, targetClass, factoryMethodName));
        boolean hasArguments = factoryMethod.getParameterCount() > 0;
        CodeBlock arguments = hasArguments ? new AutowiredArgumentsCodeGenerator(targetClass, factoryMethod).generateCode(factoryMethod.getParameterTypes()) : NO_ARGS;
        CodeBlock newInstance2 = this.generateNewInstanceCodeForMethod(dependsOnBean, targetClass, factoryMethodName, arguments);
        code.add(this.generateWithGeneratorCode(hasArguments, newInstance2));
        method2.addStatement(code.build());
    }

    private CodeBlock generateInstanceSupplierForFactoryMethod(Method factoryMethod, Class<?> suppliedType, Class<?> targetClass, String factoryMethodName) {
        if (factoryMethod.getParameterCount() == 0) {
            return CodeBlock.of("return $T.<$T>forFactoryMethod($T.class, $S)", BeanInstanceSupplier.class, suppliedType, targetClass, factoryMethodName);
        }
        CodeBlock parameterTypes = this.generateParameterTypesCode(factoryMethod.getParameterTypes(), 0);
        return CodeBlock.of("return $T.<$T>forFactoryMethod($T.class, $S, $L)", BeanInstanceSupplier.class, suppliedType, targetClass, factoryMethodName, parameterTypes);
    }

    private CodeBlock generateNewInstanceCodeForMethod(boolean dependsOnBean, Class<?> targetClass, String factoryMethodName, CodeBlock args2) {
        if (!dependsOnBean) {
            return CodeBlock.of("$T.$L($L)", targetClass, factoryMethodName, args2);
        }
        return CodeBlock.of("$L.getBeanFactory().getBean($T.class).$L($L)", REGISTERED_BEAN_PARAMETER_NAME, targetClass, factoryMethodName, args2);
    }

    private CodeBlock generateReturnStatement(GeneratedMethod generatedMethod) {
        return generatedMethod.toMethodReference().toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none(), this.className);
    }

    private CodeBlock generateWithGeneratorCode(boolean hasArguments, CodeBlock newInstance2) {
        CodeBlock lambdaArguments = hasArguments ? CodeBlock.of("($L, $L)", REGISTERED_BEAN_PARAMETER_NAME, ARGS_PARAMETER_NAME) : CodeBlock.of("($L)", REGISTERED_BEAN_PARAMETER_NAME);
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("\n", new Object[0]);
        code.indent().indent();
        code.add(".withGenerator($L -> $L)", lambdaArguments, newInstance2);
        code.unindent().unindent();
        return code.build();
    }

    private AccessControl.Visibility getAccessVisibility(RegisteredBean registeredBean, Member member) {
        AccessControl beanTypeAccessControl = AccessControl.forResolvableType(registeredBean.getBeanType());
        AccessControl memberAccessControl = AccessControl.forMember(member);
        return AccessControl.lowest(beanTypeAccessControl, memberAccessControl).getVisibility();
    }

    private CodeBlock generateParameterTypesCode(Class<?>[] parameterTypes, int offset2) {
        CodeBlock.Builder code = CodeBlock.builder();
        for (int i2 = offset2; i2 < parameterTypes.length; ++i2) {
            code.add(i2 != offset2 ? ", " : "", new Object[0]);
            code.add("$T.class", parameterTypes[i2]);
        }
        return code.build();
    }

    private GeneratedMethod generateGetInstanceSupplierMethod(Consumer<MethodSpec.Builder> method2) {
        return this.generatedMethods.add("getInstanceSupplier", method2);
    }

    private boolean isThrowingCheckedException(Executable executable) {
        return Arrays.stream(executable.getGenericExceptionTypes()).map(ResolvableType::forType).map(ResolvableType::toClass).anyMatch(Exception.class::isAssignableFrom);
    }

    private static class ProxyRuntimeHintsRegistrar {
        private final AutowireCandidateResolver candidateResolver;

        public ProxyRuntimeHintsRegistrar(AutowireCandidateResolver candidateResolver) {
            this.candidateResolver = candidateResolver;
        }

        public void registerRuntimeHints(RuntimeHints runtimeHints, Method method2) {
            Class<?>[] parameterTypes = method2.getParameterTypes();
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                MethodParameter methodParam = new MethodParameter(method2, i2);
                DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(methodParam, true);
                this.registerProxyIfNecessary(runtimeHints, dependencyDescriptor);
            }
        }

        public void registerRuntimeHints(RuntimeHints runtimeHints, Constructor<?> constructor2) {
            Class<?>[] parameterTypes = constructor2.getParameterTypes();
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                MethodParameter methodParam = new MethodParameter(constructor2, i2);
                DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(methodParam, true);
                this.registerProxyIfNecessary(runtimeHints, dependencyDescriptor);
            }
        }

        private void registerProxyIfNecessary(RuntimeHints runtimeHints, DependencyDescriptor dependencyDescriptor) {
            Class<?> proxyType = this.candidateResolver.getLazyResolutionProxyClass(dependencyDescriptor, null);
            if (proxyType != null && Proxy.isProxyClass(proxyType)) {
                runtimeHints.proxies().registerJdkProxy(proxyType.getInterfaces());
            }
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static boolean hasConstructorWithOptionalParameter(Class<?> beanClass) {
            if (KotlinDetector.isKotlinType(beanClass)) {
                KClass kClass = JvmClassMappingKt.getKotlinClass(beanClass);
                for (KFunction constructor2 : kClass.getConstructors()) {
                    for (KParameter parameter : constructor2.getParameters()) {
                        if (!parameter.isOptional()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

