/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Type;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.aot.BeanRegistrationKey;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.util.ClassUtils;

class BeanRegistrationsAotContribution
implements BeanFactoryInitializationAotContribution {
    private static final String BEAN_FACTORY_PARAMETER_NAME = "beanFactory";
    private final Map<BeanRegistrationKey, Registration> registrations;

    BeanRegistrationsAotContribution(Map<BeanRegistrationKey, Registration> registrations) {
        this.registrations = registrations;
    }

    @Override
    public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().addForFeature("BeanFactoryRegistrations", type2 -> {
            type2.addJavadoc("Register bean definitions for the bean factory.", new Object[0]);
            type2.addModifiers(Modifier.PUBLIC);
        });
        BeanRegistrationsCodeGenerator codeGenerator = new BeanRegistrationsCodeGenerator(generatedClass);
        GeneratedMethod generatedBeanDefinitionsMethod = codeGenerator.getMethods().add("registerBeanDefinitions", method2 -> this.generateRegisterBeanDefinitionsMethod((MethodSpec.Builder)method2, generationContext, codeGenerator));
        beanFactoryInitializationCode.addInitializer(generatedBeanDefinitionsMethod.toMethodReference());
        GeneratedMethod generatedAliasesMethod = codeGenerator.getMethods().add("registerAliases", this::generateRegisterAliasesMethod);
        beanFactoryInitializationCode.addInitializer(generatedAliasesMethod.toMethodReference());
        this.generateRegisterHints(generationContext.getRuntimeHints(), this.registrations);
    }

    private void generateRegisterBeanDefinitionsMethod(MethodSpec.Builder method2, GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        method2.addJavadoc("Register the bean definitions.", new Object[0]);
        method2.addModifiers(Modifier.PUBLIC);
        method2.addParameter((Type)((Object)DefaultListableBeanFactory.class), BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
        CodeBlock.Builder code = CodeBlock.builder();
        this.registrations.forEach((registeredBean, registration) -> {
            MethodReference beanDefinitionMethod = registration.methodGenerator.generateBeanDefinitionMethod(generationContext, beanRegistrationsCode);
            CodeBlock methodInvocation = beanDefinitionMethod.toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none(), beanRegistrationsCode.getClassName());
            code.addStatement("$L.registerBeanDefinition($S, $L)", BEAN_FACTORY_PARAMETER_NAME, registeredBean.beanName(), methodInvocation);
        });
        method2.addCode(code.build());
    }

    private void generateRegisterAliasesMethod(MethodSpec.Builder method2) {
        method2.addJavadoc("Register the aliases.", new Object[0]);
        method2.addModifiers(Modifier.PUBLIC);
        method2.addParameter((Type)((Object)DefaultListableBeanFactory.class), BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
        CodeBlock.Builder code = CodeBlock.builder();
        this.registrations.forEach((registeredBean, registration) -> {
            for (String alias : registration.aliases) {
                code.addStatement("$L.registerAlias($S, $S)", BEAN_FACTORY_PARAMETER_NAME, registeredBean.beanName(), alias);
            }
        });
        method2.addCode(code.build());
    }

    private void generateRegisterHints(RuntimeHints runtimeHints, Map<BeanRegistrationKey, Registration> registrations) {
        registrations.keySet().forEach(beanRegistrationKey -> {
            ReflectionHints hints = runtimeHints.reflection();
            Class<?> beanClass = beanRegistrationKey.beanClass();
            hints.registerType(beanClass, MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_METHODS);
            this.introspectPublicMethodsOnAllInterfaces(hints, beanClass);
        });
    }

    private void introspectPublicMethodsOnAllInterfaces(ReflectionHints hints, Class<?> type2) {
        for (Class<?> currentClass = type2; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Class<?> interfaceType : currentClass.getInterfaces()) {
                if (ClassUtils.isJavaLanguageInterface(interfaceType)) continue;
                hints.registerType(interfaceType, MemberCategory.INTROSPECT_PUBLIC_METHODS);
                this.introspectPublicMethodsOnAllInterfaces(hints, interfaceType);
            }
        }
    }

    static class BeanRegistrationsCodeGenerator
    implements BeanRegistrationsCode {
        private final GeneratedClass generatedClass;

        public BeanRegistrationsCodeGenerator(GeneratedClass generatedClass) {
            this.generatedClass = generatedClass;
        }

        @Override
        public ClassName getClassName() {
            return this.generatedClass.getName();
        }

        @Override
        public GeneratedMethods getMethods() {
            return this.generatedClass.getMethods();
        }
    }

    record Registration(BeanDefinitionMethodGenerator methodGenerator, String[] aliases) {
    }
}

