/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.ValueCodeGenerator;
import org.springframework.aot.generate.ValueCodeGeneratorDelegates;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.javapoet.AnnotationSpec;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;

abstract class BeanDefinitionPropertyValueCodeGeneratorDelegates {
    public static final List<ValueCodeGenerator.Delegate> INSTANCES = List.of(new ManagedListDelegate(), new ManagedSetDelegate(), new ManagedMapDelegate(), new LinkedHashMapDelegate(), new BeanReferenceDelegate(), new TypedStringValueDelegate());

    BeanDefinitionPropertyValueCodeGeneratorDelegates() {
    }

    private static class ManagedListDelegate
    extends ValueCodeGeneratorDelegates.CollectionDelegate<ManagedList<?>> {
        public ManagedListDelegate() {
            super(ManagedList.class, CodeBlock.of("new $T()", ManagedList.class));
        }
    }

    private static class ManagedSetDelegate
    extends ValueCodeGeneratorDelegates.CollectionDelegate<ManagedSet<?>> {
        public ManagedSetDelegate() {
            super(ManagedSet.class, CodeBlock.of("new $T()", ManagedSet.class));
        }
    }

    private static class ManagedMapDelegate
    implements ValueCodeGenerator.Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of("$T.ofEntries()", ManagedMap.class);

        private ManagedMapDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value2) {
            if (value2 instanceof ManagedMap) {
                ManagedMap managedMap = (ManagedMap)value2;
                return this.generateManagedMapCode(valueCodeGenerator, managedMap);
            }
            return null;
        }

        private <K, V> CodeBlock generateManagedMapCode(ValueCodeGenerator valueCodeGenerator, ManagedMap<K, V> managedMap) {
            if (managedMap.isEmpty()) {
                return EMPTY_RESULT;
            }
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.ofEntries(", ManagedMap.class);
            Iterator iterator = managedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                code.add("$T.entry($L,$L)", Map.class, valueCodeGenerator.generateCode(entry.getKey()), valueCodeGenerator.generateCode(entry.getValue()));
                if (!iterator.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }
    }

    private static class LinkedHashMapDelegate
    extends ValueCodeGeneratorDelegates.MapDelegate {
        private LinkedHashMapDelegate() {
        }

        @Override
        @Nullable
        protected CodeBlock generateMapCode(ValueCodeGenerator valueCodeGenerator, Map<?, ?> map2) {
            GeneratedMethods generatedMethods = valueCodeGenerator.getGeneratedMethods();
            if (map2 instanceof LinkedHashMap && generatedMethods != null) {
                return this.generateLinkedHashMapCode(valueCodeGenerator, generatedMethods, map2);
            }
            return super.generateMapCode(valueCodeGenerator, map2);
        }

        private CodeBlock generateLinkedHashMapCode(ValueCodeGenerator valueCodeGenerator, GeneratedMethods generatedMethods, Map<?, ?> map2) {
            GeneratedMethod generatedMethod = generatedMethods.add("getMap", method2 -> {
                method2.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{\"rawtypes\", \"unchecked\"}", new Object[0]).build());
                method2.returns((Type)((Object)Map.class));
                method2.addStatement("$T map = new $T($L)", Map.class, LinkedHashMap.class, map2.size());
                map2.forEach((key2, value2) -> method2.addStatement("map.put($L, $L)", valueCodeGenerator.generateCode(key2), valueCodeGenerator.generateCode(value2)));
                method2.addStatement("return map", new Object[0]);
            });
            return CodeBlock.of("$L()", generatedMethod.getName());
        }
    }

    private static class BeanReferenceDelegate
    implements ValueCodeGenerator.Delegate {
        private BeanReferenceDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value2) {
            RuntimeBeanReference runtimeBeanReference;
            if (value2 instanceof RuntimeBeanReference && (runtimeBeanReference = (RuntimeBeanReference)value2).getBeanType() != null) {
                return CodeBlock.of("new $T($T.class)", RuntimeBeanReference.class, runtimeBeanReference.getBeanType());
            }
            if (value2 instanceof BeanReference) {
                BeanReference beanReference = (BeanReference)value2;
                return CodeBlock.of("new $T($S)", RuntimeBeanReference.class, beanReference.getBeanName());
            }
            return null;
        }
    }

    private static class TypedStringValueDelegate
    implements ValueCodeGenerator.Delegate {
        private TypedStringValueDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value2) {
            if (value2 instanceof TypedStringValue) {
                TypedStringValue typedStringValue = (TypedStringValue)value2;
                return this.generateTypeStringValueCode(valueCodeGenerator, typedStringValue);
            }
            return null;
        }

        private CodeBlock generateTypeStringValueCode(ValueCodeGenerator valueCodeGenerator, TypedStringValue typedStringValue) {
            String value2 = typedStringValue.getValue();
            if (typedStringValue.hasTargetType()) {
                return CodeBlock.of("new $T($S, $L)", TypedStringValue.class, value2, valueCodeGenerator.generateCode(typedStringValue.getTargetType()));
            }
            return valueCodeGenerator.generateCode(value2);
        }
    }
}

