/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeGenerator;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.aot.CodeWarnings;
import org.springframework.beans.factory.aot.DefaultBeanRegistrationCodeFragments;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.MethodSpec;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class BeanDefinitionMethodGenerator {
    private final BeanDefinitionMethodGeneratorFactory methodGeneratorFactory;
    private final RegisteredBean registeredBean;
    @Nullable
    private final String currentPropertyName;
    private final List<BeanRegistrationAotContribution> aotContributions;

    BeanDefinitionMethodGenerator(BeanDefinitionMethodGeneratorFactory methodGeneratorFactory, RegisteredBean registeredBean, @Nullable String currentPropertyName, List<BeanRegistrationAotContribution> aotContributions) {
        this.methodGeneratorFactory = methodGeneratorFactory;
        this.registeredBean = registeredBean;
        this.currentPropertyName = currentPropertyName;
        this.aotContributions = aotContributions;
    }

    MethodReference generateBeanDefinitionMethod(GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        BeanRegistrationCodeFragments codeFragments = this.getCodeFragments(generationContext, beanRegistrationsCode);
        ClassName target2 = codeFragments.getTarget(this.registeredBean);
        if (this.isWritablePackageName(target2)) {
            GeneratedClass generatedClass = BeanDefinitionMethodGenerator.lookupGeneratedClass(generationContext, target2);
            GeneratedMethods generatedMethods = generatedClass.getMethods().withPrefix(this.getName());
            GeneratedMethod generatedMethod = this.generateBeanDefinitionMethod(generationContext, generatedClass.getName(), generatedMethods, codeFragments, Modifier.PUBLIC);
            return generatedMethod.toMethodReference();
        }
        GeneratedMethods generatedMethods = beanRegistrationsCode.getMethods().withPrefix(this.getName());
        GeneratedMethod generatedMethod = this.generateBeanDefinitionMethod(generationContext, beanRegistrationsCode.getClassName(), generatedMethods, codeFragments, Modifier.PRIVATE);
        return generatedMethod.toMethodReference();
    }

    private boolean isWritablePackageName(ClassName target2) {
        String packageName = target2.packageName();
        return !packageName.startsWith("java.") && !packageName.startsWith("javax.");
    }

    private static GeneratedClass lookupGeneratedClass(GenerationContext generationContext, ClassName target2) {
        ClassName topLevelClassName = target2.topLevelClassName();
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().getOrAddForFeatureComponent("BeanDefinitions", topLevelClassName, type2 -> {
            type2.addJavadoc("Bean definitions for {@link $T}.", topLevelClassName);
            type2.addModifiers(Modifier.PUBLIC);
        });
        List<String> names2 = target2.simpleNames();
        if (names2.size() == 1) {
            return generatedClass;
        }
        List<String> namesToProcess = names2.subList(1, names2.size());
        ClassName currentTargetClassName = topLevelClassName;
        GeneratedClass tmp = generatedClass;
        for (String nameToProcess : namesToProcess) {
            currentTargetClassName = currentTargetClassName.nestedClass(nameToProcess);
            tmp = BeanDefinitionMethodGenerator.createInnerClass(tmp, nameToProcess, currentTargetClassName);
        }
        return tmp;
    }

    private static GeneratedClass createInnerClass(GeneratedClass generatedClass, String name2, ClassName target2) {
        return generatedClass.getOrAdd(name2, type2 -> {
            type2.addJavadoc("Bean definitions for {@link $T}.", target2);
            type2.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        });
    }

    private BeanRegistrationCodeFragments getCodeFragments(GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        BeanRegistrationCodeFragments codeFragments = new DefaultBeanRegistrationCodeFragments(beanRegistrationsCode, this.registeredBean, this.methodGeneratorFactory);
        for (BeanRegistrationAotContribution aotContribution : this.aotContributions) {
            codeFragments = aotContribution.customizeBeanRegistrationCodeFragments(generationContext, codeFragments);
        }
        return codeFragments;
    }

    private GeneratedMethod generateBeanDefinitionMethod(GenerationContext generationContext, ClassName className, GeneratedMethods generatedMethods, BeanRegistrationCodeFragments codeFragments, Modifier modifier) {
        BeanRegistrationCodeGenerator codeGenerator = new BeanRegistrationCodeGenerator(className, generatedMethods, this.registeredBean, codeFragments);
        this.aotContributions.forEach(aotContribution -> aotContribution.applyTo(generationContext, codeGenerator));
        CodeWarnings codeWarnings = new CodeWarnings();
        codeWarnings.detectDeprecation(this.registeredBean.getBeanType());
        return generatedMethods.add("getBeanDefinition", method2 -> {
            method2.addJavadoc("Get the $L definition for '$L'.", this.registeredBean.isInnerBean() ? "inner-bean" : "bean", this.getName());
            method2.addModifiers(modifier, Modifier.STATIC);
            codeWarnings.suppress((MethodSpec.Builder)method2);
            method2.returns((Type)((Object)BeanDefinition.class));
            method2.addCode(codeGenerator.generateCode(generationContext));
        });
    }

    private String getName() {
        RegisteredBean nonGeneratedParent;
        if (this.currentPropertyName != null) {
            return this.currentPropertyName;
        }
        if (!this.registeredBean.isGeneratedBeanName()) {
            return this.getSimpleBeanName(this.registeredBean.getBeanName());
        }
        for (nonGeneratedParent = this.registeredBean; nonGeneratedParent != null && nonGeneratedParent.isGeneratedBeanName(); nonGeneratedParent = nonGeneratedParent.getParent()) {
        }
        if (nonGeneratedParent != null) {
            return this.getSimpleBeanName(nonGeneratedParent.getBeanName()) + "InnerBean";
        }
        return "innerBean";
    }

    private String getSimpleBeanName(String beanName) {
        int lastDot = beanName.lastIndexOf(46);
        beanName = lastDot != -1 ? beanName.substring(lastDot + 1) : beanName;
        int lastDollar = beanName.lastIndexOf(36);
        beanName = lastDollar != -1 ? beanName.substring(lastDollar + 1) : beanName;
        return StringUtils.uncapitalize(beanName);
    }
}

