/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import org.springframework.beans.BeansException;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;

public class NoSuchBeanDefinitionException
extends BeansException {
    @Nullable
    private final String beanName;
    @Nullable
    private final ResolvableType resolvableType;

    public NoSuchBeanDefinitionException(String name2) {
        super("No bean named '" + name2 + "' available");
        this.beanName = name2;
        this.resolvableType = null;
    }

    public NoSuchBeanDefinitionException(String name2, String message2) {
        super("No bean named '" + name2 + "' available: " + message2);
        this.beanName = name2;
        this.resolvableType = null;
    }

    public NoSuchBeanDefinitionException(Class<?> type2) {
        this(ResolvableType.forClass(type2));
    }

    public NoSuchBeanDefinitionException(Class<?> type2, String message2) {
        this(ResolvableType.forClass(type2), message2);
    }

    public NoSuchBeanDefinitionException(ResolvableType type2) {
        super("No qualifying bean of type '" + type2 + "' available");
        this.beanName = null;
        this.resolvableType = type2;
    }

    public NoSuchBeanDefinitionException(ResolvableType type2, String message2) {
        super("No qualifying bean of type '" + type2 + "' available: " + message2);
        this.beanName = null;
        this.resolvableType = type2;
    }

    @Nullable
    public String getBeanName() {
        return this.beanName;
    }

    @Nullable
    public Class<?> getBeanType() {
        return this.resolvableType != null ? this.resolvableType.resolve() : null;
    }

    @Nullable
    public ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public int getNumberOfBeansFound() {
        return 0;
    }
}

