/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class BeanFactoryUtils {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";
    private static final Map<String, String> transformedBeanNameCache = new ConcurrentHashMap<String, String>();

    public static boolean isFactoryDereference(@Nullable String name2) {
        return name2 != null && name2.startsWith("&");
    }

    public static String transformedBeanName(String name2) {
        Assert.notNull((Object)name2, "'name' must not be null");
        if (!name2.startsWith("&")) {
            return name2;
        }
        return transformedBeanNameCache.computeIfAbsent(name2, beanName -> {
            while ((beanName = beanName.substring("&".length())).startsWith("&")) {
            }
            return beanName;
        });
    }

    public static boolean isGeneratedBeanName(@Nullable String name2) {
        return name2 != null && name2.contains(GENERATED_BEAN_NAME_SEPARATOR);
    }

    public static String originalBeanName(String name2) {
        Assert.notNull((Object)name2, "'name' must not be null");
        int separatorIndex = name2.indexOf(GENERATED_BEAN_NAME_SEPARATOR);
        return separatorIndex != -1 ? name2.substring(0, separatorIndex) : name2;
    }

    public static int countBeansIncludingAncestors(ListableBeanFactory lbf) {
        return BeanFactoryUtils.beanNamesIncludingAncestors(lbf).length;
    }

    public static String[] beanNamesIncludingAncestors(ListableBeanFactory lbf) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors(lbf, Object.class);
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, ResolvableType type2) {
        HierarchicalBeanFactory hbf;
        BeanFactory beanFactory;
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type2);
        if (lbf instanceof HierarchicalBeanFactory && (beanFactory = (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory pbf = (ListableBeanFactory)beanFactory;
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(pbf, type2);
            result2 = BeanFactoryUtils.mergeNamesWithParent(result2, parentResult, hbf);
        }
        return result2;
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, ResolvableType type2, boolean includeNonSingletons, boolean allowEagerInit) {
        HierarchicalBeanFactory hbf;
        BeanFactory beanFactory;
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type2, includeNonSingletons, allowEagerInit);
        if (lbf instanceof HierarchicalBeanFactory && (beanFactory = (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory pbf = (ListableBeanFactory)beanFactory;
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(pbf, type2, includeNonSingletons, allowEagerInit);
            result2 = BeanFactoryUtils.mergeNamesWithParent(result2, parentResult, hbf);
        }
        return result2;
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, Class<?> type2) {
        HierarchicalBeanFactory hbf;
        BeanFactory beanFactory;
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type2);
        if (lbf instanceof HierarchicalBeanFactory && (beanFactory = (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory pbf = (ListableBeanFactory)beanFactory;
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(pbf, type2);
            result2 = BeanFactoryUtils.mergeNamesWithParent(result2, parentResult, hbf);
        }
        return result2;
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, Class<?> type2, boolean includeNonSingletons, boolean allowEagerInit) {
        HierarchicalBeanFactory hbf;
        BeanFactory beanFactory;
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type2, includeNonSingletons, allowEagerInit);
        if (lbf instanceof HierarchicalBeanFactory && (beanFactory = (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory pbf = (ListableBeanFactory)beanFactory;
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(pbf, type2, includeNonSingletons, allowEagerInit);
            result2 = BeanFactoryUtils.mergeNamesWithParent(result2, parentResult, hbf);
        }
        return result2;
    }

    public static String[] beanNamesForAnnotationIncludingAncestors(ListableBeanFactory lbf, Class<? extends Annotation> annotationType) {
        HierarchicalBeanFactory hbf;
        BeanFactory beanFactory;
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForAnnotation(annotationType);
        if (lbf instanceof HierarchicalBeanFactory && (beanFactory = (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory pbf = (ListableBeanFactory)beanFactory;
            String[] parentResult = BeanFactoryUtils.beanNamesForAnnotationIncludingAncestors(pbf, annotationType);
            result2 = BeanFactoryUtils.mergeNamesWithParent(result2, parentResult, hbf);
        }
        return result2;
    }

    public static <T> Map<String, T> beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class<T> type2) throws BeansException {
        HierarchicalBeanFactory hbf;
        BeanFactory beanFactory;
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        LinkedHashMap result2 = new LinkedHashMap(4);
        result2.putAll(lbf.getBeansOfType(type2));
        if (lbf instanceof HierarchicalBeanFactory && (beanFactory = (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory pbf = (ListableBeanFactory)beanFactory;
            Map<String, T> parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors(pbf, type2);
            parentResult.forEach((beanName, beanInstance) -> {
                if (!result2.containsKey(beanName) && !hbf.containsLocalBean((String)beanName)) {
                    result2.put((String)beanName, (Object)beanInstance);
                }
            });
        }
        return result2;
    }

    public static <T> Map<String, T> beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class<T> type2, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        HierarchicalBeanFactory hbf;
        BeanFactory beanFactory;
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        LinkedHashMap result2 = new LinkedHashMap(4);
        result2.putAll(lbf.getBeansOfType(type2, includeNonSingletons, allowEagerInit));
        if (lbf instanceof HierarchicalBeanFactory && (beanFactory = (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory pbf = (ListableBeanFactory)beanFactory;
            Map<String, T> parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors(pbf, type2, includeNonSingletons, allowEagerInit);
            parentResult.forEach((beanName, beanInstance) -> {
                if (!result2.containsKey(beanName) && !hbf.containsLocalBean((String)beanName)) {
                    result2.put((String)beanName, (Object)beanInstance);
                }
            });
        }
        return result2;
    }

    public static <T> T beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class<T> type2) throws BeansException {
        Map<String, T> beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type2);
        return BeanFactoryUtils.uniqueBean(type2, beansOfType);
    }

    public static <T> T beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class<T> type2, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        Map<String, T> beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type2, includeNonSingletons, allowEagerInit);
        return BeanFactoryUtils.uniqueBean(type2, beansOfType);
    }

    public static <T> T beanOfType(ListableBeanFactory lbf, Class<T> type2) throws BeansException {
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        Map<String, T> beansOfType = lbf.getBeansOfType(type2);
        return BeanFactoryUtils.uniqueBean(type2, beansOfType);
    }

    public static <T> T beanOfType(ListableBeanFactory lbf, Class<T> type2, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        Assert.notNull((Object)lbf, "ListableBeanFactory must not be null");
        Map<String, T> beansOfType = lbf.getBeansOfType(type2, includeNonSingletons, allowEagerInit);
        return BeanFactoryUtils.uniqueBean(type2, beansOfType);
    }

    private static String[] mergeNamesWithParent(String[] result2, String[] parentResult, HierarchicalBeanFactory hbf) {
        if (parentResult.length == 0) {
            return result2;
        }
        ArrayList<String> merged = new ArrayList<String>(result2.length + parentResult.length);
        merged.addAll(Arrays.asList(result2));
        for (String beanName : parentResult) {
            if (merged.contains(beanName) || hbf.containsLocalBean(beanName)) continue;
            merged.add(beanName);
        }
        return StringUtils.toStringArray(merged);
    }

    private static <T> T uniqueBean(Class<T> type2, Map<String, T> matchingBeans) {
        int count2 = matchingBeans.size();
        if (count2 == 1) {
            return matchingBeans.values().iterator().next();
        }
        if (count2 > 1) {
            throw new NoUniqueBeanDefinitionException(type2, matchingBeans.keySet());
        }
        throw new NoSuchBeanDefinitionException(type2);
    }
}

