/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import org.springframework.beans.PropertyAccessException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TypeMismatchException
extends PropertyAccessException {
    public static final String ERROR_CODE = "typeMismatch";
    @Nullable
    private String propertyName;
    @Nullable
    private final transient Object value;
    @Nullable
    private final Class<?> requiredType;

    public TypeMismatchException(PropertyChangeEvent propertyChangeEvent, Class<?> requiredType) {
        this(propertyChangeEvent, requiredType, null);
    }

    public TypeMismatchException(PropertyChangeEvent propertyChangeEvent, @Nullable Class<?> requiredType, @Nullable Throwable cause2) {
        super(propertyChangeEvent, "Failed to convert property value of type '" + ClassUtils.getDescriptiveType(propertyChangeEvent.getNewValue()) + "'" + (String)(requiredType != null ? " to required type '" + ClassUtils.getQualifiedName(requiredType) + "'" : "") + (String)(propertyChangeEvent.getPropertyName() != null ? " for property '" + propertyChangeEvent.getPropertyName() + "'" : "") + (String)(cause2 != null ? "; " + cause2.getMessage() : ""), cause2);
        this.propertyName = propertyChangeEvent.getPropertyName();
        this.value = propertyChangeEvent.getNewValue();
        this.requiredType = requiredType;
    }

    public TypeMismatchException(@Nullable Object value2, @Nullable Class<?> requiredType) {
        this(value2, requiredType, null);
    }

    public TypeMismatchException(@Nullable Object value2, @Nullable Class<?> requiredType, @Nullable Throwable cause2) {
        super("Failed to convert value of type '" + ClassUtils.getDescriptiveType(value2) + "'" + (String)(requiredType != null ? " to required type '" + ClassUtils.getQualifiedName(requiredType) + "'" : "") + (String)(cause2 != null ? "; " + cause2.getMessage() : ""), cause2);
        this.value = value2;
        this.requiredType = requiredType;
    }

    public void initPropertyName(String propertyName) {
        Assert.state(this.propertyName == null, "Property name already initialized");
        this.propertyName = propertyName;
    }

    @Override
    @Nullable
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public Class<?> getRequiredType() {
        return this.requiredType;
    }

    @Override
    public String getErrorCode() {
        return ERROR_CODE;
    }
}

