/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class PropertyDescriptorUtils {
    public static final PropertyDescriptor[] EMPTY_PROPERTY_DESCRIPTOR_ARRAY = new PropertyDescriptor[0];

    PropertyDescriptorUtils() {
    }

    public static Collection<? extends PropertyDescriptor> determineBasicProperties(Class<?> beanClass) throws IntrospectionException {
        TreeMap<String, BasicPropertyDescriptor> pdMap = new TreeMap<String, BasicPropertyDescriptor>();
        for (Method method2 : beanClass.getMethods()) {
            int nameIndex;
            boolean setter;
            String methodName = method2.getName();
            if (methodName.startsWith("set") && method2.getParameterCount() == 1) {
                setter = true;
                nameIndex = 3;
            } else if (methodName.startsWith("get") && method2.getParameterCount() == 0 && method2.getReturnType() != Void.TYPE) {
                setter = false;
                nameIndex = 3;
            } else {
                if (!methodName.startsWith("is") || method2.getParameterCount() != 0 || method2.getReturnType() != Boolean.TYPE) continue;
                setter = false;
                nameIndex = 2;
            }
            String propertyName = StringUtils.uncapitalizeAsProperty(methodName.substring(nameIndex));
            if (propertyName.isEmpty()) continue;
            BasicPropertyDescriptor pd = (BasicPropertyDescriptor)pdMap.get(propertyName);
            if (pd != null) {
                if (setter) {
                    Method writeMethod = pd.getWriteMethod();
                    if (writeMethod == null || writeMethod.getParameterTypes()[0].isAssignableFrom(method2.getParameterTypes()[0])) {
                        pd.setWriteMethod(method2);
                        continue;
                    }
                    pd.addWriteMethod(method2);
                    continue;
                }
                Method readMethod = pd.getReadMethod();
                if (readMethod != null && (readMethod.getReturnType() != method2.getReturnType() || !method2.getName().startsWith("is"))) continue;
                pd.setReadMethod(method2);
                continue;
            }
            pd = new BasicPropertyDescriptor(propertyName, !setter ? method2 : null, setter ? method2 : null);
            pdMap.put(propertyName, pd);
        }
        return pdMap.values();
    }

    public static void copyNonMethodProperties(PropertyDescriptor source2, PropertyDescriptor target2) {
        target2.setExpert(source2.isExpert());
        target2.setHidden(source2.isHidden());
        target2.setPreferred(source2.isPreferred());
        target2.setName(source2.getName());
        target2.setShortDescription(source2.getShortDescription());
        target2.setDisplayName(source2.getDisplayName());
        Enumeration<String> keys2 = source2.attributeNames();
        while (keys2.hasMoreElements()) {
            String key2 = keys2.nextElement();
            target2.setValue(key2, source2.getValue(key2));
        }
        target2.setPropertyEditorClass(source2.getPropertyEditorClass());
        target2.setBound(source2.isBound());
        target2.setConstrained(source2.isConstrained());
    }

    @Nullable
    public static Class<?> findPropertyType(@Nullable Method readMethod, @Nullable Method writeMethod) throws IntrospectionException {
        Class<?> propertyType = null;
        if (readMethod != null) {
            if (readMethod.getParameterCount() != 0) {
                throw new IntrospectionException("Bad read method arg count: " + readMethod);
            }
            propertyType = readMethod.getReturnType();
            if (propertyType == Void.TYPE) {
                throw new IntrospectionException("Read method returns void: " + readMethod);
            }
        }
        if (writeMethod != null) {
            Class<?>[] params2 = writeMethod.getParameterTypes();
            if (params2.length != 1) {
                throw new IntrospectionException("Bad write method arg count: " + writeMethod);
            }
            if (propertyType != null) {
                if (propertyType.isAssignableFrom(params2[0])) {
                    propertyType = params2[0];
                } else if (!params2[0].isAssignableFrom(propertyType)) {
                    throw new IntrospectionException("Type mismatch between read and write methods: " + readMethod + " - " + writeMethod);
                }
            } else {
                propertyType = params2[0];
            }
        }
        return propertyType;
    }

    @Nullable
    public static Class<?> findIndexedPropertyType(String name2, @Nullable Class<?> propertyType, @Nullable Method indexedReadMethod, @Nullable Method indexedWriteMethod) throws IntrospectionException {
        Class<?>[] params2;
        Class<?> indexedPropertyType = null;
        if (indexedReadMethod != null) {
            params2 = indexedReadMethod.getParameterTypes();
            if (params2.length != 1) {
                throw new IntrospectionException("Bad indexed read method arg count: " + indexedReadMethod);
            }
            if (params2[0] != Integer.TYPE) {
                throw new IntrospectionException("Non int index to indexed read method: " + indexedReadMethod);
            }
            indexedPropertyType = indexedReadMethod.getReturnType();
            if (indexedPropertyType == Void.TYPE) {
                throw new IntrospectionException("Indexed read method returns void: " + indexedReadMethod);
            }
        }
        if (indexedWriteMethod != null) {
            params2 = indexedWriteMethod.getParameterTypes();
            if (params2.length != 2) {
                throw new IntrospectionException("Bad indexed write method arg count: " + indexedWriteMethod);
            }
            if (params2[0] != Integer.TYPE) {
                throw new IntrospectionException("Non int index to indexed write method: " + indexedWriteMethod);
            }
            if (indexedPropertyType != null) {
                if (indexedPropertyType.isAssignableFrom(params2[1])) {
                    indexedPropertyType = params2[1];
                } else if (!params2[1].isAssignableFrom(indexedPropertyType)) {
                    throw new IntrospectionException("Type mismatch between indexed read and write methods: " + indexedReadMethod + " - " + indexedWriteMethod);
                }
            } else {
                indexedPropertyType = params2[1];
            }
        }
        if (!(propertyType == null || propertyType.isArray() && propertyType.componentType() == indexedPropertyType)) {
            throw new IntrospectionException("Type mismatch between indexed and non-indexed methods: " + indexedReadMethod + " - " + indexedWriteMethod);
        }
        return indexedPropertyType;
    }

    public static boolean equals(PropertyDescriptor pd, PropertyDescriptor otherPd) {
        return ObjectUtils.nullSafeEquals(pd.getReadMethod(), otherPd.getReadMethod()) && ObjectUtils.nullSafeEquals(pd.getWriteMethod(), otherPd.getWriteMethod()) && ObjectUtils.nullSafeEquals(pd.getPropertyType(), otherPd.getPropertyType()) && ObjectUtils.nullSafeEquals(pd.getPropertyEditorClass(), otherPd.getPropertyEditorClass()) && pd.isBound() == otherPd.isBound() && pd.isConstrained() == otherPd.isConstrained();
    }

    private static class BasicPropertyDescriptor
    extends PropertyDescriptor {
        @Nullable
        private Method readMethod;
        @Nullable
        private Method writeMethod;
        private final List<Method> alternativeWriteMethods = new ArrayList<Method>();

        public BasicPropertyDescriptor(String propertyName, @Nullable Method readMethod, @Nullable Method writeMethod) throws IntrospectionException {
            super(propertyName, readMethod, writeMethod);
        }

        @Override
        public void setReadMethod(@Nullable Method readMethod) {
            this.readMethod = readMethod;
        }

        @Override
        @Nullable
        public Method getReadMethod() {
            return this.readMethod;
        }

        @Override
        public void setWriteMethod(@Nullable Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        public void addWriteMethod(Method writeMethod) {
            if (this.writeMethod != null) {
                this.alternativeWriteMethods.add(this.writeMethod);
                this.writeMethod = null;
            }
            this.alternativeWriteMethods.add(writeMethod);
        }

        @Override
        @Nullable
        public Method getWriteMethod() {
            if (this.writeMethod == null && !this.alternativeWriteMethods.isEmpty()) {
                if (this.readMethod == null) {
                    return this.alternativeWriteMethods.get(0);
                }
                for (Method method2 : this.alternativeWriteMethods) {
                    if (!this.readMethod.getReturnType().isAssignableFrom(method2.getParameterTypes()[0])) continue;
                    this.writeMethod = method2;
                    break;
                }
            }
            return this.writeMethod;
        }
    }
}

