/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import org.springframework.beans.ExtendedBeanInfo;
import org.springframework.beans.StandardBeanInfoFactory;
import org.springframework.lang.NonNull;

public class ExtendedBeanInfoFactory
extends StandardBeanInfoFactory {
    @Override
    @NonNull
    public BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        BeanInfo beanInfo = super.getBeanInfo(beanClass);
        return this.supports(beanClass) ? new ExtendedBeanInfo(beanInfo) : beanInfo;
    }

    private boolean supports(Class<?> beanClass) {
        for (Method method2 : beanClass.getMethods()) {
            if (!ExtendedBeanInfo.isCandidateWriteMethod(method2)) continue;
            return true;
        }
        return false;
    }
}

