/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BeanMetadataAttribute
implements BeanMetadataElement {
    private final String name;
    @Nullable
    private final Object value;
    @Nullable
    private Object source;

    public BeanMetadataAttribute(String name2, @Nullable Object value2) {
        Assert.notNull((Object)name2, "Name must not be null");
        this.name = name2;
        this.value = value2;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public void setSource(@Nullable Object source2) {
        this.source = source2;
    }

    @Override
    @Nullable
    public Object getSource() {
        return this.source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof BeanMetadataAttribute)) return false;
        BeanMetadataAttribute that = (BeanMetadataAttribute)other;
        if (!this.name.equals(that.name)) return false;
        if (!ObjectUtils.nullSafeEquals(this.value, that.value)) return false;
        if (!ObjectUtils.nullSafeEquals(this.source, that.source)) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(this.name, this.value);
    }

    public String toString() {
        return "metadata attribute '" + this.name + "'";
    }
}

