/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractNestablePropertyAccessor
extends AbstractPropertyAccessor {
    private static final Log logger = LogFactory.getLog(AbstractNestablePropertyAccessor.class);
    private int autoGrowCollectionLimit = Integer.MAX_VALUE;
    @Nullable
    Object wrappedObject;
    private String nestedPath = "";
    @Nullable
    Object rootObject;
    @Nullable
    private Map<String, AbstractNestablePropertyAccessor> nestedPropertyAccessors;

    protected AbstractNestablePropertyAccessor() {
        this(true);
    }

    protected AbstractNestablePropertyAccessor(boolean registerDefaultEditors) {
        if (registerDefaultEditors) {
            this.registerDefaultEditors();
        }
        this.typeConverterDelegate = new TypeConverterDelegate(this);
    }

    protected AbstractNestablePropertyAccessor(Object object) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object);
    }

    protected AbstractNestablePropertyAccessor(Class<?> clazz) {
        this.registerDefaultEditors();
        this.setWrappedInstance(BeanUtils.instantiateClass(clazz));
    }

    protected AbstractNestablePropertyAccessor(Object object, String nestedPath, Object rootObject) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object, nestedPath, rootObject);
    }

    protected AbstractNestablePropertyAccessor(Object object, String nestedPath, AbstractNestablePropertyAccessor parent) {
        this.setWrappedInstance(object, nestedPath, parent.getWrappedInstance());
        this.setExtractOldValueForEditor(parent.isExtractOldValueForEditor());
        this.setAutoGrowNestedPaths(parent.isAutoGrowNestedPaths());
        this.setAutoGrowCollectionLimit(parent.getAutoGrowCollectionLimit());
        this.setConversionService(parent.getConversionService());
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    public int getAutoGrowCollectionLimit() {
        return this.autoGrowCollectionLimit;
    }

    public void setWrappedInstance(Object object) {
        this.setWrappedInstance(object, "", null);
    }

    public void setWrappedInstance(Object object, @Nullable String nestedPath, @Nullable Object rootObject) {
        this.wrappedObject = ObjectUtils.unwrapOptional(object);
        Assert.notNull(this.wrappedObject, "Target object must not be null");
        this.nestedPath = nestedPath != null ? nestedPath : "";
        this.rootObject = !this.nestedPath.isEmpty() ? rootObject : this.wrappedObject;
        this.nestedPropertyAccessors = null;
        this.typeConverterDelegate = new TypeConverterDelegate(this, this.wrappedObject);
    }

    public final Object getWrappedInstance() {
        Assert.state(this.wrappedObject != null, "No wrapped object");
        return this.wrappedObject;
    }

    public final Class<?> getWrappedClass() {
        return this.getWrappedInstance().getClass();
    }

    public final String getNestedPath() {
        return this.nestedPath;
    }

    public final Object getRootInstance() {
        Assert.state(this.rootObject != null, "No root object");
        return this.rootObject;
    }

    public final Class<?> getRootClass() {
        return this.getRootInstance().getClass();
    }

    @Override
    public void setPropertyValue(String propertyName, @Nullable Object value2) throws BeansException {
        AbstractNestablePropertyAccessor nestedPa;
        try {
            nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
        }
        catch (NotReadablePropertyException ex) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", ex);
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedPa, propertyName));
        nestedPa.setPropertyValue(tokens, new PropertyValue(propertyName, value2));
    }

    @Override
    public void setPropertyValue(PropertyValue pv) throws BeansException {
        PropertyTokenHolder tokens = (PropertyTokenHolder)pv.resolvedTokens;
        if (tokens == null) {
            AbstractNestablePropertyAccessor nestedPa;
            String propertyName = pv.getName();
            try {
                nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
            }
            catch (NotReadablePropertyException ex) {
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", ex);
            }
            tokens = this.getPropertyNameTokens(this.getFinalPath(nestedPa, propertyName));
            if (nestedPa == this) {
                pv.getOriginalPropertyValue().resolvedTokens = tokens;
            }
            nestedPa.setPropertyValue(tokens, pv);
        } else {
            this.setPropertyValue(tokens, pv);
        }
    }

    protected void setPropertyValue(PropertyTokenHolder tokens, PropertyValue pv) throws BeansException {
        if (tokens.keys != null) {
            this.processKeyedProperty(tokens, pv);
        } else {
            this.processLocalProperty(tokens, pv);
        }
    }

    private void processKeyedProperty(PropertyTokenHolder tokens, PropertyValue pv) {
        Object propValue = this.getPropertyHoldingValue(tokens);
        PropertyHandler ph = this.getLocalPropertyHandler(tokens.actualName);
        if (ph == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + tokens.actualName, "No property handler found");
        }
        Assert.state(tokens.keys != null, "No token keys");
        String lastKey = tokens.keys[tokens.keys.length - 1];
        if (propValue.getClass().isArray()) {
            TypeDescriptor.OfField requiredType = propValue.getClass().componentType();
            int arrayIndex = Integer.parseInt(lastKey);
            Object oldValue = null;
            try {
                if (this.isExtractOldValueForEditor() && arrayIndex < Array.getLength(propValue)) {
                    oldValue = Array.get(propValue, arrayIndex);
                }
                Object convertedValue = this.convertIfNecessary(tokens.canonicalName, oldValue, pv.getValue(), (Class<?>)requiredType, ph.nested(tokens.keys.length));
                int length2 = Array.getLength(propValue);
                if (arrayIndex >= length2 && arrayIndex < this.autoGrowCollectionLimit) {
                    TypeDescriptor.OfField componentType = propValue.getClass().componentType();
                    Object newArray = Array.newInstance(componentType, arrayIndex + 1);
                    System.arraycopy(propValue, 0, newArray, 0, length2);
                    int lastKeyIndex = tokens.canonicalName.lastIndexOf(91);
                    String propName = tokens.canonicalName.substring(0, lastKeyIndex);
                    this.setPropertyValue(propName, newArray);
                    propValue = this.getPropertyValue(propName);
                }
                Array.set(propValue, arrayIndex, convertedValue);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Invalid array index in property path '" + tokens.canonicalName + "'", ex);
            }
        } else if (propValue instanceof List) {
            List list2 = (List)propValue;
            TypeDescriptor requiredType = ph.getCollectionType(tokens.keys.length);
            int index2 = Integer.parseInt(lastKey);
            Object oldValue = null;
            if (this.isExtractOldValueForEditor() && index2 < list2.size()) {
                oldValue = list2.get(index2);
            }
            Object convertedValue = this.convertIfNecessary(tokens.canonicalName, oldValue, pv.getValue(), requiredType.getResolvableType().resolve(), requiredType);
            int size2 = list2.size();
            if (index2 >= size2 && index2 < this.autoGrowCollectionLimit) {
                for (int i2 = size2; i2 < index2; ++i2) {
                    try {
                        list2.add(null);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Cannot set element with index " + index2 + " in List of size " + size2 + ", accessed using property path '" + tokens.canonicalName + "': List does not support filling up gaps with null elements");
                    }
                }
                list2.add(convertedValue);
            } else {
                try {
                    list2.set(index2, convertedValue);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Invalid list index in property path '" + tokens.canonicalName + "'", ex);
                }
            }
        } else if (propValue instanceof Map) {
            Map map2 = (Map)propValue;
            TypeDescriptor mapKeyType = ph.getMapKeyType(tokens.keys.length);
            TypeDescriptor mapValueType = ph.getMapValueType(tokens.keys.length);
            Object convertedMapKey = this.convertIfNecessary(null, null, lastKey, mapKeyType.getResolvableType().resolve(), mapKeyType);
            Object oldValue = null;
            if (this.isExtractOldValueForEditor()) {
                oldValue = map2.get(convertedMapKey);
            }
            Object convertedMapValue = this.convertIfNecessary(tokens.canonicalName, oldValue, pv.getValue(), mapValueType.getResolvableType().resolve(), mapValueType);
            map2.put(convertedMapKey, convertedMapValue);
        } else {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Property referenced in indexed property path '" + tokens.canonicalName + "' is neither an array nor a List nor a Map; returned value was [" + propValue + "]");
        }
    }

    private Object getPropertyHoldingValue(PropertyTokenHolder tokens) {
        Object propValue;
        Assert.state(tokens.keys != null, "No token keys");
        PropertyTokenHolder getterTokens = new PropertyTokenHolder(tokens.actualName);
        getterTokens.canonicalName = tokens.canonicalName;
        getterTokens.keys = new String[tokens.keys.length - 1];
        System.arraycopy(tokens.keys, 0, getterTokens.keys, 0, tokens.keys.length - 1);
        try {
            propValue = this.getPropertyValue(getterTokens);
        }
        catch (NotReadablePropertyException ex) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Cannot access indexed value in property referenced in indexed property path '" + tokens.canonicalName + "'", ex);
        }
        if (propValue == null) {
            if (this.isAutoGrowNestedPaths()) {
                int lastKeyIndex = tokens.canonicalName.lastIndexOf(91);
                getterTokens.canonicalName = tokens.canonicalName.substring(0, lastKeyIndex);
                propValue = this.setDefaultValue(getterTokens);
            } else {
                throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Cannot access indexed value in property referenced in indexed property path '" + tokens.canonicalName + "': returned null");
            }
        }
        return propValue;
    }

    private void processLocalProperty(PropertyTokenHolder tokens, PropertyValue pv) {
        PropertyHandler ph = this.getLocalPropertyHandler(tokens.actualName);
        if (ph == null || !ph.isWritable()) {
            if (pv.isOptional()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Ignoring optional value for property '" + tokens.actualName + "' - property not found on bean class [" + this.getRootClass().getName() + "]");
                }
                return;
            }
            if (this.suppressNotWritablePropertyException) {
                return;
            }
            throw this.createNotWritablePropertyException(tokens.canonicalName);
        }
        Object oldValue = null;
        try {
            Object originalValue;
            Object valueToApply = originalValue = pv.getValue();
            if (!Boolean.FALSE.equals(pv.conversionNecessary)) {
                if (pv.isConverted()) {
                    valueToApply = pv.getConvertedValue();
                } else {
                    block18: {
                        if (this.isExtractOldValueForEditor() && ph.isReadable()) {
                            try {
                                oldValue = ph.getValue();
                            }
                            catch (Exception ex) {
                                if (ex instanceof PrivilegedActionException) {
                                    PrivilegedActionException pae = (PrivilegedActionException)ex;
                                    ex = pae.getException();
                                }
                                if (!logger.isDebugEnabled()) break block18;
                                logger.debug("Could not read previous value of property '" + this.nestedPath + tokens.canonicalName + "'", ex);
                            }
                        }
                    }
                    valueToApply = this.convertForProperty(tokens.canonicalName, oldValue, originalValue, ph.toTypeDescriptor());
                }
                pv.getOriginalPropertyValue().conversionNecessary = valueToApply != originalValue;
            }
            ph.setValue(valueToApply);
        }
        catch (TypeMismatchException ex) {
            if (!ph.setValueFallbackIfPossible(pv.getValue())) {
                throw ex;
            }
        }
        catch (InvocationTargetException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getRootInstance(), this.nestedPath + tokens.canonicalName, oldValue, pv.getValue());
            if (ex.getTargetException() instanceof ClassCastException) {
                throw new TypeMismatchException(propertyChangeEvent, ph.getPropertyType(), ex.getTargetException());
            }
            Throwable cause2 = ex.getTargetException();
            if (cause2 instanceof UndeclaredThrowableException) {
                cause2 = cause2.getCause();
            }
            throw new MethodInvocationException(propertyChangeEvent, cause2);
        }
        catch (Exception ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.getRootInstance(), this.nestedPath + tokens.canonicalName, oldValue, pv.getValue());
            throw new MethodInvocationException(pce, (Throwable)ex);
        }
    }

    @Override
    @Nullable
    public Class<?> getPropertyType(String propertyName) throws BeansException {
        try {
            PropertyHandler ph = this.getPropertyHandler(propertyName);
            if (ph != null) {
                return ph.getPropertyType();
            }
            Object value2 = this.getPropertyValue(propertyName);
            if (value2 != null) {
                return value2.getClass();
            }
            Class<?> editorType = this.guessPropertyTypeFromEditors(propertyName);
            if (editorType != null) {
                return editorType;
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @Nullable
    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        try {
            AbstractNestablePropertyAccessor nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
            String finalPath = this.getFinalPath(nestedPa, propertyName);
            PropertyTokenHolder tokens = this.getPropertyNameTokens(finalPath);
            PropertyHandler ph = nestedPa.getLocalPropertyHandler(tokens.actualName);
            if (ph != null) {
                if (tokens.keys != null) {
                    if (ph.isReadable() || ph.isWritable()) {
                        return ph.nested(tokens.keys.length);
                    }
                } else if (ph.isReadable() || ph.isWritable()) {
                    return ph.toTypeDescriptor();
                }
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isReadableProperty(String propertyName) {
        try {
            PropertyHandler ph = this.getPropertyHandler(propertyName);
            if (ph != null) {
                return ph.isReadable();
            }
            this.getPropertyValue(propertyName);
            return true;
        }
        catch (InvalidPropertyException invalidPropertyException) {
            return false;
        }
    }

    @Override
    public boolean isWritableProperty(String propertyName) {
        try {
            PropertyHandler ph = this.getPropertyHandler(propertyName);
            if (ph != null) {
                return ph.isWritable();
            }
            this.getPropertyValue(propertyName);
            return true;
        }
        catch (InvalidPropertyException invalidPropertyException) {
            return false;
        }
    }

    @Nullable
    private Object convertIfNecessary(@Nullable String propertyName, @Nullable Object oldValue, @Nullable Object newValue, @Nullable Class<?> requiredType, @Nullable TypeDescriptor td) throws TypeMismatchException {
        Assert.state(this.typeConverterDelegate != null, "No TypeConverterDelegate");
        try {
            return this.typeConverterDelegate.convertIfNecessary(propertyName, oldValue, newValue, requiredType, td);
        }
        catch (IllegalStateException | ConverterNotFoundException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.getRootInstance(), this.nestedPath + propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, requiredType, (Throwable)ex);
        }
        catch (IllegalArgumentException | ConversionException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.getRootInstance(), this.nestedPath + propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
        }
    }

    @Nullable
    protected Object convertForProperty(String propertyName, @Nullable Object oldValue, @Nullable Object newValue, TypeDescriptor td) throws TypeMismatchException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, td.getType(), td);
    }

    @Override
    @Nullable
    public Object getPropertyValue(String propertyName) throws BeansException {
        AbstractNestablePropertyAccessor nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedPa, propertyName));
        return nestedPa.getPropertyValue(tokens);
    }

    @Nullable
    protected Object getPropertyValue(PropertyTokenHolder tokens) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        PropertyHandler ph = this.getLocalPropertyHandler(actualName);
        if (ph == null || !ph.isReadable()) {
            throw new NotReadablePropertyException(this.getRootClass(), this.nestedPath + propertyName);
        }
        try {
            Object value2 = ph.getValue();
            if (tokens.keys != null) {
                if (value2 == null) {
                    if (this.isAutoGrowNestedPaths()) {
                        value2 = this.setDefaultValue(new PropertyTokenHolder(tokens.actualName));
                    } else {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                }
                StringBuilder indexedPropertyName = new StringBuilder(tokens.actualName);
                for (int i2 = 0; i2 < tokens.keys.length; ++i2) {
                    String key2 = tokens.keys[i2];
                    if (value2 == null) {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                    if (value2.getClass().isArray()) {
                        int index2 = Integer.parseInt(key2);
                        value2 = this.growArrayIfNecessary(value2, index2, indexedPropertyName.toString());
                        value2 = Array.get(value2, index2);
                    } else if (value2 instanceof List) {
                        List list2 = (List)value2;
                        int index3 = Integer.parseInt(key2);
                        this.growCollectionIfNecessary(list2, index3, indexedPropertyName.toString(), ph, i2 + 1);
                        value2 = list2.get(index3);
                    } else if (value2 instanceof Iterable) {
                        Iterable iterable = (Iterable)value2;
                        int index4 = Integer.parseInt(key2);
                        if (value2 instanceof Collection) {
                            Collection coll = (Collection)value2;
                            if (index4 < 0 || index4 >= coll.size()) {
                                throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot get element with index " + index4 + " from Collection of size " + coll.size() + ", accessed using property path '" + propertyName + "'");
                            }
                        }
                        Iterator it = iterable.iterator();
                        boolean found = false;
                        int currIndex = 0;
                        while (it.hasNext()) {
                            Object elem = it.next();
                            if (currIndex == index4) {
                                value2 = elem;
                                found = true;
                                break;
                            }
                            ++currIndex;
                        }
                        if (!found) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot get element with index " + index4 + " from Iterable of size " + currIndex + ", accessed using property path '" + propertyName + "'");
                        }
                    } else if (value2 instanceof Map) {
                        Map map2 = (Map)value2;
                        Class<?> mapKeyType = ph.getResolvableType().getNested(i2 + 1).asMap().resolveGeneric(0);
                        TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(mapKeyType);
                        Object convertedMapKey = this.convertIfNecessary(null, null, key2, mapKeyType, typeDescriptor);
                        value2 = map2.get(convertedMapKey);
                    } else {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List/Set/Collection/Iterable nor a Map; returned value was [" + value2 + "]");
                    }
                    indexedPropertyName.append("[").append(key2).append("]");
                }
            }
            return value2;
        }
        catch (InvalidPropertyException ex) {
            throw ex;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Index of out of bounds in property path '" + propertyName + "'", ex);
        }
        catch (NumberFormatException | TypeMismatchException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid index in property path '" + propertyName + "'", ex);
        }
        catch (InvocationTargetException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Getter for property '" + actualName + "' threw exception", ex);
        }
        catch (Exception ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Illegal attempt to get property '" + actualName + "' threw exception", ex);
        }
    }

    @Nullable
    protected PropertyHandler getPropertyHandler(String propertyName) throws BeansException {
        Assert.notNull((Object)propertyName, "Property name must not be null");
        AbstractNestablePropertyAccessor nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
        return nestedPa.getLocalPropertyHandler(this.getFinalPath(nestedPa, propertyName));
    }

    @Nullable
    protected abstract PropertyHandler getLocalPropertyHandler(String var1);

    protected abstract AbstractNestablePropertyAccessor newNestedPropertyAccessor(Object var1, String var2);

    protected abstract NotWritablePropertyException createNotWritablePropertyException(String var1);

    private Object growArrayIfNecessary(Object array2, int index2, String name2) {
        if (!this.isAutoGrowNestedPaths()) {
            return array2;
        }
        int length2 = Array.getLength(array2);
        if (index2 >= length2 && index2 < this.autoGrowCollectionLimit) {
            TypeDescriptor.OfField componentType = array2.getClass().componentType();
            Object newArray = Array.newInstance(componentType, index2 + 1);
            System.arraycopy(array2, 0, newArray, 0, length2);
            for (int i2 = length2; i2 < Array.getLength(newArray); ++i2) {
                Array.set(newArray, i2, this.newValue((Class<?>)componentType, null, name2));
            }
            this.setPropertyValue(name2, newArray);
            Object defaultValue = this.getPropertyValue(name2);
            Assert.state(defaultValue != null, "Default value must not be null");
            return defaultValue;
        }
        return array2;
    }

    private void growCollectionIfNecessary(Collection<Object> collection, int index2, String name2, PropertyHandler ph, int nestingLevel) {
        Class<?> elementType;
        if (!this.isAutoGrowNestedPaths()) {
            return;
        }
        int size2 = collection.size();
        if (index2 >= size2 && index2 < this.autoGrowCollectionLimit && (elementType = ph.getResolvableType().getNested(nestingLevel).asCollection().resolveGeneric(new int[0])) != null) {
            for (int i2 = collection.size(); i2 < index2 + 1; ++i2) {
                collection.add(this.newValue(elementType, null, name2));
            }
        }
    }

    protected String getFinalPath(AbstractNestablePropertyAccessor pa, String nestedPath) {
        if (pa == this) {
            return nestedPath;
        }
        return nestedPath.substring(PropertyAccessorUtils.getLastNestedPropertySeparatorIndex(nestedPath) + 1);
    }

    protected AbstractNestablePropertyAccessor getPropertyAccessorForPropertyPath(String propertyPath) {
        int pos2 = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(propertyPath);
        if (pos2 > -1) {
            String nestedProperty = propertyPath.substring(0, pos2);
            String nestedPath = propertyPath.substring(pos2 + 1);
            AbstractNestablePropertyAccessor nestedPa = this.getNestedPropertyAccessor(nestedProperty);
            return nestedPa.getPropertyAccessorForPropertyPath(nestedPath);
        }
        return this;
    }

    private AbstractNestablePropertyAccessor getNestedPropertyAccessor(String nestedProperty) {
        AbstractNestablePropertyAccessor nestedPa;
        Optional optional;
        Map<String, AbstractNestablePropertyAccessor> nestedAccessors = this.nestedPropertyAccessors;
        if (nestedAccessors == null) {
            this.nestedPropertyAccessors = nestedAccessors = new HashMap<String, AbstractNestablePropertyAccessor>();
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedProperty);
        String canonicalName = tokens.canonicalName;
        Object value2 = this.getPropertyValue(tokens);
        if (value2 == null || value2 instanceof Optional && (optional = (Optional)value2).isEmpty()) {
            if (this.isAutoGrowNestedPaths()) {
                value2 = this.setDefaultValue(tokens);
            } else {
                throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + canonicalName);
            }
        }
        if ((nestedPa = nestedAccessors.get(canonicalName)) == null || nestedPa.getWrappedInstance() != ObjectUtils.unwrapOptional(value2)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Creating new nested " + this.getClass().getSimpleName() + " for property '" + canonicalName + "'");
            }
            nestedPa = this.newNestedPropertyAccessor(value2, this.nestedPath + canonicalName + ".");
            this.copyDefaultEditorsTo(nestedPa);
            this.copyCustomEditorsTo(nestedPa, canonicalName);
            nestedAccessors.put(canonicalName, nestedPa);
        } else if (logger.isTraceEnabled()) {
            logger.trace("Using cached nested property accessor for property '" + canonicalName + "'");
        }
        return nestedPa;
    }

    private Object setDefaultValue(PropertyTokenHolder tokens) {
        PropertyValue pv = this.createDefaultPropertyValue(tokens);
        this.setPropertyValue(tokens, pv);
        Object defaultValue = this.getPropertyValue(tokens);
        Assert.state(defaultValue != null, "Default value must not be null");
        return defaultValue;
    }

    private PropertyValue createDefaultPropertyValue(PropertyTokenHolder tokens) {
        TypeDescriptor desc = this.getPropertyTypeDescriptor(tokens.canonicalName);
        if (desc == null) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Could not determine property type for auto-growing a default value");
        }
        Object defaultValue = this.newValue(desc.getType(), desc, tokens.canonicalName);
        return new PropertyValue(tokens.canonicalName, defaultValue);
    }

    private Object newValue(Class<?> type2, @Nullable TypeDescriptor desc, String name2) {
        try {
            if (type2.isArray()) {
                TypeDescriptor.OfField componentType = type2.componentType();
                if (((Class)componentType).isArray()) {
                    Object array2 = Array.newInstance(componentType, 1);
                    Array.set(array2, 0, Array.newInstance(((Class)componentType).componentType(), 0));
                    return array2;
                }
                return Array.newInstance(componentType, 0);
            }
            if (Collection.class.isAssignableFrom(type2)) {
                TypeDescriptor elementDesc = desc != null ? desc.getElementTypeDescriptor() : null;
                return CollectionFactory.createCollection(type2, elementDesc != null ? elementDesc.getType() : null, 16);
            }
            if (Map.class.isAssignableFrom(type2)) {
                TypeDescriptor keyDesc = desc != null ? desc.getMapKeyTypeDescriptor() : null;
                return CollectionFactory.createMap(type2, keyDesc != null ? keyDesc.getType() : null, 16);
            }
            Constructor<?> ctor = type2.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(ctor.getModifiers())) {
                throw new IllegalAccessException("Auto-growing not allowed with private constructor: " + ctor);
            }
            return BeanUtils.instantiateClass(ctor, new Object[0]);
        }
        catch (Throwable ex) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + name2, "Could not instantiate property type [" + type2.getName() + "] to auto-grow nested property path", ex);
        }
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        String actualName = null;
        ArrayList<String> keys2 = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key2;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = this.getPropertyNameKeyEnd(propertyName, keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key2 = propertyName.substring(keyStart + "[".length(), keyEnd)).length() > 1 && key2.startsWith("'") && key2.endsWith("'") || key2.startsWith("\"") && key2.endsWith("\"")) {
                key2 = key2.substring(1, key2.length() - 1);
            }
            keys2.add(key2);
            searchIndex = keyEnd + "]".length();
        }
        PropertyTokenHolder tokens = new PropertyTokenHolder(actualName != null ? actualName : propertyName);
        if (!keys2.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[" + StringUtils.collectionToDelimitedString(keys2, "][") + "]";
            tokens.keys = StringUtils.toStringArray(keys2);
        }
        return tokens;
    }

    private int getPropertyNameKeyEnd(String propertyName, int startIndex) {
        int unclosedPrefixes = 0;
        int length2 = propertyName.length();
        block4: for (int i2 = startIndex; i2 < length2; ++i2) {
            switch (propertyName.charAt(i2)) {
                case '[': {
                    ++unclosedPrefixes;
                    continue block4;
                }
                case ']': {
                    if (unclosedPrefixes == 0) {
                        return i2;
                    }
                    --unclosedPrefixes;
                }
            }
        }
        return -1;
    }

    public String toString() {
        String className = this.getClass().getName();
        if (this.wrappedObject == null) {
            return className + ": no wrapped object set";
        }
        return className + ": wrapping object [" + ObjectUtils.identityToString(this.wrappedObject) + "]";
    }

    protected static class PropertyTokenHolder {
        public String actualName;
        public String canonicalName;
        @Nullable
        public String[] keys;

        public PropertyTokenHolder(String name2) {
            this.actualName = name2;
            this.canonicalName = name2;
        }
    }

    protected static abstract class PropertyHandler {
        @Nullable
        private final Class<?> propertyType;
        private final boolean readable;
        private final boolean writable;

        public PropertyHandler(@Nullable Class<?> propertyType, boolean readable, boolean writable) {
            this.propertyType = propertyType;
            this.readable = readable;
            this.writable = writable;
        }

        @Nullable
        public Class<?> getPropertyType() {
            return this.propertyType;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public abstract TypeDescriptor toTypeDescriptor();

        public abstract ResolvableType getResolvableType();

        public TypeDescriptor getMapKeyType(int nestingLevel) {
            return TypeDescriptor.valueOf(this.getResolvableType().getNested(nestingLevel).asMap().resolveGeneric(0));
        }

        public TypeDescriptor getMapValueType(int nestingLevel) {
            return TypeDescriptor.valueOf(this.getResolvableType().getNested(nestingLevel).asMap().resolveGeneric(1));
        }

        public TypeDescriptor getCollectionType(int nestingLevel) {
            return TypeDescriptor.valueOf(this.getResolvableType().getNested(nestingLevel).asCollection().resolveGeneric(new int[0]));
        }

        @Nullable
        public abstract TypeDescriptor nested(int var1);

        @Nullable
        public abstract Object getValue() throws Exception;

        public abstract void setValue(@Nullable Object var1) throws Exception;

        public boolean setValueFallbackIfPossible(@Nullable Object value2) {
            return false;
        }
    }
}

