/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.ResourceBundleHint;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.ResourcePatternHint;
import org.springframework.aot.hint.ResourcePatternHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.aot.nativex.BasicJsonWriter;
import org.springframework.lang.Nullable;

class ResourceHintsWriter {
    public static final ResourceHintsWriter INSTANCE = new ResourceHintsWriter();
    private static final Comparator<ResourcePatternHint> RESOURCE_PATTERN_HINT_COMPARATOR = Comparator.comparing(ResourcePatternHint::getPattern);
    private static final Comparator<ResourceBundleHint> RESOURCE_BUNDLE_HINT_COMPARATOR = Comparator.comparing(ResourceBundleHint::getBaseName);

    ResourceHintsWriter() {
    }

    public void write(BasicJsonWriter writer, ResourceHints hints) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.addIfNotEmpty(attributes, "resources", this.toAttributes(hints));
        this.handleResourceBundles(attributes, hints.resourceBundleHints());
        writer.writeObject(attributes);
    }

    private Map<String, Object> toAttributes(ResourceHints hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.addIfNotEmpty(attributes, "includes", hint.resourcePatternHints().map(ResourcePatternHints::getIncludes).flatMap(Collection::stream).distinct().sorted(RESOURCE_PATTERN_HINT_COMPARATOR).map(this::toAttributes).toList());
        this.addIfNotEmpty(attributes, "excludes", hint.resourcePatternHints().map(ResourcePatternHints::getExcludes).flatMap(Collection::stream).distinct().sorted(RESOURCE_PATTERN_HINT_COMPARATOR).map(this::toAttributes).toList());
        return attributes;
    }

    private void handleResourceBundles(Map<String, Object> attributes, Stream<ResourceBundleHint> resourceBundles) {
        this.addIfNotEmpty(attributes, "bundles", resourceBundles.sorted(RESOURCE_BUNDLE_HINT_COMPARATOR).map(this::toAttributes).toList());
    }

    private Map<String, Object> toAttributes(ResourceBundleHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, hint);
        attributes.put("name", hint.getBaseName());
        return attributes;
    }

    private Map<String, Object> toAttributes(ResourcePatternHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, hint);
        attributes.put("pattern", hint.toRegex().toString());
        return attributes;
    }

    private void addIfNotEmpty(Map<String, Object> attributes, String name2, @Nullable Object value2) {
        if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            if (!collection.isEmpty()) {
                attributes.put(name2, value2);
            }
        } else if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            if (!map2.isEmpty()) {
                attributes.put(name2, value2);
            }
        } else if (value2 != null) {
            attributes.put(name2, value2);
        }
    }

    private void handleCondition(Map<String, Object> attributes, ConditionalHint hint) {
        if (hint.getReachableType() != null) {
            LinkedHashMap<String, TypeReference> conditionAttributes = new LinkedHashMap<String, TypeReference>();
            conditionAttributes.put("typeReachable", hint.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }
}

