/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.aot.hint.JdkProxyHint;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.aot.nativex.BasicJsonWriter;

class ProxyHintsWriter {
    public static final ProxyHintsWriter INSTANCE = new ProxyHintsWriter();
    private static final Comparator<JdkProxyHint> JDK_PROXY_HINT_COMPARATOR = (left2, right) -> {
        String leftSignature = left2.getProxiedInterfaces().stream().map(TypeReference::getCanonicalName).collect(Collectors.joining(","));
        String rightSignature = right.getProxiedInterfaces().stream().map(TypeReference::getCanonicalName).collect(Collectors.joining(","));
        return leftSignature.compareTo(rightSignature);
    };

    ProxyHintsWriter() {
    }

    public void write(BasicJsonWriter writer, ProxyHints hints) {
        writer.writeArray(hints.jdkProxyHints().sorted(JDK_PROXY_HINT_COMPARATOR).map(this::toAttributes).toList());
    }

    private Map<String, Object> toAttributes(JdkProxyHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, hint);
        attributes.put("interfaces", hint.getProxiedInterfaces());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, JdkProxyHint hint) {
        if (hint.getReachableType() != null) {
            LinkedHashMap<String, TypeReference> conditionAttributes = new LinkedHashMap<String, TypeReference>();
            conditionAttributes.put("typeReachable", hint.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }
}

