/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.predicate;

import java.util.function.Predicate;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.util.Assert;

public class SerializationHintsPredicates {
    SerializationHintsPredicates() {
    }

    public Predicate<RuntimeHints> onType(Class<?> type2) {
        Assert.notNull(type2, "'type' must not be null");
        return this.onType(TypeReference.of(type2));
    }

    public Predicate<RuntimeHints> onType(TypeReference typeReference) {
        Assert.notNull((Object)typeReference, "'typeReference' must not be null");
        return hints -> hints.serialization().javaSerializationHints().anyMatch(hint -> hint.getType().equals(typeReference));
    }
}

