/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.predicate;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.aot.hint.ExecutableHint;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.MethodIntrospector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectionHintsPredicates {
    ReflectionHintsPredicates() {
    }

    public TypeHintPredicate onType(TypeReference typeReference) {
        Assert.notNull((Object)typeReference, "'typeReference' must not be null");
        return new TypeHintPredicate(typeReference);
    }

    public TypeHintPredicate onType(Class<?> type2) {
        Assert.notNull(type2, "'type' must not be null");
        return new TypeHintPredicate(TypeReference.of(type2));
    }

    public ConstructorHintPredicate onConstructor(Constructor<?> constructor2) {
        Assert.notNull(constructor2, "'constructor' must not be null");
        return new ConstructorHintPredicate(constructor2);
    }

    public MethodHintPredicate onMethod(Method method2) {
        Assert.notNull((Object)method2, "'method' must not be null");
        return new MethodHintPredicate(method2);
    }

    public MethodHintPredicate onMethod(Class<?> type2, String methodName) {
        Assert.notNull(type2, "'type' must not be null");
        Assert.hasText(methodName, "'methodName' must not be empty");
        return new MethodHintPredicate(this.getMethod(type2, methodName));
    }

    public MethodHintPredicate onMethod(String className, String methodName) throws ClassNotFoundException {
        Assert.hasText(className, "'className' must not be empty");
        Assert.hasText(methodName, "'methodName' must not be empty");
        return this.onMethod(Class.forName(className), methodName);
    }

    private Method getMethod(Class<?> type2, String methodName) {
        ReflectionUtils.MethodFilter selector = method2 -> methodName.equals(method2.getName());
        Set<Method> methods2 = MethodIntrospector.selectMethods(type2, selector);
        if (methods2.size() == 1) {
            return methods2.iterator().next();
        }
        if (methods2.size() > 1) {
            throw new IllegalArgumentException("Found multiple methods named '%s' on class %s".formatted(methodName, type2.getName()));
        }
        throw new IllegalArgumentException("No method named '%s' on class %s".formatted(methodName, type2.getName()));
    }

    public FieldHintPredicate onField(Class<?> type2, String fieldName) {
        Assert.notNull(type2, "'type' must not be null");
        Assert.hasText(fieldName, "'fieldName' must not be empty");
        Field field = ReflectionUtils.findField(type2, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("No field named '%s' on class %s".formatted(fieldName, type2.getName()));
        }
        return new FieldHintPredicate(field);
    }

    public FieldHintPredicate onField(String className, String fieldName) throws ClassNotFoundException {
        Assert.hasText(className, "'className' must not be empty");
        Assert.hasText(fieldName, "'fieldName' must not be empty");
        return this.onField(Class.forName(className), fieldName);
    }

    public FieldHintPredicate onField(Field field) {
        Assert.notNull((Object)field, "'field' must not be null");
        return new FieldHintPredicate(field);
    }

    public static class TypeHintPredicate
    implements Predicate<RuntimeHints> {
        private final TypeReference type;

        TypeHintPredicate(TypeReference type2) {
            this.type = type2;
        }

        @Nullable
        private TypeHint getTypeHint(RuntimeHints hints) {
            return hints.reflection().getTypeHint(this.type);
        }

        @Override
        public boolean test(RuntimeHints hints) {
            return this.getTypeHint(hints) != null;
        }

        public Predicate<RuntimeHints> withMemberCategory(MemberCategory memberCategory) {
            Assert.notNull((Object)memberCategory, "'memberCategory' must not be null");
            return this.and(hints -> {
                TypeHint hint = this.getTypeHint((RuntimeHints)hints);
                return hint != null && hint.getMemberCategories().contains((Object)memberCategory);
            });
        }

        public Predicate<RuntimeHints> withMemberCategories(MemberCategory ... memberCategories) {
            Assert.notEmpty((Object[])memberCategories, "'memberCategories' must not be empty");
            return this.and(hints -> {
                TypeHint hint = this.getTypeHint((RuntimeHints)hints);
                return hint != null && hint.getMemberCategories().containsAll(Arrays.asList(memberCategories));
            });
        }

        public Predicate<RuntimeHints> withAnyMemberCategory(MemberCategory ... memberCategories) {
            Assert.notEmpty((Object[])memberCategories, "'memberCategories' must not be empty");
            return this.and(hints -> {
                TypeHint hint = this.getTypeHint((RuntimeHints)hints);
                return hint != null && Arrays.stream(memberCategories).anyMatch(memberCategory -> hint.getMemberCategories().contains(memberCategory));
            });
        }
    }

    public static class ConstructorHintPredicate
    extends ExecutableHintPredicate<Constructor<?>> {
        ConstructorHintPredicate(Constructor<?> constructor2) {
            super(constructor2);
        }

        @Override
        public boolean test(RuntimeHints runtimeHints) {
            return new TypeHintPredicate(TypeReference.of(((Constructor)this.executable).getDeclaringClass())).withAnyMemberCategory(this.getPublicMemberCategories()).and(hints -> Modifier.isPublic(((Constructor)this.executable).getModifiers())).or(new TypeHintPredicate(TypeReference.of(((Constructor)this.executable).getDeclaringClass())).withAnyMemberCategory(this.getDeclaredMemberCategories())).or(this.exactMatch()).test(runtimeHints);
        }

        MemberCategory[] getPublicMemberCategories() {
            if (this.executableMode == ExecutableMode.INTROSPECT) {
                return new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS};
            }
            return new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS};
        }

        MemberCategory[] getDeclaredMemberCategories() {
            if (this.executableMode == ExecutableMode.INTROSPECT) {
                return new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS};
            }
            return new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS};
        }

        @Override
        Predicate<RuntimeHints> exactMatch() {
            return hints -> {
                TypeHint hint = hints.reflection().getTypeHint(((Constructor)this.executable).getDeclaringClass());
                return hint != null && hint.constructors().anyMatch(executableHint -> {
                    List<TypeReference> parameters2 = TypeReference.listOf(((Constructor)this.executable).getParameterTypes());
                    return ConstructorHintPredicate.includes(executableHint, "<init>", parameters2, this.executableMode);
                });
            };
        }
    }

    public static class MethodHintPredicate
    extends ExecutableHintPredicate<Method> {
        MethodHintPredicate(Method method2) {
            super(method2);
        }

        @Override
        public boolean test(RuntimeHints runtimeHints) {
            return new TypeHintPredicate(TypeReference.of(((Method)this.executable).getDeclaringClass())).withAnyMemberCategory(this.getPublicMemberCategories()).and(hints -> Modifier.isPublic(((Method)this.executable).getModifiers())).or(new TypeHintPredicate(TypeReference.of(((Method)this.executable).getDeclaringClass())).withAnyMemberCategory(this.getDeclaredMemberCategories()).and(hints -> !Modifier.isPublic(((Method)this.executable).getModifiers()))).or(this.exactMatch()).test(runtimeHints);
        }

        MemberCategory[] getPublicMemberCategories() {
            if (this.executableMode == ExecutableMode.INTROSPECT) {
                return new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS};
            }
            return new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS};
        }

        MemberCategory[] getDeclaredMemberCategories() {
            if (this.executableMode == ExecutableMode.INTROSPECT) {
                return new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_METHODS};
            }
            return new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS};
        }

        @Override
        Predicate<RuntimeHints> exactMatch() {
            return hints -> {
                TypeHint hint = hints.reflection().getTypeHint(((Method)this.executable).getDeclaringClass());
                return hint != null && hint.methods().anyMatch(executableHint -> {
                    List<TypeReference> parameters2 = TypeReference.listOf(((Method)this.executable).getParameterTypes());
                    return MethodHintPredicate.includes(executableHint, ((Method)this.executable).getName(), parameters2, this.executableMode);
                });
            };
        }
    }

    public static class FieldHintPredicate
    implements Predicate<RuntimeHints> {
        private final Field field;

        FieldHintPredicate(Field field) {
            this.field = field;
        }

        @Override
        public boolean test(RuntimeHints runtimeHints) {
            TypeHint typeHint = runtimeHints.reflection().getTypeHint(this.field.getDeclaringClass());
            if (typeHint == null) {
                return false;
            }
            return this.memberCategoryMatch(typeHint) || this.exactMatch(typeHint);
        }

        private boolean memberCategoryMatch(TypeHint typeHint) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                return typeHint.getMemberCategories().contains((Object)MemberCategory.PUBLIC_FIELDS);
            }
            return typeHint.getMemberCategories().contains((Object)MemberCategory.DECLARED_FIELDS);
        }

        private boolean exactMatch(TypeHint typeHint) {
            return typeHint.fields().anyMatch(fieldHint -> this.field.getName().equals(fieldHint.getName()));
        }
    }

    public static abstract class ExecutableHintPredicate<T extends Executable>
    implements Predicate<RuntimeHints> {
        protected final T executable;
        protected ExecutableMode executableMode = ExecutableMode.INTROSPECT;

        ExecutableHintPredicate(T executable) {
            this.executable = executable;
        }

        public ExecutableHintPredicate<T> introspect() {
            this.executableMode = ExecutableMode.INTROSPECT;
            return this;
        }

        public ExecutableHintPredicate<T> invoke() {
            this.executableMode = ExecutableMode.INVOKE;
            return this;
        }

        abstract Predicate<RuntimeHints> exactMatch();

        static boolean includes(ExecutableHint hint, String name2, List<TypeReference> parameterTypes, ExecutableMode executableModes) {
            return hint.getName().equals(name2) && hint.getParameterTypes().equals(parameterTypes) && (hint.getMode().equals((Object)ExecutableMode.INVOKE) || !executableModes.equals((Object)ExecutableMode.INVOKE));
        }
    }
}

