/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;

public class SimpleReflectiveProcessor
implements ReflectiveProcessor {
    @Override
    public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        if (element instanceof Class) {
            Class type2 = (Class)element;
            this.registerTypeHint(hints, type2);
        } else if (element instanceof Constructor) {
            Constructor constructor2 = (Constructor)element;
            this.registerConstructorHint(hints, constructor2);
        } else if (element instanceof Field) {
            Field field = (Field)element;
            this.registerFieldHint(hints, field);
        } else if (element instanceof Method) {
            Method method2 = (Method)element;
            this.registerMethodHint(hints, method2);
        }
    }

    protected void registerTypeHint(ReflectionHints hints, Class<?> type2) {
        hints.registerType(type2, new MemberCategory[0]);
    }

    protected void registerConstructorHint(ReflectionHints hints, Constructor<?> constructor2) {
        hints.registerConstructor(constructor2, ExecutableMode.INVOKE);
    }

    protected void registerFieldHint(ReflectionHints hints, Field field) {
        hints.registerField(field);
    }

    protected void registerMethodHint(ReflectionHints hints, Method method2) {
        hints.registerMethod(method2, ExecutableMode.INVOKE);
    }
}

