/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.annotation.Reflective;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ReflectiveRuntimeHintsRegistrar {
    private final Map<Class<? extends ReflectiveProcessor>, ReflectiveProcessor> processors = new HashMap<Class<? extends ReflectiveProcessor>, ReflectiveProcessor>();

    public void registerRuntimeHints(RuntimeHints runtimeHints, Class<?> ... types) {
        HashSet<Entry> entries2 = new HashSet<Entry>();
        for (Class<?> type2 : types) {
            this.processType(entries2, type2);
            for (Class<?> implementedInterface : ClassUtils.getAllInterfacesForClass(type2)) {
                this.processType(entries2, implementedInterface);
            }
        }
        entries2.forEach(entry -> {
            AnnotatedElement element = entry.element();
            entry.processor().registerReflectionHints(runtimeHints.reflection(), element);
        });
    }

    private void processType(Set<Entry> entries2, Class<?> typeToProcess) {
        if (this.isReflective(typeToProcess)) {
            entries2.add(this.createEntry(typeToProcess));
        }
        this.doWithReflectiveConstructors(typeToProcess, constructor2 -> entries2.add(this.createEntry((AnnotatedElement)constructor2)));
        ReflectionUtils.doWithFields(typeToProcess, field -> entries2.add(this.createEntry(field)), this::isReflective);
        ReflectionUtils.doWithMethods(typeToProcess, method2 -> entries2.add(this.createEntry(method2)), this::isReflective);
    }

    private void doWithReflectiveConstructors(Class<?> typeToProcess, Consumer<Constructor<?>> consumer) {
        for (Constructor<?> constructor2 : typeToProcess.getDeclaredConstructors()) {
            if (!this.isReflective(constructor2)) continue;
            consumer.accept(constructor2);
        }
    }

    private boolean isReflective(AnnotatedElement element) {
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Reflective.class);
    }

    private Entry createEntry(AnnotatedElement element) {
        List<ReflectiveProcessor> processors = MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(Reflective.class).map(annotation -> annotation.getClassArray("value")).flatMap(Arrays::stream).distinct().map(type2 -> type2).map(processorClass -> this.processors.computeIfAbsent((Class<? extends ReflectiveProcessor>)processorClass, this::instantiateClass)).toList();
        ReflectiveProcessor processorToUse = processors.size() == 1 ? processors.get(0) : new DelegatingReflectiveProcessor(processors);
        return new Entry(element, processorToUse);
    }

    private ReflectiveProcessor instantiateClass(Class<? extends ReflectiveProcessor> type2) {
        try {
            Constructor<? extends ReflectiveProcessor> constructor2 = type2.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(constructor2);
            return constructor2.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate " + type2, ex);
        }
    }

    private record Entry(AnnotatedElement element, ReflectiveProcessor processor) {
    }

    private static class DelegatingReflectiveProcessor
    implements ReflectiveProcessor {
        private final Iterable<ReflectiveProcessor> processors;

        DelegatingReflectiveProcessor(Iterable<ReflectiveProcessor> processors) {
            this.processors = processors;
        }

        @Override
        public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
            this.processors.forEach(processor -> processor.registerReflectionHints(hints, element));
        }
    }
}

