/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import org.springframework.aot.hint.AbstractTypeReference;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class ReflectionTypeReference
extends AbstractTypeReference {
    private final Class<?> type;

    private ReflectionTypeReference(Class<?> type2) {
        super(type2.getPackageName(), type2.getSimpleName(), ReflectionTypeReference.getEnclosingClass(type2));
        this.type = type2;
    }

    @Nullable
    private static TypeReference getEnclosingClass(Class<?> type2) {
        Class<?> candidate = type2.isArray() ? ((Class)type2.componentType()).getEnclosingClass() : type2.getEnclosingClass();
        return candidate != null ? new ReflectionTypeReference(candidate) : null;
    }

    static ReflectionTypeReference of(Class<?> type2) {
        Assert.notNull(type2, "'type' must not be null");
        Assert.notNull((Object)type2.getCanonicalName(), "'type.getCanonicalName()' must not be null");
        return new ReflectionTypeReference(type2);
    }

    @Override
    public String getCanonicalName() {
        return this.type.getCanonicalName();
    }

    @Override
    protected boolean isPrimitive() {
        return this.type.isPrimitive() || this.type.isArray() && ((Class)this.type.componentType()).isPrimitive();
    }
}

