/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ReflectionHints {
    private final Map<TypeReference, TypeHint.Builder> types = new HashMap<TypeReference, TypeHint.Builder>();

    public Stream<TypeHint> typeHints() {
        return this.types.values().stream().map(TypeHint.Builder::build);
    }

    @Nullable
    public TypeHint getTypeHint(TypeReference type2) {
        TypeHint.Builder typeHintBuilder = this.types.get(type2);
        return typeHintBuilder != null ? typeHintBuilder.build() : null;
    }

    @Nullable
    public TypeHint getTypeHint(Class<?> type2) {
        return this.getTypeHint(TypeReference.of(type2));
    }

    public ReflectionHints registerType(TypeReference type2, Consumer<TypeHint.Builder> typeHint) {
        TypeHint.Builder builder = this.types.computeIfAbsent(type2, TypeHint.Builder::new);
        typeHint.accept(builder);
        return this;
    }

    public ReflectionHints registerType(TypeReference type2, MemberCategory ... memberCategories) {
        return this.registerType(type2, TypeHint.builtWith(memberCategories));
    }

    public ReflectionHints registerType(Class<?> type2, Consumer<TypeHint.Builder> typeHint) {
        Assert.notNull(type2, "'type' must not be null");
        if (type2.getCanonicalName() != null) {
            this.registerType(TypeReference.of(type2), typeHint);
        }
        return this;
    }

    public ReflectionHints registerType(Class<?> type2, MemberCategory ... memberCategories) {
        Assert.notNull(type2, "'type' must not be null");
        if (type2.getCanonicalName() != null) {
            this.registerType(TypeReference.of(type2), memberCategories);
        }
        return this;
    }

    public ReflectionHints registerTypeIfPresent(@Nullable ClassLoader classLoader, String typeName, Consumer<TypeHint.Builder> typeHint) {
        if (ClassUtils.isPresent(typeName, classLoader)) {
            this.registerType(TypeReference.of(typeName), typeHint);
        }
        return this;
    }

    public ReflectionHints registerTypeIfPresent(@Nullable ClassLoader classLoader, String typeName, MemberCategory ... memberCategories) {
        return this.registerTypeIfPresent(classLoader, typeName, TypeHint.builtWith(memberCategories));
    }

    public ReflectionHints registerTypes(Iterable<TypeReference> types, Consumer<TypeHint.Builder> typeHint) {
        types.forEach(type2 -> this.registerType((TypeReference)type2, typeHint));
        return this;
    }

    public ReflectionHints registerField(Field field) {
        return this.registerType(TypeReference.of(field.getDeclaringClass()), (TypeHint.Builder typeHint) -> typeHint.withField(field.getName()));
    }

    public ReflectionHints registerConstructor(Constructor<?> constructor2, ExecutableMode mode2) {
        return this.registerType(TypeReference.of(constructor2.getDeclaringClass()), (TypeHint.Builder typeHint) -> typeHint.withConstructor(this.mapParameters(constructor2), mode2));
    }

    public ReflectionHints registerMethod(Method method2, ExecutableMode mode2) {
        return this.registerType(TypeReference.of(method2.getDeclaringClass()), (TypeHint.Builder typeHint) -> typeHint.withMethod(method2.getName(), this.mapParameters(method2), mode2));
    }

    private List<TypeReference> mapParameters(Executable executable) {
        return TypeReference.listOf(executable.getParameterTypes());
    }
}

