/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class ExecutableHint
extends MemberHint
implements Comparable<ExecutableHint> {
    private final List<TypeReference> parameterTypes;
    private final ExecutableMode mode;

    private ExecutableHint(Builder builder) {
        super(builder.name);
        this.parameterTypes = List.copyOf(builder.parameterTypes);
        this.mode = builder.mode != null ? builder.mode : ExecutableMode.INVOKE;
    }

    static Builder ofConstructor(List<TypeReference> parameterTypes) {
        return new Builder("<init>", parameterTypes);
    }

    static Builder ofMethod(String name2, List<TypeReference> parameterTypes) {
        return new Builder(name2, parameterTypes);
    }

    public List<TypeReference> getParameterTypes() {
        return this.parameterTypes;
    }

    public ExecutableMode getMode() {
        return this.mode;
    }

    public static Consumer<Builder> builtWith(ExecutableMode mode2) {
        return builder -> builder.withMode(mode2);
    }

    @Override
    public int compareTo(ExecutableHint other) {
        return Comparator.comparing(MemberHint::getName, String::compareToIgnoreCase).thenComparing(ExecutableHint::getParameterTypes, Comparator.comparingInt(List::size)).thenComparing(ExecutableHint::getParameterTypes, (params1, params2) -> {
            String left2 = params1.stream().map(TypeReference::getCanonicalName).collect(Collectors.joining(","));
            String right = params2.stream().map(TypeReference::getCanonicalName).collect(Collectors.joining(","));
            return left2.compareTo(right);
        }).compare(this, other);
    }

    public static class Builder {
        private final String name;
        private final List<TypeReference> parameterTypes;
        @Nullable
        private ExecutableMode mode;

        Builder(String name2, List<TypeReference> parameterTypes) {
            this.name = name2;
            this.parameterTypes = parameterTypes;
        }

        public Builder withMode(ExecutableMode mode2) {
            Assert.notNull((Object)mode2, "'mode' must not be null");
            if (this.mode == null || !this.mode.includes(mode2)) {
                this.mode = mode2;
            }
            return this;
        }

        ExecutableHint build() {
            return new ExecutableHint(this);
        }
    }
}

