/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.springframework.aot.generate.ClassNameGenerator;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.TypeSpec;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GeneratedClasses {
    private final ClassNameGenerator classNameGenerator;
    private final List<GeneratedClass> classes;
    private final Map<Owner, GeneratedClass> classesByOwner;

    GeneratedClasses(ClassNameGenerator classNameGenerator) {
        this(classNameGenerator, new ArrayList<GeneratedClass>(), new ConcurrentHashMap<Owner, GeneratedClass>());
    }

    private GeneratedClasses(ClassNameGenerator classNameGenerator, List<GeneratedClass> classes, Map<Owner, GeneratedClass> classesByOwner) {
        Assert.notNull((Object)classNameGenerator, "'classNameGenerator' must not be null");
        this.classNameGenerator = classNameGenerator;
        this.classes = classes;
        this.classesByOwner = classesByOwner;
    }

    public GeneratedClass getOrAddForFeature(String featureName, Consumer<TypeSpec.Builder> type2) {
        Assert.hasLength(featureName, "'featureName' must not be empty");
        Assert.notNull(type2, "'type' must not be null");
        Owner owner2 = new Owner(this.classNameGenerator.getFeatureNamePrefix(), featureName, null);
        GeneratedClass generatedClass = this.classesByOwner.computeIfAbsent(owner2, key2 -> this.createAndAddGeneratedClass(featureName, null, type2));
        generatedClass.assertSameType(type2);
        return generatedClass;
    }

    public GeneratedClass getOrAddForFeatureComponent(String featureName, ClassName targetComponent, Consumer<TypeSpec.Builder> type2) {
        Assert.hasLength(featureName, "'featureName' must not be empty");
        Assert.notNull((Object)targetComponent, "'targetComponent' must not be null");
        Assert.notNull(type2, "'type' must not be null");
        Owner owner2 = new Owner(this.classNameGenerator.getFeatureNamePrefix(), featureName, targetComponent);
        GeneratedClass generatedClass = this.classesByOwner.computeIfAbsent(owner2, key2 -> this.createAndAddGeneratedClass(featureName, targetComponent, type2));
        generatedClass.assertSameType(type2);
        return generatedClass;
    }

    public GeneratedClass getOrAddForFeatureComponent(String featureName, Class<?> targetComponent, Consumer<TypeSpec.Builder> type2) {
        return this.getOrAddForFeatureComponent(featureName, ClassName.get(targetComponent), type2);
    }

    public GeneratedClass addForFeature(String featureName, Consumer<TypeSpec.Builder> type2) {
        Assert.hasLength(featureName, "'featureName' must not be empty");
        Assert.notNull(type2, "'type' must not be null");
        return this.createAndAddGeneratedClass(featureName, null, type2);
    }

    public GeneratedClass addForFeatureComponent(String featureName, ClassName targetComponent, Consumer<TypeSpec.Builder> type2) {
        Assert.hasLength(featureName, "'featureName' must not be empty");
        Assert.notNull((Object)targetComponent, "'targetComponent' must not be null");
        Assert.notNull(type2, "'type' must not be null");
        return this.createAndAddGeneratedClass(featureName, targetComponent, type2);
    }

    public GeneratedClass addForFeatureComponent(String featureName, Class<?> targetComponent, Consumer<TypeSpec.Builder> type2) {
        return this.addForFeatureComponent(featureName, ClassName.get(targetComponent), type2);
    }

    private GeneratedClass createAndAddGeneratedClass(String featureName, @Nullable ClassName targetComponent, Consumer<TypeSpec.Builder> type2) {
        ClassName className = this.classNameGenerator.generateClassName(featureName, targetComponent);
        GeneratedClass generatedClass = new GeneratedClass(className, type2);
        this.classes.add(generatedClass);
        return generatedClass;
    }

    void writeTo(GeneratedFiles generatedFiles) {
        Assert.notNull((Object)generatedFiles, "'generatedFiles' must not be null");
        ArrayList<GeneratedClass> generatedClasses = new ArrayList<GeneratedClass>(this.classes);
        generatedClasses.sort(Comparator.comparing(GeneratedClass::getName));
        for (GeneratedClass generatedClass : generatedClasses) {
            generatedFiles.addSourceFile(generatedClass.generateJavaFile());
        }
    }

    GeneratedClasses withFeatureNamePrefix(String featureNamePrefix) {
        return new GeneratedClasses(this.classNameGenerator.withFeatureNamePrefix(featureNamePrefix), this.classes, this.classesByOwner);
    }

    private record Owner(String featureNamePrefix, String featureName, @Nullable ClassName target) {
    }
}

