/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.springframework.aot.generate.Generated;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.MethodName;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.JavaFile;
import org.springframework.javapoet.TypeSpec;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class GeneratedClass {
    @Nullable
    private final GeneratedClass enclosingClass;
    private final ClassName name;
    private final GeneratedMethods methods;
    private final Consumer<TypeSpec.Builder> type;
    private final Map<ClassName, GeneratedClass> declaredClasses;
    private final Map<MethodName, AtomicInteger> methodNameSequenceGenerator;

    GeneratedClass(ClassName name2, Consumer<TypeSpec.Builder> type2) {
        this(null, name2, type2);
    }

    private GeneratedClass(@Nullable GeneratedClass enclosingClass, ClassName name2, Consumer<TypeSpec.Builder> type2) {
        this.enclosingClass = enclosingClass;
        this.name = name2;
        this.type = type2;
        this.methods = new GeneratedMethods(name2, this::generateSequencedMethodName);
        this.declaredClasses = new ConcurrentHashMap<ClassName, GeneratedClass>();
        this.methodNameSequenceGenerator = new ConcurrentHashMap<MethodName, AtomicInteger>();
    }

    public void reserveMethodNames(String ... reservedMethodNames) {
        for (String reservedMethodName : reservedMethodNames) {
            String generatedName = this.generateSequencedMethodName(MethodName.of(reservedMethodNames));
            Assert.state(generatedName.equals(reservedMethodName), () -> String.format("Unable to reserve method name '%s'", reservedMethodName));
        }
    }

    private String generateSequencedMethodName(MethodName name2) {
        int sequence = this.methodNameSequenceGenerator.computeIfAbsent(name2, key2 -> new AtomicInteger()).getAndIncrement();
        return sequence > 0 ? name2.toString() + sequence : name2.toString();
    }

    @Nullable
    public GeneratedClass getEnclosingClass() {
        return this.enclosingClass;
    }

    public ClassName getName() {
        return this.name;
    }

    public GeneratedMethods getMethods() {
        return this.methods;
    }

    public GeneratedClass getOrAdd(String name2, Consumer<TypeSpec.Builder> type2) {
        ClassName className = this.name.nestedClass(name2);
        return this.declaredClasses.computeIfAbsent(className, key2 -> new GeneratedClass(this, className, type2));
    }

    JavaFile generateJavaFile() {
        Assert.state(this.getEnclosingClass() == null, "Java file cannot be generated for an inner class");
        TypeSpec.Builder type2 = this.apply();
        return JavaFile.builder(this.name.packageName(), type2.build()).build();
    }

    private TypeSpec.Builder apply() {
        TypeSpec.Builder type2 = this.getBuilder(this.type);
        type2.addAnnotation(Generated.class);
        this.methods.doWithMethodSpecs(type2::addMethod);
        this.declaredClasses.values().forEach(declaredClass -> type2.addType(declaredClass.apply().build()));
        return type2;
    }

    private TypeSpec.Builder getBuilder(Consumer<TypeSpec.Builder> type2) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(this.name);
        type2.accept(builder);
        return builder;
    }

    void assertSameType(Consumer<TypeSpec.Builder> type2) {
        Assert.state(type2 == this.type || this.getBuilder(this.type).build().equals(this.getBuilder(type2).build()), "'type' consumer generated different result");
    }
}

